/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dex;

import com.tencent.tinker.android.dex.Leb128;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.util.CompareUtils;

public final class ClassData
extends TableOfContents.Section.Item<ClassData> {
    public Field[] staticFields;
    public Field[] instanceFields;
    public Method[] directMethods;
    public Method[] virtualMethods;

    public ClassData(int off, Field[] staticFields, Field[] instanceFields, Method[] directMethods, Method[] virtualMethods) {
        super(off);
        this.staticFields = staticFields;
        this.instanceFields = instanceFields;
        this.directMethods = directMethods;
        this.virtualMethods = virtualMethods;
    }

    @Override
    public int compareTo(ClassData other) {
        int res = CompareUtils.aArrCompare((Comparable[])this.staticFields, (Comparable[])other.staticFields);
        if (res != 0) {
            return res;
        }
        res = CompareUtils.aArrCompare((Comparable[])this.instanceFields, (Comparable[])other.instanceFields);
        if (res != 0) {
            return res;
        }
        res = CompareUtils.aArrCompare((Comparable[])this.directMethods, (Comparable[])other.directMethods);
        if (res != 0) {
            return res;
        }
        return CompareUtils.aArrCompare((Comparable[])this.virtualMethods, (Comparable[])other.virtualMethods);
    }

    @Override
    public int byteCountInDex() {
        int res = Leb128.unsignedLeb128Size(this.staticFields.length);
        res += Leb128.unsignedLeb128Size(this.instanceFields.length);
        res += Leb128.unsignedLeb128Size(this.directMethods.length);
        res += Leb128.unsignedLeb128Size(this.virtualMethods.length);
        res += this.calcFieldsSize(this.staticFields);
        res += this.calcFieldsSize(this.instanceFields);
        res += this.calcMethodsSize(this.directMethods);
        return res += this.calcMethodsSize(this.virtualMethods);
    }

    private int calcFieldsSize(Field[] fields) {
        int res = 0;
        int prevFieldIndex = 0;
        for (Field field : fields) {
            int fieldIndexDelta = field.fieldIndex - prevFieldIndex;
            prevFieldIndex = field.fieldIndex;
            res += Leb128.unsignedLeb128Size(fieldIndexDelta) + Leb128.unsignedLeb128Size(field.accessFlags);
        }
        return res;
    }

    private int calcMethodsSize(Method[] methods) {
        int res = 0;
        int prevMethodIndex = 0;
        for (Method method : methods) {
            int methodIndexDelta = method.methodIndex - prevMethodIndex;
            prevMethodIndex = method.methodIndex;
            res += Leb128.unsignedLeb128Size(methodIndexDelta) + Leb128.unsignedLeb128Size(method.accessFlags) + Leb128.unsignedLeb128Size(method.codeOffset);
        }
        return res;
    }

    public static class Method
    implements Comparable<Method> {
        public int methodIndex;
        public int accessFlags;
        public int codeOffset;

        public Method(int methodIndex, int accessFlags, int codeOffset) {
            this.methodIndex = methodIndex;
            this.accessFlags = accessFlags;
            this.codeOffset = codeOffset;
        }

        @Override
        public int compareTo(Method other) {
            int res = CompareUtils.uCompare(this.methodIndex, other.methodIndex);
            if (res != 0) {
                return res;
            }
            res = CompareUtils.sCompare(this.accessFlags, other.accessFlags);
            if (res != 0) {
                return res;
            }
            return CompareUtils.sCompare(this.codeOffset, other.codeOffset);
        }
    }

    public static class Field
    implements Comparable<Field> {
        public int fieldIndex;
        public int accessFlags;

        public Field(int fieldIndex, int accessFlags) {
            this.fieldIndex = fieldIndex;
            this.accessFlags = accessFlags;
        }

        @Override
        public int compareTo(Field other) {
            int res = CompareUtils.uCompare(this.fieldIndex, other.fieldIndex);
            if (res != 0) {
                return res;
            }
            return CompareUtils.sCompare(this.accessFlags, other.accessFlags);
        }
    }
}

