/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk.download;

import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicSessionStream;
import com.tencent.sonic.sdk.SonicUtils;
import com.tencent.sonic.sdk.download.SonicDownloadCallback;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;

public class SonicDownloadClient
implements SonicSessionStream.Callback {
    public static final String TAG = "SonicSdk_SonicDownloadClient";
    private static final int READ_BUFFER_SIZE = 2048;
    private final SonicDownloadConnection mConn;
    private DownloadTask mTask;
    private ByteArrayOutputStream mOutputStream;
    private boolean mDownloadFinished = false;

    public SonicDownloadClient(DownloadTask task) {
        this.mTask = task;
        this.mConn = new SonicDownloadConnection(task.mResourceUrl);
        this.mOutputStream = new ByteArrayOutputStream();
    }

    public int download() {
        this.onStart();
        int resultCode = this.mConn.connect();
        if (0 != resultCode) {
            this.onError(resultCode);
            return resultCode;
        }
        int responseCode = this.mConn.getResponseCode();
        if (responseCode != 200) {
            this.onError(responseCode);
            return responseCode;
        }
        this.mTask.mRspHeaders = this.mConn.getResponseHeaderFields();
        if (this.getResponseStream(this.mTask.mWasInterceptInvoked)) {
            return 0;
        }
        return -1;
    }

    private boolean readServerResponse(AtomicBoolean breakCondition) {
        BufferedInputStream bufferedInputStream = this.mConn.getResponseStream();
        if (null == bufferedInputStream) {
            SonicUtils.log(TAG, 6, "readServerResponse error: bufferedInputStream is null!");
            return false;
        }
        try {
            byte[] buffer = new byte[2048];
            int total = this.mConn.connectionImpl.getContentLength();
            int n = 0;
            int sum = 0;
            while (!(breakCondition != null && breakCondition.get() || -1 == (n = bufferedInputStream.read(buffer)))) {
                this.mOutputStream.write(buffer, 0, n);
                sum += n;
                if (total <= 0) continue;
                this.onProgress(sum, total);
            }
            if (n == -1) {
                this.mDownloadFinished = true;
                this.onSuccess(this.mOutputStream.toByteArray(), this.mConn.getResponseHeaderFields());
            }
        }
        catch (Exception e) {
            SonicUtils.log(TAG, 6, "readServerResponse error:" + e.getMessage() + ".");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean getResponseStream(AtomicBoolean breakConditions) {
        if (this.readServerResponse(breakConditions)) {
            BufferedInputStream netStream = this.mDownloadFinished ? null : this.mConn.getResponseStream();
            this.mTask.mInputStream = new SonicSessionStream(this, this.mOutputStream, netStream);
            AtomicBoolean atomicBoolean = this.mTask.mWasInterceptInvoked;
            synchronized (atomicBoolean) {
                this.mTask.mWasInterceptInvoked.notify();
            }
            if (this.mDownloadFinished) {
                SonicUtils.log(TAG, 4, "sub resource compose a memory stream (" + this.mTask.mResourceUrl + ").");
            } else {
                SonicUtils.log(TAG, 4, "sub resource compose a bridge stream (" + this.mTask.mResourceUrl + ").");
            }
            return true;
        }
        return false;
    }

    @Override
    public void onClose(boolean readComplete, ByteArrayOutputStream outputStream) {
        SonicUtils.log(TAG, 4, "sub resource bridge stream on close(" + this.mTask.mResourceUrl + ").");
        if (!this.mDownloadFinished) {
            this.onSuccess(outputStream.toByteArray(), this.mConn.getResponseHeaderFields());
        }
    }

    private void onStart() {
        for (SonicDownloadCallback callback : this.mTask.mCallbacks) {
            if (callback == null) continue;
            callback.onStart();
        }
    }

    private void onProgress(int pro, int total) {
        for (SonicDownloadCallback callback : this.mTask.mCallbacks) {
            if (callback == null) continue;
            callback.onProgress(pro, total);
        }
    }

    private void onSuccess(byte[] content, Map<String, List<String>> rspHeaders) {
        for (SonicDownloadCallback callback : this.mTask.mCallbacks) {
            if (callback == null) continue;
            callback.onSuccess(content, rspHeaders);
        }
        this.onFinish();
    }

    private void onError(int errCode) {
        for (SonicDownloadCallback callback : this.mTask.mCallbacks) {
            if (callback == null) continue;
            callback.onError(errCode);
        }
        this.onFinish();
    }

    private void onFinish() {
        for (SonicDownloadCallback callback : this.mTask.mCallbacks) {
            if (callback == null) continue;
            callback.onFinish();
        }
        this.mConn.disconnect();
    }

    public static class SubResourceDownloadCallback
    extends SonicDownloadCallback.SimpleDownloadCallback {
        private String resourceUrl;

        public SubResourceDownloadCallback(String url) {
            this.resourceUrl = url;
        }

        @Override
        public void onStart() {
            if (SonicUtils.shouldLog(4)) {
                SonicUtils.log(SonicDownloadClient.TAG, 4, "session start download sub resource, url=" + this.resourceUrl);
            }
        }

        @Override
        public void onSuccess(byte[] content, Map<String, List<String>> rspHeaders) {
            String fileName = SonicUtils.getMD5(this.resourceUrl);
            SonicUtils.saveResourceFiles(fileName, content, rspHeaders);
            SonicUtils.saveSonicResourceData(this.resourceUrl, SonicUtils.getSHA1(content), content.length);
        }

        @Override
        public void onError(int errorCode) {
            if (SonicUtils.shouldLog(4)) {
                SonicUtils.log(SonicDownloadClient.TAG, 4, "session download sub resource error: code = " + errorCode + ", url=" + this.resourceUrl);
            }
        }
    }

    public class SonicDownloadConnection {
        final URLConnection connectionImpl;
        private String url;
        private BufferedInputStream responseStream;

        public SonicDownloadConnection(String url) {
            this.url = url;
            this.connectionImpl = this.createConnection();
            this.initConnection(this.connectionImpl);
        }

        URLConnection createConnection() {
            String currentUrl = this.url;
            if (TextUtils.isEmpty((CharSequence)currentUrl)) {
                return null;
            }
            URLConnection connection = null;
            try {
                URL url = new URL(currentUrl);
                String originHost = null;
                if (!TextUtils.isEmpty((CharSequence)((SonicDownloadClient)SonicDownloadClient.this).mTask.mIpAddress)) {
                    originHost = url.getHost();
                    url = new URL(currentUrl.replace(originHost, ((SonicDownloadClient)SonicDownloadClient.this).mTask.mIpAddress));
                    SonicUtils.log(SonicDownloadClient.TAG, 4, "create UrlConnection with DNS-Prefetch(" + originHost + " -> " + ((SonicDownloadClient)SonicDownloadClient.this).mTask.mIpAddress + ").");
                }
                if ((connection = url.openConnection()) != null && !TextUtils.isEmpty((CharSequence)originHost)) {
                    connection.setRequestProperty("Host", originHost);
                }
            }
            catch (Throwable e) {
                if (connection != null) {
                    connection = null;
                }
                SonicUtils.log(SonicDownloadClient.TAG, 6, "create UrlConnection fail, error:" + e.getMessage() + ".");
            }
            return connection;
        }

        boolean initConnection(URLConnection connection) {
            if (null != connection) {
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(15000);
                connection.setRequestProperty("method", "GET");
                connection.setRequestProperty("Accept-Encoding", "gzip");
                connection.setRequestProperty("Accept-Language", "zh-CN,zh;");
                if (!TextUtils.isEmpty((CharSequence)((SonicDownloadClient)SonicDownloadClient.this).mTask.mCookie)) {
                    connection.setRequestProperty("Cookie", ((SonicDownloadClient)SonicDownloadClient.this).mTask.mCookie);
                }
                return true;
            }
            return false;
        }

        synchronized int connect() {
            if (this.connectionImpl instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.connectionImpl;
                try {
                    httpURLConnection.connect();
                    return 0;
                }
                catch (IOException e) {
                    return -901;
                }
            }
            return -1;
        }

        public void disconnect() {
            if (this.connectionImpl instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.connectionImpl;
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception e) {
                    SonicUtils.log(SonicDownloadClient.TAG, 6, "disconnect error:" + e.getMessage());
                }
            }
        }

        BufferedInputStream getResponseStream() {
            if (null == this.responseStream && null != this.connectionImpl) {
                try {
                    InputStream inputStream = this.connectionImpl.getInputStream();
                    this.responseStream = "gzip".equalsIgnoreCase(this.connectionImpl.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(inputStream)) : new BufferedInputStream(inputStream);
                }
                catch (Throwable e) {
                    SonicUtils.log(SonicDownloadClient.TAG, 6, "getResponseStream error:" + e.getMessage() + ".");
                }
            }
            return this.responseStream;
        }

        int getResponseCode() {
            if (this.connectionImpl instanceof HttpURLConnection) {
                try {
                    return ((HttpURLConnection)this.connectionImpl).getResponseCode();
                }
                catch (IOException e) {
                    String errMsg = e.getMessage();
                    SonicUtils.log(SonicDownloadClient.TAG, 6, "getResponseCode error:" + errMsg);
                    return -901;
                }
            }
            return -1;
        }

        Map<String, List<String>> getResponseHeaderFields() {
            if (null == this.connectionImpl) {
                return null;
            }
            return this.connectionImpl.getHeaderFields();
        }
    }

    public static class DownloadTask {
        public static final int STATE_INITIATE = 0;
        public static final int STATE_QUEUEING = 1;
        public static final int STATE_DOWNLOADING = 2;
        public static final int STATE_DOWNLOADED = 3;
        public static final int STATE_LOAD_FROM_CACHE = 4;
        public String mResourceUrl;
        public String mIpAddress;
        public String mCookie;
        public Map<String, List<String>> mRspHeaders;
        public InputStream mInputStream;
        public AtomicInteger mState = new AtomicInteger(0);
        public final AtomicBoolean mWasInterceptInvoked = new AtomicBoolean(false);
        public List<SonicDownloadCallback> mCallbacks = new ArrayList<SonicDownloadCallback>();
    }
}

