/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk.download;

import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicResourceDataHelper;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.File;
import java.util.List;
import java.util.Map;

public abstract class SonicDownloadCache {
    public abstract byte[] getResourceCache(String var1);

    public abstract Map<String, List<String>> getResourceCacheHeader(String var1);

    public static SonicDownloadCache getSubResourceCache() {
        return new SonicResourceCache();
    }

    public static class SonicResourceCache
    extends SonicDownloadCache {
        public static final String TAG = "SonicSdk_SonicDownloadCache";

        @Override
        public byte[] getResourceCache(String resourceUrl) {
            boolean verifyError;
            if (TextUtils.isEmpty((CharSequence)resourceUrl)) {
                return null;
            }
            String resourceId = SonicUtils.getMD5(resourceUrl);
            SonicResourceDataHelper.ResourceData resourceData = SonicResourceDataHelper.getResourceData(resourceId);
            if (resourceData.expiredTime < System.currentTimeMillis()) {
                return null;
            }
            byte[] resourceBytes = null;
            if (TextUtils.isEmpty((CharSequence)resourceData.resourceSha1)) {
                verifyError = true;
                SonicUtils.log(TAG, 4, "get resource data(" + resourceUrl + "): resource data is empty.");
            } else {
                String resourcePath = SonicFileUtils.getSonicResourcePath(resourceId);
                File resourceFile = new File(resourcePath);
                resourceBytes = SonicFileUtils.readFileToBytes(resourceFile);
                boolean bl = verifyError = resourceBytes == null || resourceBytes.length <= 0;
                if (verifyError) {
                    SonicUtils.log(TAG, 6, "get resource data(" + resourceUrl + ") error:cache data is null.");
                } else if (SonicEngine.getInstance().getConfig().VERIFY_CACHE_FILE_WITH_SHA1) {
                    if (!SonicFileUtils.verifyData(resourceBytes, resourceData.resourceSha1)) {
                        verifyError = true;
                        resourceBytes = null;
                        SonicUtils.log(TAG, 6, "get resource data(" + resourceUrl + ") error:verify html cache with sha1 fail.");
                    } else {
                        SonicUtils.log(TAG, 4, "get resource data(" + resourceUrl + ") verify html cache with sha1 success.");
                    }
                } else if (resourceData.resourceSize != resourceFile.length()) {
                    verifyError = true;
                    resourceBytes = null;
                    SonicUtils.log(TAG, 6, "get resource data(" + resourceUrl + ") error:verify html cache with size fail.");
                }
            }
            if (verifyError) {
                long startTime = System.currentTimeMillis();
                SonicUtils.removeResourceCache(resourceId);
                resourceData.reset();
                SonicUtils.log(TAG, 4, "get resource data(" + resourceUrl + ") :verify error so remove session cache, cost " + (System.currentTimeMillis() - startTime) + "ms.");
            }
            return resourceBytes;
        }

        @Override
        public Map<String, List<String>> getResourceCacheHeader(String resourceUrl) {
            String resourceName = SonicUtils.getMD5(resourceUrl);
            String headerPath = SonicFileUtils.getSonicResourceHeaderPath(resourceName);
            return SonicFileUtils.getHeaderFromLocalCache(headerPath);
        }
    }
}

