/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicDiffDataCallback;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionCallback;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class StandardSonicSession
extends SonicSession
implements Handler.Callback {
    private static final String TAG = "SonicSdk_StandardSonicSession";
    private static final String TEMPLATE_CHANGE_BUNDLE_PARAMS_REFRESH = "refresh";
    private static final int CLIENT_CORE_MSG_BEGIN = 4;
    private static final int CLIENT_MSG_CLIENT_READY = 5;
    private final Object webResponseLock = new Object();
    private final AtomicBoolean isCachePendingStream = new AtomicBoolean(false);

    StandardSonicSession(String id, String url, SonicSessionConfig config) {
        super(id, url, config);
    }

    @Override
    public int getSrcResultCode() {
        return this.srcResultCode;
    }

    @Override
    public boolean handleMessage(Message msg) {
        if (super.handleMessage(msg)) {
            return true;
        }
        switch (msg.what) {
            case 5: {
                this.sessionClient.loadUrl(this.srcUrl, new Bundle());
                break;
            }
            case 1: {
                Bundle data;
                if (msg.arg2 == 200) {
                    Bundle data2 = msg.getData();
                    this.pendingDiffData = data2.getString("_diff_data_");
                } else if (msg.arg2 == 2000 && (data = msg.getData()).getBoolean(TEMPLATE_CHANGE_BUNDLE_PARAMS_REFRESH, false)) {
                    SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:load url with preload=2, webCallback is null? ->" + (null != this.diffDataCallback));
                    this.sessionClient.loadUrl(this.srcUrl, null);
                }
                this.setResult(msg.arg1, msg.arg2, true);
                break;
            }
            case 2: {
                this.diffDataCallback = (SonicDiffDataCallback)msg.obj;
                this.setResult(this.srcResultCode, this.finalResultCode, true);
                break;
            }
            default: {
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "session(" + this.sId + ") can not  recognize refresh type: " + msg.what);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onClientReady() {
        if (0 == this.sessionState.get()) {
            this.start();
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.sessionClient.loadUrl(this.srcUrl, new Bundle());
        } else {
            Message msg = this.mainHandler.obtainMessage(5);
            this.mainHandler.sendMessage(msg);
        }
        return true;
    }

    @Override
    public boolean onWebReady(SonicDiffDataCallback callback) {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") onWebReady: webCallback has set ? ->" + (null != this.diffDataCallback));
        if (null != this.diffDataCallback) {
            this.diffDataCallback = null;
            SonicUtils.log(TAG, 5, "session(" + this.sId + ") onWebReady: call more than once.");
        }
        Message msg = Message.obtain();
        msg.what = 2;
        msg.obj = callback;
        this.mainHandler.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object onRequestResource(String url) {
        Object object;
        if (!this.isMatchCurrentUrl(url)) {
            return null;
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ")  onClientRequestResource:url = " + url);
        }
        this.wasInterceptInvoked.set(true);
        long startTime = System.currentTimeMillis();
        if (this.sessionState.get() == 1) {
            object = this.sessionState;
            synchronized (object) {
                try {
                    if (this.sessionState.get() == 1) {
                        SonicUtils.log(TAG, 4, "session(" + this.sId + ") now wait for pendingWebResourceStream!");
                        this.sessionState.wait(30000L);
                    }
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") wait for pendingWebResourceStream failed" + e.getMessage());
                }
            }
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") is not in running state: " + this.sessionState);
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") have pending stream? -> " + (this.pendingWebResourceStream != null) + ", cost " + (System.currentTimeMillis() - startTime) + "ms.");
        object = this.webResponseLock;
        synchronized (object) {
            if (null != this.pendingWebResourceStream) {
                Object webResourceResponse;
                if (!this.isDestroyedOrWaitingForDestroy()) {
                    String mime = SonicUtils.getMime(this.srcUrl);
                    webResourceResponse = SonicEngine.getInstance().getRuntime().createWebResourceResponse(mime, this.isCachePendingStream.get() ? SonicUtils.DEFAULT_CHARSET : this.getCharsetFromHeaders(), this.pendingWebResourceStream, this.isCachePendingStream.get() ? this.getCacheHeaders() : this.getHeaders());
                } else {
                    webResourceResponse = null;
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") onClientRequestResource error: session is destroyed!");
                }
                this.pendingWebResourceStream = null;
                return webResourceResponse;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleFlow_LoadLocalCache(String localHtml) {
        if (!TextUtils.isEmpty((CharSequence)localHtml)) {
            Iterator iterator = this.webResponseLock;
            synchronized (iterator) {
                this.pendingWebResourceStream = new ByteArrayInputStream(localHtml.getBytes());
                this.isCachePendingStream.set(true);
            }
            this.switchState(1, 2, true);
        }
        for (WeakReference ref : this.sessionCallbackList) {
            SonicSessionCallback callback = (SonicSessionCallback)ref.get();
            if (callback == null) continue;
            callback.onSessionLoadLocalCache(localHtml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handleFlow_TemplateChange(String newHtml) {
        try {
            SonicUtils.log(TAG, 4, "handleFlow_TemplateChange.");
            long startTime = System.currentTimeMillis();
            String htmlString = newHtml;
            if (TextUtils.isEmpty((CharSequence)htmlString)) {
                this.pendingWebResourceStream = this.server.getResponseStream(this.wasOnPageFinishInvoked);
                if (this.pendingWebResourceStream == null) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_TemplateChange error:server.getResponseStream = null!");
                    return;
                }
                htmlString = this.server.getResponseData(false);
            }
            String cacheOffline = this.server.getResponseHeaderField("cache-offline");
            Message msg = this.mainHandler.obtainMessage(1);
            msg.arg2 = 2000;
            msg.arg1 = 2000;
            Iterator iterator = this.webResponseLock;
            synchronized (iterator) {
                if (!this.wasInterceptInvoked.get()) {
                    if (TextUtils.isEmpty((CharSequence)htmlString)) {
                        SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_TemplateChange error:responseDataTuple not complete!");
                        return;
                    }
                    msg.arg2 = 304;
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_TemplateChange:oh yeah, templateChange load hit 304.");
                } else if (SonicUtils.needRefreshPage(cacheOffline)) {
                    Bundle data = new Bundle();
                    data.putBoolean(TEMPLATE_CHANGE_BUNDLE_PARAMS_REFRESH, true);
                    msg.setData(data);
                } else {
                    msg.arg2 = 304;
                }
                this.isCachePendingStream.set(false);
            }
            this.mainHandler.sendMessage(msg);
            for (WeakReference ref : this.sessionCallbackList) {
                SonicSessionCallback callback = (SonicSessionCallback)ref.get();
                if (callback == null) continue;
                callback.onSessionTemplateChanged(htmlString);
            }
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") read byte stream cost " + (System.currentTimeMillis() - startTime) + " ms, wasInterceptInvoked: " + this.wasInterceptInvoked.get());
            }
            if (SonicUtils.needSaveData(this.config.SUPPORT_CACHE_CONTROL, cacheOffline, this.server.getResponseHeaderFields())) {
                this.switchState(1, 2, true);
                if (TextUtils.isEmpty((CharSequence)htmlString)) return;
                this.postTaskToSaveSonicCache(htmlString);
                return;
            }
            if ("false".equals(cacheOffline)) {
                SonicUtils.removeSessionCache(this.id);
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:offline mode is 'false', so clean cache.");
                return;
            }
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_TemplateChange:offline->" + cacheOffline + " , so do not need cache to file.");
            return;
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") handleFlow_TemplateChange error:" + e.getMessage());
        }
    }

    @Override
    protected void handleFlow_HttpError(int responseCode) {
        for (WeakReference ref : this.sessionCallbackList) {
            SonicSessionCallback callback = (SonicSessionCallback)ref.get();
            if (callback == null) continue;
            callback.onSessionHttpError(responseCode);
        }
    }

    @Override
    protected void handleFlow_ServiceUnavailable() {
        for (WeakReference ref : this.sessionCallbackList) {
            SonicSessionCallback callback = (SonicSessionCallback)ref.get();
            if (callback == null) continue;
            callback.onSessionUnAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleFlow_FirstLoad() {
        Object object = this.webResponseLock;
        synchronized (object) {
            this.pendingWebResourceStream = this.server.getResponseStream(this.wasInterceptInvoked);
        }
        if (null == this.pendingWebResourceStream) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_FirstLoad error:server.getResponseStream is null!");
            return;
        }
        Message msg = this.mainHandler.obtainMessage(1);
        msg.arg2 = 1000;
        msg.arg1 = 1000;
        String htmlString = this.server.getResponseData(false);
        if (!TextUtils.isEmpty((CharSequence)htmlString)) {
            try {
                msg.arg2 = 304;
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:oh yeah, first load hit 304.");
            }
            catch (Throwable e) {
                Object object2 = this.webResponseLock;
                synchronized (object2) {
                    this.pendingWebResourceStream = null;
                }
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_FirstLoad error:" + e.getMessage() + ".");
            }
        }
        this.isCachePendingStream.set(false);
        this.mainHandler.sendMessage(msg);
        for (WeakReference ref : this.sessionCallbackList) {
            SonicSessionCallback callback = (SonicSessionCallback)ref.get();
            if (callback == null) continue;
            callback.onSessionFirstLoad(htmlString);
        }
        boolean hasCacheData = !TextUtils.isEmpty((CharSequence)htmlString);
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:hasCacheData=" + hasCacheData + ".");
        String cacheOffline = this.server.getResponseHeaderField("cache-offline");
        if (SonicUtils.needSaveData(this.config.SUPPORT_CACHE_CONTROL, cacheOffline, this.server.getResponseHeaderFields())) {
            if (hasCacheData) {
                this.switchState(1, 2, true);
                this.postTaskToSaveSonicCache(htmlString);
            }
        } else {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:offline->" + cacheOffline + " , so do not need cache to file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleFlow_DataUpdate(String serverRsp) {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: start.");
        try {
            Object msg;
            String htmlSha1 = null;
            String htmlString = null;
            if (TextUtils.isEmpty((CharSequence)serverRsp)) {
                serverRsp = this.server.getResponseData(true);
            } else {
                htmlString = this.server.getResponseData(false);
                htmlSha1 = this.server.getResponseHeaderField("sonic-html-sha1");
            }
            if (TextUtils.isEmpty((CharSequence)serverRsp)) {
                return;
            }
            String eTag = this.server.getResponseHeaderField("eTag");
            String templateTag = this.server.getResponseHeaderField("template-tag");
            String cacheOffline = this.server.getResponseHeaderField("cache-offline");
            long startTime = System.currentTimeMillis();
            JSONObject serverRspJson = new JSONObject(serverRsp);
            JSONObject serverDataJson = serverRspJson.optJSONObject("data");
            JSONObject diffDataJson = SonicUtils.getDiffData(this.id, serverDataJson);
            Bundle diffDataBundle = new Bundle();
            if (null != diffDataJson) {
                diffDataBundle.putString("_diff_data_", diffDataJson.toString());
            } else {
                SonicUtils.log(TAG, 6, "handleFlow_DataUpdate:getDiffData error.");
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1006);
            }
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "handleFlow_DataUpdate:getDiffData cost " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            if (SonicUtils.needRefreshPage(cacheOffline)) {
                if (SonicUtils.shouldLog(4)) {
                    SonicUtils.log(TAG, 4, "handleFlow_DataUpdate:loadData was invoked, quick notify web data update.");
                }
                msg = this.mainHandler.obtainMessage(1);
                msg.arg2 = 200;
                msg.arg1 = 200;
                msg.setData(diffDataBundle);
                this.mainHandler.sendMessage(msg);
            }
            for (Object ref : this.sessionCallbackList) {
                SonicSessionCallback callback = (SonicSessionCallback)((Reference)ref).get();
                if (callback == null) continue;
                callback.onSessionDataUpdated(serverRsp);
            }
            startTime = System.currentTimeMillis();
            if (TextUtils.isEmpty((CharSequence)htmlString)) {
                htmlSha1 = serverRspJson.optString("html-sha1");
                htmlString = SonicUtils.buildHtml(this.id, serverDataJson, htmlSha1, serverRsp.length());
            }
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "handleFlow_DataUpdate:buildHtml cost " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            if (!TextUtils.isEmpty((CharSequence)htmlString) && !this.wasInterceptInvoked.get() && SonicUtils.needRefreshPage(cacheOffline)) {
                msg = this.webResponseLock;
                synchronized (msg) {
                    this.pendingWebResourceStream = new ByteArrayInputStream(htmlString.getBytes());
                    this.isCachePendingStream.set(false);
                }
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate:oh yeah, dataUpdate load hit 304.");
                this.mainHandler.removeMessages(1);
                msg = this.mainHandler.obtainMessage(1);
                msg.arg1 = 200;
                msg.arg2 = 304;
                this.mainHandler.sendMessage(msg);
            }
            if (TextUtils.isEmpty((CharSequence)htmlString)) {
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1008);
            }
            if (null == diffDataJson || null == htmlString || !SonicUtils.needSaveData(this.config.SUPPORT_CACHE_CONTROL, cacheOffline, this.server.getResponseHeaderFields())) {
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: clean session cache.");
                SonicUtils.removeSessionCache(this.id);
            }
            this.switchState(1, 2, true);
            Thread.yield();
            startTime = System.currentTimeMillis();
            Map<String, List<String>> headers = this.server.getResponseHeaderFields();
            for (WeakReference ref : this.sessionCallbackList) {
                SonicSessionCallback callback = (SonicSessionCallback)ref.get();
                if (callback == null) continue;
                callback.onSessionSaveCache(htmlString, null, serverDataJson.toString());
            }
            if (SonicUtils.saveSessionFiles(this.id, htmlString, null, serverDataJson.toString(), headers)) {
                long htmlSize = new File(SonicFileUtils.getSonicHtmlPath(this.id)).length();
                SonicUtils.saveSonicData(this.id, eTag, templateTag, htmlSha1, htmlSize, headers);
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: finish save session cache, cost " + (System.currentTimeMillis() - startTime) + " ms.");
            } else {
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_DataUpdate: save session files fail.");
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1004);
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_DataUpdate error:" + e.getMessage());
        }
    }
}

