/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.annotation.TargetApi;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicDataHelper;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicResourceDataHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class SonicUtils {
    public static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private static final String TAG = "SonicSdk_SonicUtils";
    private static final String SONIC_TAG_TITLE_OPEN = "<title>";
    private static final String SONIC_TAG_TITLE_CLOSE = "</title>";
    private static final String SONIC_TAG_TITLE_KEY = "{title}";
    private static final String SONIC_TAG_PATTERN = "<!--sonicdiff-?(\\w*)-->([\\s\\S]+?)<!--sonicdiff-?(\\w*)-end-->";
    private static final String SONIC_TAG_DIFF_BEGIN = "<!--sonicdiff-";
    private static final String SONIC_TAG_DIFF_END = "-->";
    private static final String SONIC_TAG_KEY_BEGIN = "{";
    private static final String SONIC_TAG_KEY_END = "}";
    private static final String SONIC_CLEAR_CACHE_TIME = "check_and_clear_cache_time";
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean shouldLog(int level) {
        return SonicEngine.getInstance().getRuntime().shouldLog(level);
    }

    public static void log(String tag, int level, String message) {
        SonicEngine.getInstance().getRuntime().log(tag, level, message);
    }

    @TargetApi(value=9)
    static void saveSonicData(String sessionId, String eTag, String templateTag, String htmlSha1, long htmlSize, Map<String, List<String>> headers) {
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "saveSonicData sessionId = " + sessionId + ", eTag = " + eTag + ", templateTag = " + templateTag + ",htmlSha1 = " + htmlSha1 + ", htmlSize = " + htmlSize);
        }
        SonicDataHelper.SessionData sessionData = new SonicDataHelper.SessionData();
        sessionData.sessionId = sessionId;
        SonicUtils.handleCacheControl(headers, sessionData);
        sessionData.eTag = eTag;
        sessionData.templateTag = templateTag;
        sessionData.htmlSha1 = htmlSha1;
        sessionData.htmlSize = htmlSize;
        sessionData.templateUpdateTime = System.currentTimeMillis();
        SonicDataHelper.saveSessionData(sessionId, sessionData);
    }

    private static void handleCacheControl(Map<String, List<String>> headers, SonicDataHelper.SessionData sessionData) {
        if (headers.containsKey("Cache-Control".toLowerCase())) {
            String header;
            List<String> responseHeaderValues = headers.get("Cache-Control".toLowerCase());
            if (responseHeaderValues != null && responseHeaderValues.size() > 0) {
                header = responseHeaderValues.get(0).toLowerCase();
                if (header.contains("max-age")) {
                    int index = header.indexOf("max-age");
                    String temp = header.substring(index);
                    int endIndex = temp.indexOf(",");
                    endIndex = endIndex == -1 ? temp.length() : endIndex;
                    String maxAgeStr = temp.substring(8, endIndex);
                    try {
                        long maxAgeTime = Long.parseLong(maxAgeStr) * 1000L;
                        if (maxAgeTime != 0L) {
                            sessionData.expiredTime = maxAgeTime + System.currentTimeMillis();
                        }
                    }
                    catch (Exception e) {
                        SonicUtils.log(TAG, 6, "handleCacheControl:sessionId(" + sessionData.sessionId + ") error:" + e.getMessage());
                    }
                } else if (header.contains("private") || header.contains("public")) {
                    sessionData.expiredTime = System.currentTimeMillis() + (long)SonicEngine.getInstance().getConfig().SONIC_CACHE_MAX_AGE;
                }
            } else if (headers.containsKey("Expires") && (responseHeaderValues = headers.get("Expires")) != null && responseHeaderValues.size() > 0) {
                header = responseHeaderValues.get(0);
                SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z", Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    Date date = df.parse(header);
                    sessionData.expiredTime = date.getTime() + 28800000L;
                }
                catch (Exception e) {
                    SonicUtils.log(TAG, 6, "handleCacheControl:sessionId(" + sessionData.sessionId + ") error:" + e.getMessage());
                }
            }
            long maxAge = System.currentTimeMillis() + (long)SonicEngine.getInstance().getConfig().SONIC_CACHE_MAX_AGE;
            if (sessionData.expiredTime > maxAge) {
                sessionData.expiredTime = maxAge;
            }
        }
    }

    public static void saveSonicResourceData(String resourceUrl, String resourceSha1, long resourceSize) {
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "saveSonicResourceData resourceUrl = " + resourceUrl + ", resourceSha1 = " + resourceSha1 + ", resourceSize = " + resourceSize);
        }
        SonicResourceDataHelper.ResourceData resourceData = new SonicResourceDataHelper.ResourceData();
        resourceData.resourceId = SonicUtils.getMD5(resourceUrl);
        resourceData.resourceSha1 = resourceSha1;
        resourceData.resourceSize = resourceSize;
        SonicUtils.handleResourceExpireTime(resourceUrl, resourceData);
        resourceData.lastUpdateTime = System.currentTimeMillis();
        SonicResourceDataHelper.saveResourceData(resourceData.resourceId, resourceData);
    }

    private static void handleResourceExpireTime(String resourceUrl, SonicResourceDataHelper.ResourceData resourceData) {
        Uri uri = Uri.parse((String)resourceUrl);
        String maxAgeStr = uri.getQueryParameter("max-age");
        if (TextUtils.isEmpty((CharSequence)maxAgeStr)) {
            resourceData.expiredTime = Long.MAX_VALUE;
        } else {
            try {
                long maxAgeTime = Long.parseLong(maxAgeStr) * 1000L;
                if (maxAgeTime != 0L) {
                    resourceData.expiredTime = maxAgeTime + System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                SonicUtils.log(TAG, 6, "handleResourceExpireTime:resourceUrl(" + resourceUrl + ") error:" + e.getMessage());
            }
        }
    }

    static JSONObject getDiffData(String sessionId, JSONObject serverDataJson) {
        JSONObject diffData;
        try {
            String localDataString = SonicFileUtils.readFile(new File(SonicFileUtils.getSonicDataPath(sessionId)));
            if (!TextUtils.isEmpty((CharSequence)localDataString)) {
                JSONObject localDataJson = new JSONObject(localDataString);
                diffData = SonicUtils.getDiffData(localDataJson, serverDataJson);
            } else {
                diffData = serverDataJson;
            }
            if (diffData != null && diffData.length() > 0) {
                diffData.put("local_refresh_time", System.currentTimeMillis());
            }
        }
        catch (Throwable e) {
            diffData = null;
            SonicUtils.log(TAG, 6, "getDiffData error1:" + e.getMessage());
        }
        return diffData;
    }

    static JSONObject getDiffData(JSONObject localDataJson, JSONObject serverDataJson) {
        if (localDataJson == null || serverDataJson == null) {
            return null;
        }
        JSONObject diffData = new JSONObject();
        try {
            Iterator iterator = serverDataJson.keys();
            while (iterator.hasNext()) {
                String localData;
                String key = iterator.next().toString();
                String serverData = serverDataJson.optString(key);
                if (serverData.equals(localData = localDataJson.optString(key))) continue;
                diffData.put(key, (Object)serverData);
                if (!SonicUtils.shouldLog(3)) continue;
                SonicUtils.log(TAG, 3, "getDiffData:find diff data, key ->" + key + ", length=" + serverData.length() + ".");
            }
        }
        catch (Throwable e) {
            diffData = null;
            SonicUtils.log(TAG, 6, "getDiffData error2:" + e.getMessage());
        }
        return diffData;
    }

    static String buildHtml(final String sessionId, JSONObject dataJson, String sha1, int dataMaxSize) {
        File templateFile = new File(SonicFileUtils.getSonicTemplatePath(sessionId));
        if (templateFile.exists()) {
            String templateString = SonicFileUtils.readFile(templateFile);
            if (!TextUtils.isEmpty((CharSequence)templateString)) {
                final String htmlString = SonicUtils.buildHtml(templateString, dataJson, dataMaxSize);
                if (TextUtils.isEmpty((CharSequence)sha1) || sha1.equalsIgnoreCase(SonicUtils.getSHA1(htmlString))) {
                    return htmlString;
                }
                SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                    @Override
                    public void run() {
                        String path = SonicFileUtils.getSonicHtmlPath(sessionId) + ".tmp";
                        SonicFileUtils.writeFile(htmlString, path);
                    }
                }, 0L);
                SonicUtils.log(TAG, 6, "buildHtml error: verify sha1 error.");
                return null;
            }
            SonicUtils.log(TAG, 6, "buildHtml error: template string is empty.");
        } else {
            SonicUtils.log(TAG, 6, "buildHtml error: template file is not exists.");
        }
        return null;
    }

    static String buildHtml(String templateString, JSONObject dataJson, int dataMaxSize) {
        if (TextUtils.isEmpty((CharSequence)templateString) || dataJson == null) {
            return null;
        }
        StringBuilder htmlStringBuilder = new StringBuilder(templateString.length() + dataMaxSize);
        htmlStringBuilder.append(templateString);
        Iterator iterator = dataJson.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String data = dataJson.optString(key);
            int index = htmlStringBuilder.indexOf(key);
            if (-1 == index) continue;
            htmlStringBuilder.replace(index, index + key.length(), data);
        }
        return htmlStringBuilder.toString();
    }

    static boolean saveSessionFiles(String sessionId, String htmlString, String templateString, String dataString, Map<String, List<String>> headers) {
        if (!TextUtils.isEmpty((CharSequence)htmlString) && !SonicFileUtils.writeFile(htmlString, SonicFileUtils.getSonicHtmlPath(sessionId))) {
            SonicUtils.log(TAG, 6, "saveSessionData error: write html file fail.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)templateString) && !SonicFileUtils.writeFile(templateString, SonicFileUtils.getSonicTemplatePath(sessionId))) {
            SonicUtils.log(TAG, 6, "saveSessionData error: write template file fail.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)dataString) && !SonicFileUtils.writeFile(dataString, SonicFileUtils.getSonicDataPath(sessionId))) {
            SonicUtils.log(TAG, 6, "saveSessionData error: write data file fail.");
            return false;
        }
        if (headers != null && headers.size() > 0 && !SonicFileUtils.writeFile(SonicFileUtils.convertHeadersToString(headers), SonicFileUtils.getSonicHeaderPath(sessionId))) {
            SonicUtils.log(TAG, 6, "saveSessionData error: write header file fail.");
            return false;
        }
        return true;
    }

    public static boolean saveResourceFiles(String resourceName, byte[] resourceBytes, Map<String, List<String>> headers) {
        if (resourceBytes != null && !SonicFileUtils.writeFile(resourceBytes, SonicFileUtils.getSonicResourcePath(resourceName))) {
            SonicUtils.log(TAG, 6, "saveResourceFiles error: write resource data fail.");
            return false;
        }
        if (headers != null && headers.size() > 0 && !SonicFileUtils.writeFile(SonicFileUtils.convertHeadersToString(headers), SonicFileUtils.getSonicResourceHeaderPath(resourceName))) {
            SonicUtils.log(TAG, 6, "saveResourceFiles error: write header file fail.");
            return false;
        }
        return true;
    }

    public static HashMap<String, String> getFilteredHeaders(Map<String, List<String>> srcHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (null != srcHeaders) {
            for (Map.Entry<String, List<String>> entry : srcHeaders.entrySet()) {
                List<String> headerValues;
                if ("Set-Cookie".equalsIgnoreCase(entry.getKey()) || "Cache-Control".equalsIgnoreCase(entry.getKey()) || "Expires".equalsIgnoreCase(entry.getKey()) || "Etag".equalsIgnoreCase(entry.getKey()) || null == (headerValues = entry.getValue()) || 1 != headerValues.size()) continue;
                headers.put(entry.getKey(), headerValues.get(0));
            }
        }
        return headers;
    }

    static String getCharset(String headerValue) {
        int index;
        String charset = DEFAULT_CHARSET;
        if (!TextUtils.isEmpty((CharSequence)headerValue) && (index = (headerValue = headerValue.toLowerCase()).indexOf("charset")) != -1) {
            String temp = headerValue.substring(index);
            int endIndex = (temp = temp.replace(" ", "")).indexOf(";");
            endIndex = endIndex == -1 ? temp.length() : endIndex;
            charset = temp.substring(8, endIndex);
            charset = TextUtils.isEmpty((CharSequence)charset) ? DEFAULT_CHARSET : charset;
        }
        return charset;
    }

    static boolean separateTemplateAndData(String sessionId, String htmlString, StringBuilder templateStringBuilder, StringBuilder dataStringBuilder) {
        long startTime = System.currentTimeMillis();
        SonicUtils.log(TAG, 4, "separateTemplateAndData:sessionId(" + sessionId + ") start, htmlString = " + (htmlString.length() > 128 ? htmlString.substring(0, 128) : htmlString));
        JSONObject info = new JSONObject();
        int lastEnd = 0;
        try {
            Pattern pattern = Pattern.compile(SONIC_TAG_PATTERN, 8);
            Matcher matcher = pattern.matcher(htmlString);
            while (matcher.find()) {
                String dataInfo = matcher.group();
                String dataMark = SONIC_TAG_DIFF_BEGIN;
                int markLen = dataMark.length();
                int keyStart = dataInfo.indexOf(dataMark);
                int keyEnd = dataInfo.indexOf(SONIC_TAG_DIFF_END);
                String key = null;
                if (keyStart != -1 && keyStart + markLen < keyEnd) {
                    key = dataInfo.substring(keyStart + markLen, keyEnd);
                }
                key = SONIC_TAG_KEY_BEGIN + key + SONIC_TAG_KEY_END;
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "separateTemplateAndData:sessionId(" + sessionId + "), key = " + key);
                }
                if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)dataInfo)) continue;
                info.put(key, (Object)dataInfo);
                int start = matcher.start();
                templateStringBuilder.append(htmlString.substring(lastEnd, start));
                templateStringBuilder.append(key);
                lastEnd = matcher.end();
            }
            if (lastEnd < htmlString.length() && templateStringBuilder.length() > 0) {
                templateStringBuilder.append(htmlString.substring(lastEnd, htmlString.length()));
            }
            int titleStart = templateStringBuilder.indexOf(SONIC_TAG_TITLE_OPEN);
            int titleEnd = templateStringBuilder.indexOf(SONIC_TAG_TITLE_CLOSE, titleStart + SONIC_TAG_TITLE_OPEN.length()) + SONIC_TAG_TITLE_CLOSE.length();
            if (titleStart != -1 && titleStart < titleEnd) {
                String key = SONIC_TAG_TITLE_KEY;
                info.put(key, (Object)templateStringBuilder.substring(titleStart, titleEnd));
                templateStringBuilder.replace(titleStart, titleEnd, key);
            }
            dataStringBuilder.append(info.toString());
        }
        catch (Exception e) {
            SonicUtils.log(TAG, 6, "separateTemplateAndData:sessionId(" + sessionId + ") error:" + e.getMessage());
            return false;
        }
        SonicUtils.log(TAG, 4, "separateTemplateAndData:sessionId(" + sessionId + ") end, cost " + (System.currentTimeMillis() - startTime) + "ms.");
        return true;
    }

    static void removeSessionCache(String sessionId) {
        SonicDataHelper.removeSessionData(sessionId);
        SonicFileUtils.deleteSonicFiles(sessionId);
    }

    public static void removeResourceCache(String resourceId) {
        SonicResourceDataHelper.removeResourceData(resourceId);
        SonicFileUtils.deleteResourceFiles(resourceId);
    }

    static boolean removeAllSessionCache() {
        File cacheRootDir = new File(SonicFileUtils.getSonicCacheDirPath());
        if (cacheRootDir.exists()) {
            SonicDataHelper.clear();
            return SonicFileUtils.deleteAllChildFiles(cacheRootDir);
        }
        return false;
    }

    static boolean needSaveData(boolean isSupportCacheControl, String cacheOffline, Map<String, List<String>> headers) {
        boolean needSaveData;
        boolean bl = needSaveData = !TextUtils.isEmpty((CharSequence)cacheOffline) && ("store".equals(cacheOffline) || "true".equals(cacheOffline));
        if (needSaveData && isSupportCacheControl) {
            List<String> responseHeaderValues = headers.get("Cache-Control".toLowerCase());
            if (headers.containsKey("Cache-Control")) {
                String header;
                if (responseHeaderValues != null && responseHeaderValues.size() > 0 && ((header = responseHeaderValues.get(0).toLowerCase()).contains("no-cache") || header.contains("no-store") || header.contains("must-revalidate"))) {
                    needSaveData = false;
                }
            } else if (headers.containsKey("Pragma")) {
                needSaveData = false;
            }
        }
        return needSaveData;
    }

    static boolean needRefreshPage(String cacheOffline) {
        return !TextUtils.isEmpty((CharSequence)cacheOffline) && ("false".equals(cacheOffline) || "true".equals(cacheOffline));
    }

    static String addSonicUrlParam(String url, String paramKey, String paramValue) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            StringBuilder stringBuilder = new StringBuilder(url);
            int paramStartIndex = stringBuilder.lastIndexOf("/");
            if (paramStartIndex < 0) {
                paramStartIndex = 0;
            }
            String paramKeyPattern1 = "&" + paramKey + "=";
            String paramKeyPattern2 = "?" + paramKey + "=";
            int paramKeyPattern = paramKeyPattern1.length();
            try {
                while (true) {
                    int paramKeyIndex;
                    if (-1 == (paramKeyIndex = stringBuilder.indexOf(paramKeyPattern1, paramStartIndex))) {
                        paramKeyIndex = stringBuilder.indexOf(paramKeyPattern2, paramStartIndex);
                    }
                    if (paramKeyIndex > 0) {
                        int nextParamStartIndex = stringBuilder.indexOf("&", paramKeyIndex + paramKeyPattern);
                        if (nextParamStartIndex > 0) {
                            stringBuilder.replace(paramKeyIndex + 1, nextParamStartIndex + 1, "");
                            continue;
                        }
                        stringBuilder.replace(paramKeyIndex, stringBuilder.length(), "");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                SonicUtils.log(TAG, 6, "addSonicUrlParam error:" + e.getMessage());
                return url;
            }
            if (-1 != stringBuilder.indexOf("?")) {
                stringBuilder.append("&").append(paramKey).append("=").append(paramValue);
            } else {
                stringBuilder.append("?").append(paramKey).append("=").append(paramValue);
            }
            return stringBuilder.toString();
        }
        return url;
    }

    public static String getMime(String url) {
        String mime = "text/html";
        Uri currentUri = Uri.parse((String)url);
        String path = currentUri.getPath();
        if (path.endsWith(".css")) {
            mime = "text/css";
        } else if (path.endsWith(".js")) {
            mime = "application/x-javascript";
        } else if (path.endsWith(".jpg") || path.endsWith(".gif") || path.endsWith(".png") || path.endsWith(".jpeg") || path.endsWith(".webp") || path.endsWith(".bmp")) {
            mime = "image/*";
        }
        return mime;
    }

    static String getSHA1(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        return SonicUtils.getSHA1(content.getBytes());
    }

    public static String getSHA1(byte[] contentBytes) {
        if (contentBytes == null || contentBytes.length <= 0) {
            return "";
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(contentBytes, 0, contentBytes.length);
            return SonicUtils.toHexString(sha1.digest());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getMD5(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("MD5");
            sha1.update(content.getBytes(), 0, content.getBytes().length);
            return SonicUtils.toHexString(sha1.digest());
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte aB : b) {
            sb.append(hexChar[(aB & 0xF0) >>> 4]);
            sb.append(hexChar[aB & 0xF]);
        }
        return sb.toString();
    }

    static boolean shouldClearCache(long timeInterval) {
        SharedPreferences sp = SonicEngine.getInstance().getRuntime().getSonicSharedPreferences();
        long lastCheckTime = sp.getLong(SONIC_CLEAR_CACHE_TIME, 0L);
        return System.currentTimeMillis() - lastCheckTime > timeInterval;
    }

    static void saveClearCacheTime(long timestamp) {
        SharedPreferences sp = SonicEngine.getInstance().getRuntime().getSonicSharedPreferences();
        sp.edit().putLong(SONIC_CLEAR_CACHE_TIME, timestamp).apply();
    }
}

