/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import com.tencent.sonic.sdk.SonicDBHelper;
import java.util.ArrayList;
import java.util.List;

class SonicDataHelper {
    private static final String TAG = "SonicSdk_SonicDataHelper";
    protected static final String Sonic_SESSION_TABLE_NAME = "SessionData";
    protected static final String SESSION_DATA_COLUMN_SESSION_ID = "sessionID";
    protected static final String SESSION_DATA_COLUMN_ETAG = "eTag";
    protected static final String SESSION_DATA_COLUMN_TEMPLATE_EAG = "templateTag";
    protected static final String SESSION_DATA_COLUMN_HTML_SHA1 = "htmlSha1";
    protected static final String SESSION_DATA_COLUMN_HTML_SIZE = "htmlSize";
    protected static final String SESSION_DATA_COLUMN_TEMPLATE_UPDATE_TIME = "templateUpdateTime";
    protected static final String SESSION_DATA_COLUMN_UNAVAILABLE_TIME = "UnavailableTime";
    protected static final String SESSION_DATA_COLUMN_CACHE_EXPIRED_TIME = "cacheExpiredTime";
    protected static final String SESSION_DATA_COLUMN_CACHE_HIT_COUNT = "cacheHitCount";
    public static final String CREATE_TABLE_SQL = "CREATE TABLE IF NOT EXISTS SessionData ( id  integer PRIMARY KEY autoincrement , sessionID text not null , eTag text not null , templateTag text , htmlSha1 text not null , UnavailableTime integer default 0 , htmlSize integer default 0 , templateUpdateTime integer default 0 , cacheExpiredTime integer default 0 , cacheHitCount integer default 0 ); ";

    SonicDataHelper() {
    }

    static String[] getAllSessionDataColumn() {
        return new String[]{SESSION_DATA_COLUMN_SESSION_ID, SESSION_DATA_COLUMN_ETAG, SESSION_DATA_COLUMN_TEMPLATE_EAG, SESSION_DATA_COLUMN_HTML_SHA1, SESSION_DATA_COLUMN_UNAVAILABLE_TIME, SESSION_DATA_COLUMN_HTML_SIZE, SESSION_DATA_COLUMN_TEMPLATE_UPDATE_TIME, SESSION_DATA_COLUMN_CACHE_EXPIRED_TIME, SESSION_DATA_COLUMN_CACHE_HIT_COUNT};
    }

    @NonNull
    static SessionData getSessionData(String sessionId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SessionData sessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (null == sessionData) {
            sessionData = new SessionData();
        }
        return sessionData;
    }

    private static SessionData getSessionData(SQLiteDatabase db, String sessionId) {
        Cursor cursor = db.query(Sonic_SESSION_TABLE_NAME, SonicDataHelper.getAllSessionDataColumn(), "sessionID=?", new String[]{sessionId}, null, null, null);
        SessionData sessionData = null;
        if (cursor != null && cursor.moveToFirst()) {
            sessionData = SonicDataHelper.querySessionData(cursor);
        }
        if (cursor != null) {
            cursor.close();
        }
        return sessionData;
    }

    private static SessionData querySessionData(Cursor cursor) {
        SessionData sessionData = new SessionData();
        sessionData.sessionId = cursor.getString(cursor.getColumnIndex(SESSION_DATA_COLUMN_SESSION_ID));
        sessionData.eTag = cursor.getString(cursor.getColumnIndex(SESSION_DATA_COLUMN_ETAG));
        sessionData.htmlSha1 = cursor.getString(cursor.getColumnIndex(SESSION_DATA_COLUMN_HTML_SHA1));
        sessionData.htmlSize = cursor.getLong(cursor.getColumnIndex(SESSION_DATA_COLUMN_HTML_SIZE));
        sessionData.templateTag = cursor.getString(cursor.getColumnIndex(SESSION_DATA_COLUMN_TEMPLATE_EAG));
        sessionData.templateUpdateTime = cursor.getLong(cursor.getColumnIndex(SESSION_DATA_COLUMN_TEMPLATE_UPDATE_TIME));
        sessionData.expiredTime = cursor.getLong(cursor.getColumnIndex(SESSION_DATA_COLUMN_CACHE_EXPIRED_TIME));
        sessionData.unAvailableTime = cursor.getLong(cursor.getColumnIndex(SESSION_DATA_COLUMN_UNAVAILABLE_TIME));
        sessionData.cacheHitCount = cursor.getInt(cursor.getColumnIndex(SESSION_DATA_COLUMN_CACHE_HIT_COUNT));
        return sessionData;
    }

    static List<SessionData> getAllSessionByHitCount() {
        ArrayList<SessionData> sessionDatas = new ArrayList<SessionData>();
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        Cursor cursor = db.query(Sonic_SESSION_TABLE_NAME, SonicDataHelper.getAllSessionDataColumn(), null, null, null, null, "cacheHitCount ASC");
        while (cursor != null && cursor.moveToNext()) {
            sessionDatas.add(SonicDataHelper.querySessionData(cursor));
        }
        return sessionDatas;
    }

    static void saveSessionData(String sessionId, SessionData sessionData) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SonicDataHelper.saveSessionData(db, sessionId, sessionData);
    }

    private static void saveSessionData(SQLiteDatabase db, String sessionId, SessionData sessionData) {
        sessionData.sessionId = sessionId;
        SessionData storedSessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (storedSessionData != null) {
            sessionData.cacheHitCount = storedSessionData.cacheHitCount;
            SonicDataHelper.updateSessionData(db, sessionId, sessionData);
        } else {
            SonicDataHelper.insertSessionData(db, sessionId, sessionData);
        }
    }

    private static void insertSessionData(SQLiteDatabase db, String sessionId, SessionData sessionData) {
        ContentValues contentValues = SonicDataHelper.getContentValues(sessionId, sessionData);
        db.insert(Sonic_SESSION_TABLE_NAME, null, contentValues);
    }

    private static void updateSessionData(SQLiteDatabase db, String sessionId, SessionData sessionData) {
        ContentValues contentValues = SonicDataHelper.getContentValues(sessionId, sessionData);
        db.update(Sonic_SESSION_TABLE_NAME, contentValues, "sessionID=?", new String[]{sessionId});
    }

    @NonNull
    private static ContentValues getContentValues(String sessionId, SessionData sessionData) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(SESSION_DATA_COLUMN_SESSION_ID, sessionId);
        contentValues.put(SESSION_DATA_COLUMN_ETAG, sessionData.eTag);
        contentValues.put(SESSION_DATA_COLUMN_HTML_SHA1, sessionData.htmlSha1);
        contentValues.put(SESSION_DATA_COLUMN_HTML_SIZE, Long.valueOf(sessionData.htmlSize));
        contentValues.put(SESSION_DATA_COLUMN_TEMPLATE_EAG, sessionData.templateTag);
        contentValues.put(SESSION_DATA_COLUMN_TEMPLATE_UPDATE_TIME, Long.valueOf(sessionData.templateUpdateTime));
        contentValues.put(SESSION_DATA_COLUMN_CACHE_EXPIRED_TIME, Long.valueOf(sessionData.expiredTime));
        contentValues.put(SESSION_DATA_COLUMN_UNAVAILABLE_TIME, Long.valueOf(sessionData.unAvailableTime));
        contentValues.put(SESSION_DATA_COLUMN_CACHE_HIT_COUNT, Integer.valueOf(sessionData.cacheHitCount));
        return contentValues;
    }

    static void removeSessionData(String sessionId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        db.delete(Sonic_SESSION_TABLE_NAME, "sessionID=?", new String[]{sessionId});
    }

    static boolean setSonicUnavailableTime(String sessionId, long unavailableTime) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SessionData sessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (sessionData != null) {
            sessionData.unAvailableTime = unavailableTime;
            SonicDataHelper.updateSessionData(db, sessionId, sessionData);
            return true;
        }
        sessionData = new SessionData();
        sessionData.sessionId = sessionId;
        sessionData.eTag = "Unknown";
        sessionData.htmlSha1 = "Unknown";
        sessionData.unAvailableTime = unavailableTime;
        SonicDataHelper.insertSessionData(db, sessionId, sessionData);
        return true;
    }

    static long getLastSonicUnavailableTime(String sessionId) {
        SessionData sessionData = SonicDataHelper.getSessionData(sessionId);
        return sessionData.unAvailableTime;
    }

    static void updateSonicCacheHitCount(String sessionId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SonicDataHelper.updateSonicCacheHitCount(db, sessionId);
    }

    private static void updateSonicCacheHitCount(SQLiteDatabase db, String sessionId) {
        SessionData sessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (sessionData != null) {
            ++sessionData.cacheHitCount;
            SonicDataHelper.updateSessionData(db, sessionId, sessionData);
        }
    }

    static synchronized void clear() {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        db.delete(Sonic_SESSION_TABLE_NAME, null, null);
    }

    static class SessionData {
        String sessionId;
        String eTag;
        String templateTag;
        String htmlSha1;
        long htmlSize;
        long templateUpdateTime;
        long expiredTime;
        long unAvailableTime;
        int cacheHitCount;

        SessionData() {
        }

        public void reset() {
            this.eTag = "";
            this.templateTag = "";
            this.htmlSha1 = "";
            this.htmlSize = 0L;
            this.templateUpdateTime = 0L;
            this.expiredTime = 0L;
            this.cacheHitCount = 0;
            this.unAvailableTime = 0L;
        }
    }
}

