/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class SonicDBHelper
extends SQLiteOpenHelper {
    private static final String TAG = "SonicSdk_SonicDBHelper";
    private static final String SONIC_DATABASE_NAME = "sonic.db";
    private static final int SONIC_DATABASE_FIRST_VERSION = 1;
    private static final int SONIC_DATABASE_VERSION = 2;
    private static SonicDBHelper sInstance = null;
    private static AtomicBoolean isDBUpgrading = new AtomicBoolean(false);

    private SonicDBHelper(Context context) {
        super(context, SONIC_DATABASE_NAME, null, 2);
    }

    static synchronized SonicDBHelper createInstance(Context context) {
        if (null == sInstance) {
            sInstance = new SonicDBHelper(context);
        }
        return sInstance;
    }

    public static synchronized SonicDBHelper getInstance() {
        if (null == sInstance) {
            throw new IllegalStateException("SonicDBHelper::createInstance() needs to be called before SonicDBHelper::getInstance()!");
        }
        return sInstance;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS SessionData ( id  integer PRIMARY KEY autoincrement , sessionID text not null , eTag text not null , templateTag text , htmlSha1 text not null , UnavailableTime integer default 0 , htmlSize integer default 0 , templateUpdateTime integer default 0 , cacheExpiredTime integer default 0 , cacheHitCount integer default 0 ); ");
        this.onUpgrade(db, -1, 2);
        this.doUpgrade(db, 1, 2);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (isDBUpgrading.compareAndSet(false, true)) {
            long startTime = System.currentTimeMillis();
            SonicUtils.log(TAG, 4, "onUpgrade start, from " + oldVersion + " to " + newVersion + ".");
            if (-1 == oldVersion) {
                SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                    @Override
                    public void run() {
                        SonicUtils.removeAllSessionCache();
                        isDBUpgrading.set(false);
                    }
                }, 0L);
            } else {
                this.doUpgrade(db, oldVersion, newVersion);
                isDBUpgrading.set(false);
            }
            SonicUtils.log(TAG, 4, "onUpgrade finish, cost " + (System.currentTimeMillis() - startTime) + "ms.");
        }
    }

    private void doUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case 1: {
                this.upgradeToVersion_2(db);
                break;
            }
        }
    }

    private void upgradeToVersion_2(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS ResourceData ( id  integer PRIMARY KEY autoincrement , resourceID text not null , resourceSha1 text not null , resourceSize integer default 0 , resourceUpdateTime integer default 0 , cacheExpiredTime integer default 0 ); ");
    }

    public boolean isUpgrading() {
        return isDBUpgrading.get();
    }
}

