/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.quic;

import com.tencent.qcloud.quic.ProgressCallback;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;

public class QuicResponse {
    protected Map<String, String> headers = new LinkedHashMap<String, String>();
    protected int code;
    protected String message;
    protected String contentType;
    protected Buffer buffer = new Buffer();
    protected BufferedSink fileSink;
    protected ProgressCallback progressCallback;
    protected long currentLength = 0L;
    protected long totalLength = -1L;

    protected void setContentLength(long contentLength) {
        this.totalLength = contentLength;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setProgressCallback(ProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.fileSink = Okio.buffer((Sink)Okio.sink((OutputStream)outputStream));
    }

    protected void updateProgress(int dataLength) {
        this.currentLength += (long)dataLength;
        if (this.progressCallback != null) {
            this.progressCallback.onProgress(this.currentLength, this.totalLength);
        }
    }

    public Response covertResponse(Request request) {
        Headers headers = Headers.of(this.headers);
        Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(this.code).message(this.message).headers(headers).body(new ResponseBody(){

            public MediaType contentType() {
                if (QuicResponse.this.contentType != null) {
                    return MediaType.parse((String)QuicResponse.this.contentType);
                }
                return null;
            }

            public long contentLength() {
                return QuicResponse.this.totalLength;
            }

            public BufferedSource source() {
                return QuicResponse.this.buffer;
            }
        }).build();
        return response;
    }
}

