/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.quic;

import com.tencent.qcloud.quic.CallByNative;
import java.util.Locale;
import java.util.UUID;

public class QuicNative {
    protected int handleId = UUID.randomUUID().toString().hashCode();
    protected static final int INIT = 0;
    protected static final int CONNECTED = 1;
    protected static final int RECEIVING = 2;
    protected static final int COMPLETED = 3;
    protected static final int SERVER_FAILED = 4;
    protected static final int CLIENT_FAILED = 5;
    protected String host;
    protected String ip;
    protected int port;
    protected int tcpPort;
    protected boolean isCompleted = false;
    protected long idleStartTime = Long.MAX_VALUE;
    protected int currentState = 0;
    private NetworkCallback callback;

    public String toString() {
        return String.format(Locale.ENGLISH, "{handleId:%s, host:%s, ip:%s, port:%d, tcpPort:%d, isComplete:%b, idleStartTime:%d, currentState:%s}", this.handleId, this.host, this.ip, this.port, this.tcpPort, this.isCompleted, this.idleStartTime, QuicNative.readableState(this.currentState));
    }

    public void setCallback(NetworkCallback callback) {
        this.callback = callback;
    }

    @CallByNative
    private void onConnect(int code) {
        this.currentState = 1;
        if (this.callback != null) {
            this.callback.onConnect(this.handleId, code);
        }
    }

    @CallByNative
    private void onDataReceive(byte[] data, int len) {
        if (this.callback != null) {
            this.callback.onDataReceive(this.handleId, data, len);
        }
    }

    @CallByNative
    private void onCompleted(int code) {
        if (this.callback != null) {
            this.callback.onCompleted(this.handleId, code);
        }
    }

    @CallByNative
    private void onClose(int code, String desc) {
        this.currentState = 4;
        if (this.callback != null) {
            this.callback.onClose(this.handleId, code, desc);
        }
    }

    public void connect(String host, String ip, int port, int tcpPort) {
        this.connect(this.handleId, host, ip, port, tcpPort);
    }

    public void addHeader(String key, String value) {
        this.addHeader(this.handleId, key, value);
    }

    public void sendRequest(byte[] content, int len, boolean finish) {
        this.sendRequest(this.handleId, content, len, finish);
    }

    public void cancelRequest() {
        this.cancelRequest(this.handleId);
    }

    public String getState() {
        return this.getState(this.handleId);
    }

    public void clear() {
        this.clear(this.handleId);
    }

    public static native void init();

    public static native void setDebugLog(boolean var0);

    public static native void destory();

    private native void connect(int var1, String var2, String var3, int var4, int var5);

    private native void addHeader(int var1, String var2, String var3);

    private native void sendRequest(int var1, byte[] var2, int var3, boolean var4);

    private native void cancelRequest(int var1);

    private native String getState(int var1);

    private native void clear(int var1);

    public static String readableState(int state) {
        switch (state) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "CONNECTED";
            }
            case 2: {
                return "RECEIVING";
            }
            case 3: {
                return "COMPLETE";
            }
            case 4: {
                return "SERVER_FAILED";
            }
            case 5: {
                return "CLIENT_FAILED";
            }
        }
        return "UNKNOWN";
    }

    static {
        System.loadLibrary("tquic");
        System.loadLibrary("costquic");
    }

    public static interface NetworkCallback {
        public void onConnect(int var1, int var2);

        public void onDataReceive(int var1, byte[] var2, int var3);

        public void onCompleted(int var1, int var2);

        public void onClose(int var1, int var2, String var3);
    }
}

