/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.tencent.qcloud.core.http.MultipartStreamRequestBody;
import com.tencent.qcloud.core.http.StreamingRequestBody;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.ByteString;

public abstract class RequestBodySerializer {
    public abstract RequestBody body();

    private static MediaType parseType(String contentType) {
        if (contentType != null) {
            return MediaType.parse((String)contentType);
        }
        return null;
    }

    public static RequestBodySerializer wrap(RequestBody body) {
        return new BaseRequestBodyWrapper(body);
    }

    public static RequestBodySerializer string(String contentType, String content) {
        return new BaseRequestBodyWrapper(RequestBody.create((MediaType)RequestBodySerializer.parseType(contentType), (String)content));
    }

    public static RequestBodySerializer string(String contentType, ByteString content) {
        return new BaseRequestBodyWrapper(RequestBody.create((MediaType)RequestBodySerializer.parseType(contentType), (ByteString)content));
    }

    public static RequestBodySerializer bytes(String contentType, byte[] content) {
        return RequestBodySerializer.bytes(contentType, content, 0L, -1L);
    }

    public static RequestBodySerializer bytes(String contentType, byte[] content, long offset, long byteCount) {
        long contentLength;
        long l = contentLength = byteCount < 0L ? (long)content.length - offset : Math.min(byteCount, (long)content.length - offset);
        if (contentLength < 204800L) {
            return new BaseRequestBodyWrapper(RequestBody.create((MediaType)RequestBodySerializer.parseType(contentType), (byte[])content));
        }
        return new BaseRequestBodyWrapper(StreamingRequestBody.bytes(content, contentType, offset, byteCount));
    }

    public static RequestBodySerializer file(String contentType, File file) {
        return RequestBodySerializer.file(contentType, file, 0L, -1L);
    }

    public static RequestBodySerializer file(String contentType, File file, long offset, long length) {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)file.getPath());
            contentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        StreamingRequestBody fileRequestBody = StreamingRequestBody.file(file, contentType, offset, length);
        return new BaseRequestBodyWrapper(fileRequestBody);
    }

    public static RequestBodySerializer url(String contentType, URL url) {
        return RequestBodySerializer.url(contentType, url, 0L, -1L);
    }

    public static RequestBodySerializer url(String contentType, URL url, long offset, long length) {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)url.toString());
            contentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        StreamingRequestBody fileRequestBody = StreamingRequestBody.url(url, contentType, offset, length);
        return new BaseRequestBodyWrapper(fileRequestBody);
    }

    public static RequestBodySerializer uri(String contentType, Uri uri, Context context) {
        return RequestBodySerializer.uri(contentType, uri, context, 0L, -1L);
    }

    public static RequestBodySerializer uri(String contentType, Uri uri, Context context, long offset, long length) {
        ContentResolver contentResolver = context.getContentResolver();
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            contentType = contentResolver.getType(uri);
        }
        StreamingRequestBody fileRequestBody = StreamingRequestBody.uri(uri, contentResolver, contentType, offset, length);
        return new BaseRequestBodyWrapper(fileRequestBody);
    }

    public static RequestBodySerializer stream(String contentType, File tmpFile, InputStream inputStream) {
        return RequestBodySerializer.stream(contentType, tmpFile, inputStream, 0L, -1L);
    }

    public static RequestBodySerializer stream(String contentType, File tmpFile, InputStream inputStream, long offset, long length) {
        StreamingRequestBody requestBody = StreamingRequestBody.steam(inputStream, tmpFile, contentType, offset, length);
        return new BaseRequestBodyWrapper(requestBody);
    }

    public static RequestBodySerializer multiPart(MultipartStreamRequestBody multipartStreamRequestBody) {
        return new BaseRequestBodyWrapper(multipartStreamRequestBody);
    }

    private static final class BaseRequestBodyWrapper
    extends RequestBodySerializer {
        private final RequestBody body;

        public BaseRequestBodyWrapper(RequestBody body) {
            this.body = body;
        }

        @Override
        public RequestBody body() {
            return this.body;
        }
    }
}

