/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;

public class RetryStrategy {
    protected static final int BACKOFF_MULTIPLIER = 2;
    private static final int DEFAULT_INIT_BACKOFF = 1000;
    private static final int DEFAULT_ATTEMPTS = 3;
    private static final int DEFAULT_MAX_BACKOFF = 2000;
    protected final int initBackoff;
    protected final int maxBackoff;
    protected final int baseAttempts;
    public static RetryStrategy DEFAULT = new RetryStrategy(1000, 2000, 0);
    public static RetryStrategy FAIL_FAST = new RetryStrategy(0, 0, Integer.MIN_VALUE);
    private QCloudHttpRetryHandler qCloudHttpRetryHandler = QCloudHttpRetryHandler.DEFAULT;

    public RetryStrategy(int initBackoff, int maxBackoff, int baseAttempts) {
        this.initBackoff = initBackoff;
        this.maxBackoff = maxBackoff;
        this.baseAttempts = baseAttempts;
    }

    public long getNextDelay(int attempts) {
        if (attempts < 1) {
            return 0L;
        }
        return Math.min(this.maxBackoff, this.initBackoff * (int)Math.pow(2.0, attempts - 1));
    }

    public boolean shouldRetry(int attempts, long millstook, int addition) {
        return attempts < this.baseAttempts + addition;
    }

    public void onTaskEnd(boolean isTaskSuccess, Exception e) {
    }

    public void setRetryHandler(QCloudHttpRetryHandler qCloudHttpRetryHandler) {
        this.qCloudHttpRetryHandler = qCloudHttpRetryHandler;
    }

    public QCloudHttpRetryHandler getQCloudHttpRetryHandler() {
        return this.qCloudHttpRetryHandler;
    }

    public static class WeightAndReliableAddition {
        private final int maxWeight = 2;
        private final int minWeight = 0;
        private final int minReliable = 0;
        private final int maxReliable = 4;
        private final int[][] addTable = new int[][]{{0, 1, 2, 2, 2}, {0, 1, 2, 3, 3}, {0, 1, 2, 3, 4}};

        public int getRetryAddition(int weight, int reliable) {
            weight = this.regular(weight, 2, 0);
            reliable = this.regular(reliable, 4, 0);
            return 1 + this.addTable[weight][reliable];
        }

        private int regular(int r, int max, int min) {
            if (r > max) {
                return max;
            }
            if (r < min) {
                return min;
            }
            return r;
        }
    }
}

