/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpConfiguration;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

class RetryAndTrafficControlInterceptor
implements Interceptor {
    private TrafficStrategy uploadTrafficStrategy = new ModerateTrafficStrategy("UploadStrategy-", 2);
    private TrafficStrategy downloadTrafficStrategy = new AggressiveTrafficStrategy("DownloadStrategy-", 3);
    private RetryStrategy retryStrategy;
    private static final int MIN_CLOCK_SKEWED_OFFSET = 600;

    RetryAndTrafficControlInterceptor(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpTask task = (HttpTask)TaskManager.getInstance().get((String)request.tag());
        return this.processRequest(chain, request, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response processRequest(Interceptor.Chain chain, Request request, HttpTask task) throws IOException {
        IOException e;
        Response response = null;
        if (task == null || task.isCanceled()) {
            throw new IOException("CANCELED");
        }
        int attempts = 0;
        long startTime = System.nanoTime();
        TrafficStrategy strategy = this.getSuitableStrategy(task);
        while (true) {
            String serverDate;
            long waitTook = 0L;
            if (strategy != null) {
                long before = System.currentTimeMillis();
                strategy.waitForPermit();
                waitTook = System.currentTimeMillis() - before;
            }
            if (attempts > 0) {
                long delay = this.retryStrategy.getNextDelay(attempts);
                try {
                    if (delay > waitTook + 500L) {
                        TimeUnit.MILLISECONDS.sleep(delay - waitTook);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            QCloudLogger.i("QCloudHttp", "%s start to testExecute, attempts is %d", request, attempts);
            ++attempts;
            long startNs = System.nanoTime();
            int statusCode = -1;
            try {
                response = this.executeTaskOnce(chain, request, task);
                statusCode = response.code();
                if (task.isDownloadTask()) {
                    task.convertResponse(response);
                }
                e = null;
            }
            catch (IOException exception) {
                e = exception;
            }
            catch (QCloudClientException e1) {
                e = e1.getCause() instanceof IOException ? (IOException)e1.getCause() : new IOException(e1);
            }
            catch (QCloudServiceException e2) {
                e = e2.getCause() instanceof IOException ? (IOException)e2.getCause() : new IOException(e2);
            }
            long networkMillsTook = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            String string = serverDate = response != null ? response.header("Date") : null;
            if (e == null && response.isSuccessful()) {
                if (strategy != null) {
                    strategy.reportSpeed(request, task.getAverageStreamingSpeed(networkMillsTook));
                }
                if (serverDate == null) break;
                HttpConfiguration.calculateGlobalTimeOffset(serverDate, new Date(), 600);
                break;
            }
            try {
                String clockSkewError = this.getClockSkewError(response, statusCode);
                if (clockSkewError != null) {
                    QCloudLogger.i("QCloudHttp", "%s failed for %s", request, clockSkewError);
                    if (serverDate != null) {
                        HttpConfiguration.calculateGlobalTimeOffset(serverDate, new Date());
                    }
                    e = new IOException(new QCloudServiceException("client clock skewed").setErrorCode(clockSkewError));
                    break;
                }
                if (this.shouldRetry(request, response, attempts, startTime, e, statusCode)) {
                    QCloudLogger.i("QCloudHttp", "%s failed for %s, code is %d", request, e, statusCode);
                    continue;
                }
                QCloudLogger.i("QCloudHttp", "%s ends for %s, code is %d", request, e, statusCode);
            }
            finally {
                if (strategy == null) continue;
                if (e instanceof SocketTimeoutException) {
                    strategy.reportTimeOut(request);
                    continue;
                }
                strategy.reportException(request, e);
                continue;
            }
            break;
        }
        if (e != null) {
            throw e;
        }
        return response;
    }

    private TrafficStrategy getSuitableStrategy(HttpTask task) {
        return task.isDownloadTask() ? this.downloadTrafficStrategy : (task.isUploadTask() ? this.uploadTrafficStrategy : null);
    }

    private Response executeTaskOnce(Interceptor.Chain chain, Request request, HttpTask task) throws IOException {
        try {
            if (task.isCanceled()) {
                throw new IOException("CANCELED");
            }
            return this.processSingleRequest(chain, request);
        }
        catch (ProtocolException exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("HTTP 204 had non-zero Content-Length: ")) {
                return new Response.Builder().request(request).message(exception.toString()).code(204).protocol(Protocol.HTTP_1_1).build();
            }
            exception.printStackTrace();
            throw exception;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private boolean isUserCancelled(IOException exception) {
        return exception != null && exception.getMessage() != null && exception.getMessage().toLowerCase().equals("canceled");
    }

    Response processSingleRequest(Interceptor.Chain chain, Request request) throws IOException {
        return chain.proceed(request);
    }

    String getClockSkewError(Response response, int statusCode) {
        ResponseBody body;
        if (response != null && statusCode == 403 && (body = response.body()) != null) {
            try {
                BufferedSource source = body.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.buffer();
                String bodyString = buffer.clone().readString(Charset.forName("UTF-8"));
                Pattern patternCode = Pattern.compile("<Code>(RequestTimeTooSkewed|AccessDenied)</Code>");
                Pattern patternMessage = Pattern.compile("<Message>Request has expired</Message>");
                Matcher matcherCode = patternCode.matcher(bodyString);
                Matcher matcherMessage = patternMessage.matcher(bodyString);
                if (matcherCode.find()) {
                    String code = matcherCode.group(1);
                    if ("RequestTimeTooSkewed".equals(code)) {
                        return "RequestTimeTooSkewed";
                    }
                    if ("AccessDenied".equals(code) && matcherMessage.find()) {
                        return "RequestIsExpired";
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean shouldRetry(Request request, Response response, int attempts, long startTime, IOException e, int statusCode) {
        if (this.isUserCancelled(e)) {
            return false;
        }
        if (!this.retryStrategy.shouldRetry(attempts, System.nanoTime() - startTime)) {
            return false;
        }
        QCloudHttpRetryHandler qCloudHttpRetryHandler = this.retryStrategy.getQCloudHttpRetryHandler();
        if (!qCloudHttpRetryHandler.shouldRetry(request, response, e)) {
            return false;
        }
        if (e != null && this.isRecoverable(e)) {
            return true;
        }
        return statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }

    private boolean isRecoverable(IOException e) {
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return e instanceof SocketTimeoutException;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e instanceof SSLPeerUnverifiedException);
    }

    private static class ModerateTrafficStrategy
    extends TrafficStrategy {
        ModerateTrafficStrategy(String name, int maxConcurrent) {
            super(name, 1, maxConcurrent);
        }
    }

    private static class AggressiveTrafficStrategy
    extends TrafficStrategy {
        AggressiveTrafficStrategy(String name, int maxConcurrent) {
            super(name, maxConcurrent, maxConcurrent);
        }
    }

    private static abstract class TrafficStrategy {
        private final int[] historySpeed = new int[5];
        private int current = 0;
        private final int maxConcurrent;
        private final String name;
        static final int MIN_FAST_SPEED = 300;
        static final int MIN_TIMEOUT_COUNT = 2;
        private ResizableSemaphore controller;
        private AtomicInteger concurrent;
        private AtomicInteger historyConsecutiveTimeoutError = new AtomicInteger(0);

        TrafficStrategy(String name, int concurrent, int maxConcurrent) {
            this.name = name;
            this.maxConcurrent = maxConcurrent;
            this.controller = new ResizableSemaphore(concurrent, true);
            this.concurrent = new AtomicInteger(concurrent);
            QCloudLogger.d("QCloudHttp", name + " init concurrent is " + concurrent, new Object[0]);
        }

        void reportException(Request request, IOException exception) {
            this.controller.release();
        }

        void reportTimeOut(Request request) {
            if (this.historyConsecutiveTimeoutError.get() < 0) {
                this.historyConsecutiveTimeoutError.set(1);
            } else {
                this.historyConsecutiveTimeoutError.incrementAndGet();
            }
            if (this.historyConsecutiveTimeoutError.get() >= 2) {
                this.adjustConcurrentAndRelease(1);
            } else {
                this.controller.release();
            }
        }

        synchronized void reportSpeed(Request request, double averageSpeed) {
            this.historyConsecutiveTimeoutError.decrementAndGet();
            if (averageSpeed > 0.0) {
                QCloudLogger.d("QCloudHttp", this.name + " %s streaming speed is %1.3f KBps", request, averageSpeed);
                int average = this.updateAverageSpeed(averageSpeed);
                int concurrent = this.concurrent.get();
                if (average > (concurrent + 1) * 300 && concurrent < this.maxConcurrent) {
                    this.adjustConcurrentAndRelease(concurrent + 1);
                } else if (average > 0 && average < (concurrent - 1) * 300 && concurrent > 1) {
                    this.adjustConcurrentAndRelease(concurrent - 1);
                } else {
                    this.controller.release();
                }
            } else {
                this.controller.release();
            }
        }

        void waitForPermit() {
            try {
                this.controller.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int updateAverageSpeed(double averageSpeed) {
            int[] nArray = this.historySpeed;
            synchronized (this.historySpeed) {
                this.historySpeed[this.current] = (int)Math.floor(averageSpeed);
                this.current = (this.current + 1) % this.historySpeed.length;
                int sum = 0;
                boolean notEnoughData = false;
                for (int speed : this.historySpeed) {
                    if (speed == 0) {
                        notEnoughData = true;
                        break;
                    }
                    sum += speed;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return notEnoughData ? 0 : sum / this.historySpeed.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearAverageSpeed() {
            int[] nArray = this.historySpeed;
            synchronized (this.historySpeed) {
                for (int i = 0; i < this.historySpeed.length; ++i) {
                    this.historySpeed[i] = 0;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private synchronized void adjustConcurrentAndRelease(int expect) {
            int current = this.concurrent.get();
            int delta = expect - current;
            if (delta == 0) {
                this.controller.release();
            } else {
                this.concurrent.set(expect);
                if (delta > 0) {
                    this.controller.release(1 + delta);
                    this.clearAverageSpeed();
                } else {
                    this.controller.reducePermits(delta *= -1);
                    this.controller.release();
                    this.clearAverageSpeed();
                }
                QCloudLogger.i("QCloudHttp", this.name + " adjust concurrent to " + expect, new Object[0]);
            }
        }
    }

    private static class ResizableSemaphore
    extends Semaphore {
        ResizableSemaphore(int permit, boolean fair) {
            super(permit, fair);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

