/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.core.http.HttpLogger;
import com.tencent.qcloud.core.http.HttpLoggingInterceptor;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.OkHttpProxy;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.RetryAndTrafficControlInterceptor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpClientImpl
extends NetworkClient {
    private EventListener.Factory mEventListenerFactory = new EventListener.Factory(){

        public EventListener create(Call call) {
            return new CallMetricsListener(call);
        }
    };
    private OkHttpClient okHttpClient;

    @Override
    public void init(QCloudHttpClient.Builder b, HostnameVerifier hostnameVerifier, Dns dns, HttpLogger httpLogger) {
        super.init(b, hostnameVerifier, dns, httpLogger);
        HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor(httpLogger);
        logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.okHttpClient = b.mBuilder.followRedirects(true).followSslRedirects(true).hostnameVerifier(hostnameVerifier).dns(dns).connectTimeout((long)b.connectionTimeout, TimeUnit.MILLISECONDS).readTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS).eventListenerFactory(this.mEventListenerFactory).addInterceptor((Interceptor)logInterceptor).addInterceptor((Interceptor)new RetryAndTrafficControlInterceptor(b.retryStrategy)).build();
    }

    @Override
    public NetworkProxy getNetworkProxy() {
        OkHttpProxy okHttpProxy = new OkHttpProxy(this.okHttpClient);
        return okHttpProxy;
    }
}

