/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.content.ContentResolver;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.tencent.qcloud.core.common.QCloudDigistListener;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.http.CountingSink;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.StreamingRequestBody;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class MultipartStreamRequestBody
extends RequestBody
implements ProgressBody,
QCloudDigistListener {
    private Map<String, String> bodyParameters = new LinkedHashMap<String, String>();
    private String name;
    private String fileName;
    StreamingRequestBody streamingRequestBody;
    MultipartBody multipartBody;

    public void setBodyParameters(Map<String, String> bodyParameters) {
        if (bodyParameters != null) {
            this.bodyParameters.putAll(bodyParameters);
        }
    }

    public void setContent(String contentType, String name, String fileName, File file, long offset, long counts) {
        if (name != null) {
            this.name = name;
        }
        this.fileName = fileName;
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)file.getPath());
            contentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        this.streamingRequestBody = ExStreamingRequestBody.file(file, contentType, offset, counts);
    }

    public void setContent(String contentType, String name, String fileName, byte[] bytes, long offset, long counts) {
        if (name != null) {
            this.name = name;
        }
        this.fileName = fileName;
        this.streamingRequestBody = ExStreamingRequestBody.bytes(bytes, contentType, offset, counts);
    }

    public void setContent(String contentType, String name, String fileName, File tmpFile, InputStream stream, long offset, long counts) throws IOException {
        if (name != null) {
            this.name = name;
        }
        this.fileName = fileName;
        this.streamingRequestBody = ExStreamingRequestBody.steam(stream, tmpFile, contentType, offset, counts);
    }

    public void setSign(String sign) {
        if (sign != null) {
            this.bodyParameters.put("Signature", sign);
        }
    }

    public void addMd5() throws IOException {
        this.bodyParameters.put("Content-MD5", this.onGetMd5());
    }

    public void build() {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MediaType.parse((String)"multipart/form-data"));
        for (Map.Entry<String, String> entry : this.bodyParameters.entrySet()) {
            builder.addFormDataPart(entry.getKey(), entry.getValue());
        }
        builder.addFormDataPart(this.name, this.fileName, (RequestBody)this.streamingRequestBody);
        this.multipartBody = builder.build();
    }

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        if (this.streamingRequestBody != null) {
            this.streamingRequestBody.setProgressListener(progressListener);
        }
    }

    @Override
    public long getBytesTransferred() {
        return this.streamingRequestBody != null ? this.streamingRequestBody.getBytesTransferred() : 0L;
    }

    public MediaType contentType() {
        return this.multipartBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.multipartBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try {
            this.multipartBody.writeTo(sink);
        }
        finally {
            Util.closeQuietly((Closeable)((Object)this.streamingRequestBody.countingSink));
        }
    }

    @Override
    public String onGetMd5() throws IOException {
        if (this.streamingRequestBody != null) {
            String md5 = this.streamingRequestBody.onGetMd5();
            this.bodyParameters.put("Content-MD5", md5);
            return md5;
        }
        return null;
    }

    private static class ExStreamingRequestBody
    extends StreamingRequestBody {
        protected ExStreamingRequestBody() {
        }

        static StreamingRequestBody file(File file, String contentType) {
            return ExStreamingRequestBody.file(file, contentType, 0L, Long.MAX_VALUE);
        }

        static StreamingRequestBody file(File file, String contentType, long offset, long length) {
            ExStreamingRequestBody requestBody = new ExStreamingRequestBody();
            requestBody.file = file;
            requestBody.contentType = contentType;
            requestBody.offset = offset < 0L ? 0L : offset;
            requestBody.requiredLength = length;
            return requestBody;
        }

        static StreamingRequestBody bytes(byte[] bytes, String contentType, long offset, long length) {
            ExStreamingRequestBody requestBody = new ExStreamingRequestBody();
            requestBody.bytes = bytes;
            requestBody.contentType = contentType;
            requestBody.offset = offset < 0L ? 0L : offset;
            requestBody.requiredLength = length;
            return requestBody;
        }

        static StreamingRequestBody steam(InputStream inputStream, File tmpFile, String contentType, long offset, long length) {
            ExStreamingRequestBody requestBody = new ExStreamingRequestBody();
            requestBody.stream = inputStream;
            requestBody.contentType = contentType;
            requestBody.file = tmpFile;
            requestBody.offset = offset < 0L ? 0L : offset;
            requestBody.requiredLength = length;
            return requestBody;
        }

        static StreamingRequestBody url(URL url, String contentType, long offset, long length) {
            ExStreamingRequestBody requestBody = new ExStreamingRequestBody();
            requestBody.url = url;
            requestBody.contentType = contentType;
            requestBody.offset = offset < 0L ? 0L : offset;
            requestBody.requiredLength = length;
            return requestBody;
        }

        static StreamingRequestBody uri(Uri uri, ContentResolver contentResolver, String contentType, long offset, long length) {
            ExStreamingRequestBody requestBody = new ExStreamingRequestBody();
            requestBody.uri = uri;
            requestBody.contentResolver = contentResolver;
            requestBody.contentType = contentType;
            requestBody.offset = offset < 0L ? 0L : offset;
            requestBody.requiredLength = length;
            return requestBody;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            InputStream inputStream = null;
            BufferedSource source = null;
            try {
                inputStream = this.getStream();
                if (inputStream != null) {
                    source = Okio.buffer((Source)Okio.source((InputStream)inputStream));
                    long contentLength = this.contentLength();
                    this.countingSink = new CountingSink((Sink)sink, contentLength, this.progressListener);
                    BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
                    if (contentLength > 0L) {
                        bufferedSink.write((Source)source, contentLength);
                    } else {
                        bufferedSink.writeAll((Source)source);
                    }
                    bufferedSink.flush();
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly((Closeable)inputStream);
                Util.closeQuietly(source);
                throw throwable;
            }
            Util.closeQuietly((Closeable)inputStream);
            Util.closeQuietly((Closeable)source);
        }
    }
}

