/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

public class HttpTaskMetrics {
    private long fullTaskStartTime;
    private long fullTaskTookTime;
    private long calculateMD5StartTime;
    private long calculateMD5STookTime;
    private long signRequestStartTime;
    private long signRequestTookTime;
    long dnsLookupTookTime;
    long connectTookTime;
    long secureConnectTookTime;
    long writeRequestHeaderTookTime;
    long writeRequestBodyTookTime;
    long readResponseHeaderTookTime;
    long readResponseBodyTookTime;

    void onTaskStart() {
        this.fullTaskStartTime = System.nanoTime();
    }

    void onTaskEnd() {
        this.fullTaskTookTime = System.nanoTime() - this.fullTaskStartTime;
        this.onDataReady();
    }

    void onCalculateMD5Start() {
        this.calculateMD5StartTime = System.nanoTime();
    }

    void onCalculateMD5End() {
        this.calculateMD5STookTime += System.nanoTime() - this.calculateMD5StartTime;
    }

    void onSignRequestStart() {
        this.signRequestStartTime = System.nanoTime();
    }

    void onSignRequestEnd() {
        this.signRequestTookTime += System.nanoTime() - this.signRequestStartTime;
    }

    public double dnsLookupTookTime() {
        return this.toSeconds(this.dnsLookupTookTime);
    }

    public double connectTookTime() {
        return this.toSeconds(this.connectTookTime);
    }

    public double secureConnectTookTime() {
        return this.toSeconds(this.secureConnectTookTime);
    }

    public double calculateMD5STookTime() {
        return this.toSeconds(this.calculateMD5STookTime);
    }

    public double signRequestTookTime() {
        return this.toSeconds(this.signRequestTookTime);
    }

    public double readResponseHeaderTookTime() {
        return this.toSeconds(this.readResponseHeaderTookTime);
    }

    public double readResponseBodyTookTime() {
        return this.toSeconds(this.readResponseBodyTookTime);
    }

    public double writeRequestBodyTookTime() {
        return this.toSeconds(this.writeRequestBodyTookTime);
    }

    public double writeRequestHeaderTookTime() {
        return this.toSeconds(this.writeRequestHeaderTookTime);
    }

    public double fullTaskTookTime() {
        return this.toSeconds(this.fullTaskTookTime);
    }

    private double toSeconds(long nanotime) {
        return (double)nanotime / 1.0E9;
    }

    public void onDataReady() {
    }

    public String toString() {
        return "Http Metrics: \n" + "fullTaskTookTime : " + this.fullTaskTookTime() + "\n" + "calculateMD5STookTime : " + this.calculateMD5STookTime() + "\n" + "signRequestTookTime : " + this.signRequestTookTime() + "\n" + "dnsLookupTookTime : " + this.dnsLookupTookTime() + "\n" + "connectTookTime : " + this.connectTookTime() + "\n" + "secureConnectTookTime : " + this.secureConnectTookTime() + "\n" + "writeRequestHeaderTookTime : " + this.writeRequestHeaderTookTime() + "\n" + "writeRequestBodyTookTime : " + this.writeRequestBodyTookTime() + "\n" + "readResponseHeaderTookTime : " + this.readResponseHeaderTookTime() + "\n" + "readResponseBodyTookTime : " + this.readResponseBodyTookTime();
    }
}

