/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.logger.QCloudLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpConfiguration {
    private static final AtomicInteger GLOBAL_TIME_OFFSET = new AtomicInteger(0);
    private static final String RFC822_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static SimpleDateFormat gmtFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public static void calculateGlobalTimeOffset(String sDate, Date deviceDate) {
        HttpConfiguration.calculateGlobalTimeOffset(sDate, deviceDate, 0);
    }

    public static void calculateGlobalTimeOffset(String sDate, Date deviceDate, int minOffset) {
        try {
            Date serverDate = gmtFormatter.parse(sDate);
            int clockSkew = (int)(serverDate.getTime() - deviceDate.getTime()) / 1000;
            if (Math.abs(clockSkew) >= minOffset) {
                GLOBAL_TIME_OFFSET.set(clockSkew);
                QCloudLogger.i("QCloudHttp", "NEW TIME OFFSET is " + clockSkew + "s", new Object[0]);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static long getDeviceTimeWithOffset() {
        return System.currentTimeMillis() / 1000L + (long)GLOBAL_TIME_OFFSET.get();
    }

    public static String getGMTDate(Date date) {
        return gmtFormatter.format(date);
    }

    static {
        gmtFormatter.setTimeZone(GMT_TIMEZONE);
        gmtFormatter.setLenient(false);
    }
}

