/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.BasicLifecycleCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionCredentialProvider
extends BasicLifecycleCredentialProvider {
    private HttpRequest<String> httpRequest;
    private HttpRequest.Builder<String> requestBuilder;

    public SessionCredentialProvider() {
    }

    public SessionCredentialProvider(HttpRequest<String> httpRequest) {
        this.httpRequest = httpRequest;
    }

    public SessionCredentialProvider(HttpRequest.Builder<String> requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    @Override
    protected QCloudLifecycleCredentials fetchNewCredentials() throws QCloudClientException {
        HttpRequest<String> fetchSTSRequest = null;
        if (this.httpRequest != null) {
            fetchSTSRequest = this.buildRequest(this.httpRequest);
        } else if (this.requestBuilder != null) {
            fetchSTSRequest = this.buildRequest(this.requestBuilder);
        }
        if (fetchSTSRequest != null) {
            try {
                HttpResult result = (HttpResult)QCloudHttpClient.getDefault().resolveRequest(fetchSTSRequest).executeNow();
                if (result.isSuccessful()) {
                    return this.parseServerResponse((String)result.content());
                }
                throw new QCloudClientException("fetch new credentials error ", result.asException());
            }
            catch (QCloudServiceException e) {
                throw new QCloudClientException("fetch new credentials error ", e);
            }
        }
        throw new QCloudClientException("please pass http request object for fetching");
    }

    protected HttpRequest<String> buildRequest(HttpRequest<String> httpRequest) {
        return httpRequest;
    }

    protected HttpRequest<String> buildRequest(HttpRequest.Builder<String> requestBuilder) {
        return requestBuilder.build();
    }

    protected SessionQCloudCredentials parseServerResponse(String jsonContent) throws QCloudClientException {
        return SessionCredentialProvider.parseStandardSTSJsonResponse(jsonContent);
    }

    static SessionQCloudCredentials parseStandardSTSJsonResponse(String jsonContent) throws QCloudClientException {
        if (jsonContent != null) {
            try {
                JSONObject jsonObject = new JSONObject(jsonContent);
                JSONObject data = jsonObject.optJSONObject("data");
                if (data == null) {
                    data = jsonObject;
                }
                JSONObject credentials = data.optJSONObject("credentials");
                int code = data.optInt("code", -1);
                if (credentials != null) {
                    long expiredTime = data.optLong("expiredTime");
                    long startTime = data.optLong("startTime");
                    String sessionToken = credentials.optString("sessionToken");
                    String tmpSecretId = credentials.optString("tmpSecretId");
                    String tmpSecretKey = credentials.optString("tmpSecretKey");
                    if (startTime > 0L) {
                        return new SessionQCloudCredentials(tmpSecretId, tmpSecretKey, sessionToken, startTime, expiredTime);
                    }
                    return new SessionQCloudCredentials(tmpSecretId, tmpSecretKey, sessionToken, expiredTime);
                }
                if (code > 0) {
                    throw new QCloudClientException("get credentials error : " + data.toString());
                }
            }
            catch (JSONException e) {
                throw new QCloudClientException("parse session json fails", e);
            }
        }
        return null;
    }
}

