/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.http.HttpConfiguration;

public class BasicQCloudCredentials
implements QCloudLifecycleCredentials {
    private final String secretId;
    private final String signKey;
    private final String keyTime;

    public BasicQCloudCredentials(String secretId, String signKey, long beginTime, long expiredTime) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (signKey == null) {
            throw new IllegalArgumentException("signKey cannot be null.");
        }
        if (beginTime >= expiredTime) {
            throw new IllegalArgumentException("beginTime must be less than expiredTime.");
        }
        this.secretId = secretId;
        this.signKey = signKey;
        this.keyTime = Utils.handleTimeAccuracy(beginTime) + ";" + Utils.handleTimeAccuracy(expiredTime);
    }

    public BasicQCloudCredentials(String secretId, String signKey, String keyTime) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (signKey == null) {
            throw new IllegalArgumentException("signKey cannot be null.");
        }
        if (keyTime == null) {
            throw new IllegalArgumentException("keyTime cannot be null.");
        }
        this.secretId = secretId;
        this.signKey = signKey;
        this.keyTime = keyTime;
    }

    @Override
    public boolean isValid() {
        long[] times;
        long current = HttpConfiguration.getDeviceTimeWithOffset();
        return current > (times = Utils.parseKeyTimes(this.keyTime))[0] && current < times[1] - 60L;
    }

    @Override
    public String getKeyTime() {
        return this.keyTime;
    }

    @Override
    public String getSignKey() {
        return this.signKey;
    }

    @Override
    public String getSecretId() {
        return this.secretId;
    }
}

