/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.retry;

import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.IOException;
import java.net.ProtocolException;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConnectionRetryHandler
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(NetworkConnectionRetryHandler.class);
    private int maxRetryNumber;
    private int hasRetriedTimes;

    public NetworkConnectionRetryHandler(int maxRetryNumber) {
        this.maxRetryNumber = maxRetryNumber;
        this.hasRetriedTimes = 0;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        while (this.hasRetriedTimes < this.maxRetryNumber) {
            try {
                QCloudLogger.debug(this.logger, "has retry times = {}", this.hasRetriedTimes);
                response = chain.proceed(request);
                break;
            }
            catch (ProtocolException exception) {
                if (exception.getMessage().contains("HTTP 204 had non-zero Content-Length: ")) {
                    response = new Response.Builder().request(request).message(exception.getMessage()).code(204).protocol(Protocol.HTTP_1_1).build();
                    break;
                }
                exception.printStackTrace();
                ++this.hasRetriedTimes;
            }
            catch (IOException exception) {
                if (exception.getMessage() != null && exception.getMessage().toLowerCase().equals("canceled")) {
                    throw exception;
                }
                exception.printStackTrace();
                ++this.hasRetriedTimes;
            }
        }
        if (response == null) {
            response = chain.proceed(request);
        }
        return response;
    }
}

