/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.action;

import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.action.QCloudRequestAction;
import com.tencent.qcloud.network.logger.QCloudLogger;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudBodyMd5Action
extends QCloudRequestAction {
    private Logger logger = LoggerFactory.getLogger(QCloudBodyMd5Action.class);

    public QCloudBodyMd5Action(QCloudHttpRequest httpRequest) {
        super(httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        RequestBody requestBody = this.httpRequest.getHttpRequest().body();
        if (requestBody == null) {
            QCloudLogger.warn(this.logger, "calculate md5 failed, request body is null.");
            return;
        }
        try (Buffer sink = new Buffer();){
            requestBody.writeTo((BufferedSink)sink);
            String md5 = sink.md5().base64();
            QCloudLogger.debug(this.logger, "md5 string is {}", md5);
            Request.Builder builder = this.httpRequest.getHttpRequest().newBuilder();
            builder.addHeader("Content-MD5", md5);
            this.httpRequest.setHttpRequest(builder.build());
        }
    }

    public String toString() {
        return "MD5 Action";
    }
}

