/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.retry;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class DefaultRetryHandler
implements Interceptor {
    private int maxRetryNumber;
    private int hasRetriedTimes;

    public DefaultRetryHandler(int maxRetryNumber) {
        this.maxRetryNumber = maxRetryNumber;
        this.hasRetriedTimes = 0;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        while (!(this.hasRetriedTimes >= this.maxRetryNumber || response != null && response.isSuccessful())) {
            ++this.hasRetriedTimes;
            response = chain.proceed(request);
        }
        return response;
    }
}

