/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.serializer;

import android.net.Uri;
import android.text.TextUtils;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import com.tencent.qcloud.network.tools.QCloudJsonTools;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class QCloudHttpRequestOrigin {
    private static Logger logger = LoggerFactory.getLogger(QCloudHttpRequestOrigin.class);
    private String method;
    private Uri uri;
    private Map<String, String> headers;
    private RequestBody requestBody;

    private QCloudHttpRequestOrigin(String method, Uri uri, Map<String, String> headers, RequestBody requestBody) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.requestBody = requestBody;
    }

    public Request build() {
        return new Request.Builder().url(this.uri.toString()).headers(Headers.of(this.headers)).method(this.method, this.requestBody).build();
    }

    @Deprecated
    public static class Builder {
        private String scheme;
        private StringBuilder host;
        private StringBuilder path;
        private String method;
        private Map<String, String> headers = new HashMap<String, String>();
        private Uri.Builder builder;
        private Map<String, String> bodyKeyValues = new HashMap<String, String>();
        private Map<String, String> uploadFilePaths = new HashMap<String, String>();
        private byte[] uploadByteArray;
        private Map<String, String> queries;
        private StringBuilder query;
        private JSONObject jsonHttpBody;

        public Builder() {
            this.path = new StringBuilder();
            this.host = new StringBuilder();
            this.query = new StringBuilder();
            this.builder = new Uri.Builder();
            this.queries = new HashMap<String, String>();
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder hostAddFront(String part) {
            this.host.insert(0, part);
            return this;
        }

        public Builder hostAddRear(String part) {
            this.host.append(part);
            return this;
        }

        public Builder pathAddFront(String part) {
            this.path.insert(0, part);
            if (!part.startsWith("/")) {
                this.path.insert(0, "/");
            }
            return this;
        }

        public Builder pathAddRear(String part) {
            if (!part.startsWith("/")) {
                this.path.append("/");
            }
            this.path.append(part);
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder bodyKeyValue(String key, String values) {
            this.bodyKeyValues.put(key, values);
            return this;
        }

        public Builder bodyKeyValue(String key, Map<String, String> values) {
            this.bodyKeyValues.put(key, QCloudJsonTools.Map2JsonString(values));
            return this;
        }

        public Builder uploadFilePath(String filePath, String fileMessage) {
            this.uploadFilePaths.put(filePath, fileMessage);
            return this;
        }

        public Builder uploadByteArray(byte[] content) {
            this.uploadByteArray = content;
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder query(String key, String value) {
            this.queries.put(key, value);
            if (!TextUtils.isEmpty((CharSequence)this.query.toString())) {
                this.query.append("&");
            }
            this.query.append(Uri.encode((String)key));
            if (!TextUtils.isEmpty((CharSequence)value)) {
                this.query.append("=");
                this.query.append(Uri.encode((String)value));
            }
            return this;
        }

        public QCloudHttpRequestOrigin build(RequestBodySerializer bodySerializer) {
            QCloudLogger.debug(logger, "QCloudHttpRequestOrigin build");
            RequestBody requestBody = null;
            if (bodySerializer != null) {
                requestBody = bodySerializer.serialize();
            } else {
                QCloudLogger.error(logger, "body serializer is null");
            }
            QCloudLogger.debug(logger, "request body serialize success");
            this.builder.scheme(this.scheme).encodedQuery(this.query.toString()).authority(this.host.toString()).path(this.path.toString());
            QCloudLogger.debug(logger, "real url is {}", this.builder.build().toString());
            return new QCloudHttpRequestOrigin(this.method, this.builder.build(), this.headers, requestBody);
        }

        public JSONObject getJsonHttpBody() {
            return this.jsonHttpBody;
        }

        public Map<String, String> getBodyKeyValues() {
            return this.bodyKeyValues;
        }

        public Map<String, String> getUploadFilePaths() {
            return this.uploadFilePaths;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Map<String, String> getQueries() {
            return this.queries;
        }

        public String getPath() {
            return this.path.toString();
        }

        public String getMethod() {
            return this.method;
        }

        public String getHost() {
            return this.host.toString();
        }

        public byte[] getUploadByteArray() {
            return this.uploadByteArray;
        }
    }
}

