/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.bodys;

import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.bodys.BodyUploadProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRequestBody
extends RequestBody {
    private static final Logger logger = LoggerFactory.getLogger(FileRequestBody.class);
    private final File file;
    private long offset = 0L;
    private long length = 0L;
    private final String contentType;
    private BodyUploadProgressListener progressListener;

    public void setProgressListener(BodyUploadProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public FileRequestBody(File file, String contentType) {
        this(file, contentType, -1L, -1L);
    }

    public FileRequestBody(File file, String contentType, long offset, long length) {
        this.file = file;
        this.contentType = contentType;
        if (offset < 0L) {
            offset = 0L;
        }
        this.offset = offset;
        if (length < 0L) {
            length = file.length();
        }
        this.length = length;
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        long all;
        FileInputStream inputStream = null;
        Source source = null;
        long remain = all = this.length;
        int bufferSize = 2048;
        int percent = 0;
        try {
            inputStream = new FileInputStream(this.file);
            source = Okio.source((InputStream)inputStream);
            ((InputStream)inputStream).skip(this.offset);
            while (remain > 0L) {
                int progress;
                long maxReadSize = Math.min((long)bufferSize, remain);
                long readLength = source.read(bufferedSink.buffer(), maxReadSize);
                if (readLength != -1L && (progress = (int)Math.floor(100.0 * (double)(all - (remain -= readLength)) / (double)all)) >= percent) {
                    ++percent;
                    if (this.progressListener != null) {
                        this.progressListener.onProgress(all - remain, all);
                    }
                }
                bufferedSink.flush();
            }
            QCloudLogger.info(logger, "file finished.");
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public long contentLength() throws IOException {
        return this.length;
    }
}

