/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.auth;

import com.tencent.qcloud.network.auth.BasicCredentialProvider;
import com.tencent.qcloud.network.auth.BasicSignaturePair;
import com.tencent.qcloud.network.auth.SessionCredential;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.tools.HexUtils;
import com.tencent.qcloud.network.tools.QCloudEncryptTools;

public abstract class SmartSessionCredentialProvider
extends BasicCredentialProvider {
    protected SessionCredential sessionCredential;

    public SmartSessionCredentialProvider() {
        super(null);
    }

    @Override
    public BasicSignaturePair signaturePair() throws QCloudException {
        long currentTime = System.currentTimeMillis() / 1000L;
        String keyTime = "";
        this.sessionCredential = this.sessionCredential();
        if (this.sessionCredential == null) {
            throw new QCloudException(QCloudExceptionType.CALCULATE_SIGNATURE_FAILED, "SmartSessionCredentialProvider get SessionCredential failed");
        }
        this.secretId = this.sessionCredential.getSecretId();
        keyTime = currentTime + ";" + this.sessionCredential.getExpire();
        return new BasicSignaturePair(this.secretKey2SignKey(this.sessionCredential.getSecretKey(), keyTime), keyTime);
    }

    protected abstract SessionCredential sessionCredential() throws QCloudException;

    private String secretKey2SignKey(String secretKey, String keyTime) {
        return new String(HexUtils.encodeHex(QCloudEncryptTools.hmacSha1(keyTime, secretKey)));
    }

    public String getToken() {
        return this.sessionCredential != null ? this.sessionCredential.getToken() : "";
    }

    public void setSessionCredential(SessionCredential sessionCredential) {
        this.sessionCredential = sessionCredential;
    }
}

