/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.auth;

import android.util.Base64;
import com.tencent.qcloud.network.auth.SessionCredential;
import com.tencent.qcloud.network.auth.SmartSessionCredentialProvider;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.tools.QCloudEncryptTools;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class SampleSessionCredentialProvider
extends SmartSessionCredentialProvider {
    private static final String CLIENT = "COS_XML_1.0";
    private String secretId;
    private String secretKey;
    private String appid;

    public SampleSessionCredentialProvider(String secretId, String secretKey, String appid) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.appid = appid;
    }

    @Override
    public SessionCredential sessionCredential() throws QCloudException {
        SessionCredential sessionCredential = null;
        String json = this.getSession(this.secretId, this.secretKey, this.appid);
        if (json != null) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                JSONObject data = jsonObject.optJSONObject("data");
                if (data != null) {
                    JSONObject credentials = data.optJSONObject("credentials");
                    long expiredTime = data.optLong("expiredTime");
                    if (credentials != null) {
                        String sessionToken = credentials.optString("sessionToken");
                        String tmpSecretId = credentials.optString("tmpSecretId");
                        String tmpSecretKey = credentials.optString("tmpSecretKey");
                        sessionCredential = new SessionCredential(tmpSecretId, tmpSecretKey, sessionToken, expiredTime);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return sessionCredential;
    }

    private String getSession(String secretId, String secretKey, String appid) {
        String requestHost = "sts.api.qcloud.com";
        String requestPath = "/v2/index.php";
        String requestMethod = "GET";
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        String policy = String.format("{\"statement\": [{\"action\": [\"name/cos:*\"],\"effect\": \"allow\",\"resource\":[\"qcs::cos:cn-south:uid/%s:prefix//%s/*\"]}],\"version\": \"2.0\"}", appid, appid);
        params.put("policy", policy);
        params.put("name", "Rabbitliu");
        params.put("Action", "GetFederationToken");
        params.put("SecretId", secretId);
        params.put("Nonce", new Random().nextInt(Integer.MAX_VALUE));
        params.put("Timestamp", System.currentTimeMillis() / 1000L);
        params.put("RequestClient", CLIENT);
        String plainText = this.makeSignPlainText(params, requestMethod, requestHost, requestPath);
        try {
            params.put("Signature", Base64.encodeToString((byte[])QCloudEncryptTools.hmacSha1(plainText, secretKey), (int)0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String url = "https://" + requestHost + requestPath;
        return this.sendRequest(url, params, requestMethod);
    }

    private String makeSignPlainText(TreeMap<String, Object> requestParams, String requestMethod, String requestHost, String requestPath) {
        String retStr = "";
        retStr = retStr + requestMethod;
        retStr = retStr + requestHost;
        retStr = retStr + requestPath;
        retStr = retStr + this.buildParamStr(requestParams);
        return retStr;
    }

    private String buildParamStr(TreeMap<String, Object> requestParams) {
        String retStr = "";
        for (String key : requestParams.keySet()) {
            retStr = retStr.length() == 0 ? retStr + '?' : retStr + '&';
            retStr = retStr + key.replace("_", ".") + '=' + requestParams.get(key).toString();
        }
        return retStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(String url, Map<String, Object> requestParams, String requestMethod) {
        String result = "";
        BufferedReader in = null;
        String paramStr = "";
        for (String key : requestParams.keySet()) {
            if (!paramStr.isEmpty()) {
                paramStr = paramStr + '&';
            }
            try {
                paramStr = paramStr + key + '=' + URLEncoder.encode(requestParams.get(key).toString(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        try {
            String line;
            if (requestMethod.equals("GET")) {
                url = url.indexOf(63) > 0 ? url + '&' + paramStr : url + '?' + paramStr;
            }
            URL realUrl = new URL(url);
            URLConnection connection = null;
            if (url.toLowerCase().startsWith("https")) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)realUrl.openConnection();
                connection = httpsConn;
            } else {
                connection = realUrl.openConnection();
            }
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setConnectTimeout(1000);
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }
}

