/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.auth;

import android.text.TextUtils;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.auth.BasicSignaturePair;
import com.tencent.qcloud.network.auth.BasicSignatureSourceEncryptor;
import com.tencent.qcloud.network.auth.BasicSignatureSourceSerializer;
import com.tencent.qcloud.network.auth.CredentialProviderConst;
import com.tencent.qcloud.network.auth.QCloudCredentialProvider;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicCredentialProvider
extends QCloudCredentialProvider {
    private Logger logger = LoggerFactory.getLogger(BasicCredentialProvider.class);
    protected String secretId;
    private volatile BasicSignaturePair basicSignaturePair;
    private volatile ReentrantLock lock = new ReentrantLock();

    public BasicCredentialProvider(String secretId) {
        this.secretId = secretId;
    }

    public abstract BasicSignaturePair signaturePair() throws QCloudException;

    private boolean needUpdateSignaturePair() {
        if (this.basicSignaturePair == null) {
            QCloudLogger.debug(this.logger, "basic signature is null");
            return true;
        }
        QCloudLogger.debug(this.logger, this.basicSignaturePair.toString());
        String keyTime = this.basicSignaturePair.getKeyTime();
        if (TextUtils.isEmpty((CharSequence)keyTime)) {
            return true;
        }
        String[] times = keyTime.split(";");
        if (times.length != 2) {
            return true;
        }
        String expire = times[1];
        long expireTime = Long.valueOf(expire);
        long currentTime = System.currentTimeMillis() / 1000L;
        return currentTime > expireTime - 60L;
    }

    @Override
    public String signature(QCloudHttpRequest httpRequest) throws QCloudException {
        try {
            boolean locked = this.lock.tryLock(20L, TimeUnit.SECONDS);
            if (!locked) {
                throw new QCloudException(QCloudExceptionType.CALCULATE_SIGNATURE_FAILED, "");
            }
        }
        catch (InterruptedException e) {
            throw new QCloudException(QCloudExceptionType.CALCULATE_SIGNATURE_FAILED, "try lock interrupted exception");
        }
        try {
            if (this.needUpdateSignaturePair()) {
                QCloudLogger.debug(this.logger, "should update signature pair");
                this.basicSignaturePair = this.signaturePair();
            } else {
                QCloudLogger.debug(this.logger, "no need to update signature pair");
            }
            if (this.needUpdateSignaturePair()) {
                throw new QCloudException(QCloudExceptionType.CALCULATE_SIGNATURE_FAILED, "update wrong signature pair");
            }
            this.sourceEncryptor = new BasicSignatureSourceEncryptor(this.basicSignaturePair.getSignKey(), this.basicSignaturePair.getKeyTime());
            this.sourceSerializer = httpRequest.getSourceSerializer();
            if (this.sourceSerializer == null) {
                QCloudLogger.debug(this.logger, "source serializer is null");
                String e = "";
                return e;
            }
            QCloudLogger.debug(this.logger, "source serializer is not null");
            BasicSignatureSourceSerializer xmlSourceSerializer = (BasicSignatureSourceSerializer)this.sourceSerializer;
            BasicSignatureSourceEncryptor xmlSourceEncryptor = (BasicSignatureSourceEncryptor)this.sourceEncryptor;
            xmlSourceSerializer.setHttpRequest(httpRequest);
            StringBuilder authorization = new StringBuilder();
            String signature = xmlSourceEncryptor.signature(xmlSourceSerializer.source());
            authorization.append(CredentialProviderConst.Q_SIGN_ALGORITHM).append("=").append(CredentialProviderConst.SHA1).append("&").append(CredentialProviderConst.Q_AK).append("=").append(this.secretId).append("&").append(CredentialProviderConst.Q_SIGN_TIME).append("=").append(xmlSourceSerializer.getSignTime()).append("&").append(CredentialProviderConst.Q_KEY_TIME).append("=").append(xmlSourceEncryptor.getKeyTime()).append("&").append(CredentialProviderConst.Q_HEADER_LIST).append("=").append(xmlSourceSerializer.getRealHeaderList().toLowerCase()).append("&").append(CredentialProviderConst.Q_URL_PARAM_LIST).append("=").append(xmlSourceSerializer.getRealParameterList().toLowerCase()).append("&").append(CredentialProviderConst.Q_SIGNATURE).append("=").append(signature);
            QCloudLogger.debug(this.logger, "authorization is " + authorization.toString());
            String string = authorization.toString();
            return string;
        }
        catch (QCloudException exception) {
            throw exception;
        }
        finally {
            this.lock.unlock();
        }
    }
}

