/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.action;

import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.action.QCloudRequestAction;
import com.tencent.qcloud.network.logger.QCloudLogger;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudBodySha1Action
extends QCloudRequestAction {
    private Logger logger = LoggerFactory.getLogger(QCloudBodySha1Action.class);

    public QCloudBodySha1Action(QCloudHttpRequest httpRequest) {
        super(httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        RequestBody requestBody = this.httpRequest.getHttpRequest().body();
        if (requestBody == null) {
            QCloudLogger.warn(this.logger, "calculate sha1 failed, request body is null.");
            return;
        }
        try (Buffer sink = new Buffer();){
            requestBody.writeTo((BufferedSink)sink);
            String sha1 = sink.sha1().hex();
            QCloudLogger.debug(this.logger, "sha1 string is {}", sha1);
            Request.Builder builder = this.httpRequest.getHttpRequest().newBuilder();
            builder.addHeader("x-cos-content-sha1", sha1);
            this.httpRequest.setHttpRequest(builder.build());
        }
    }

    public String toString() {
        return "SHA1 Action";
    }
}

