/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.action;

import com.tencent.qcloud.network.action.QCloudRequestAction;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudActionManager {
    private Logger logger = LoggerFactory.getLogger(QCloudActionManager.class);
    private ExecutorService actionExecutor;

    public QCloudActionManager(int maxActionConcurrent) {
        this.actionExecutor = Executors.newFixedThreadPool(maxActionConcurrent);
    }

    public void execute(QCloudRequestAction action) {
        QCloudLogger.debug(this.logger, "QCloudActionManager execute");
        Future future = null;
        try {
            future = this.actionExecutor.submit(action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        action.setFuture(future);
    }

    public void cancel(QCloudRequestAction action) {
        if (action.getFuture() != null) {
            action.getFuture().cancel(true);
            if (action.getActionResultListener() != null) {
                action.getActionResultListener().onFailed(action, new QCloudException(QCloudExceptionType.REQUEST_USER_CANCELLED));
            }
        }
    }

    public void release() {
        if (this.actionExecutor != null) {
            this.actionExecutor.shutdownNow();
        }
    }
}

