/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.common;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import android.webkit.WebSettings;
import com.tencent.mid.api.MidService;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatMultiAccount;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatSpecifyReportedInfo;
import com.tencent.stat.common.DeviceInfo;
import com.tencent.stat.common.StatConstants;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.StatPreferences;
import com.tencent.stat.common.Util;
import com.tencent.stat.e;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.http.HttpHost;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatCommonHelper {
    private static String a = null;
    private static String b = null;
    private static String c = null;
    private static String d = null;
    private static Random e = null;
    private static DisplayMetrics f = null;
    private static String g = null;
    private static String h = "";
    private static String i = "";
    private static String j = "";
    private static String k = "";
    private static int l = -1;
    private static StatLogger m = null;
    private static String n = null;
    private static String o = null;
    private static volatile int p = -1;
    private static String q = null;
    private static String r = null;
    private static long s = -1L;
    private static String t = "";
    private static String u = "__MTA_FIRST_ACTIVATE__";
    private static int v = -1;
    private static long w = -1L;
    private static int x = 0;
    private static long y = -1L;
    public static String NEXT_REPORT = "next_al_report_time";
    private static long z = 0L;
    private static Intent A = null;

    public static DeviceInfo getUser(Context context) {
        return com.tencent.stat.e.a(context).b(context);
    }

    private static synchronized Random b() {
        if (null == e) {
            e = new Random();
        }
        return e;
    }

    public static JSONArray multiAccountMapToJSONArray(Map<StatMultiAccount.AccountType, StatMultiAccount> map) {
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry<StatMultiAccount.AccountType, StatMultiAccount> entry : map.entrySet()) {
            StatMultiAccount statMultiAccount = entry.getValue();
            if (statMultiAccount == null) continue;
            jSONArray.put((Object)statMultiAccount.toJson());
        }
        return jSONArray;
    }

    public static Map<StatMultiAccount.AccountType, StatMultiAccount> multiAccounStrToMap(String string) {
        HashMap<StatMultiAccount.AccountType, StatMultiAccount> hashMap = new HashMap<StatMultiAccount.AccountType, StatMultiAccount>();
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONArray jSONArray = new JSONArray(string);
                int n2 = jSONArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2 = jSONArray.optString(i2);
                    StatMultiAccount statMultiAccount = StatMultiAccount.parse(string2);
                    hashMap.put(statMultiAccount.getType(), statMultiAccount);
                }
            }
        }
        catch (JSONException jSONException) {
            m.e(jSONException);
        }
        return hashMap;
    }

    public static void encodeMultiAccount(JSONObject jSONObject, Map<StatMultiAccount.AccountType, StatMultiAccount> map) {
        try {
            if (map != null) {
                JSONArray jSONArray = StatCommonHelper.multiAccountMapToJSONArray(map);
                jSONObject.put("cua", (Object)jSONArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getNextSessionID() {
        return StatCommonHelper.b().nextInt(Integer.MAX_VALUE);
    }

    public static byte[] deocdeGZipContent(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n2 = 0;
        while ((n2 = gZIPInputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n2);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byteArrayInputStream.close();
        gZIPInputStream.close();
        byteArrayOutputStream.close();
        return byArray3;
    }

    public static String md5sum(String string) {
        if (null == string) {
            return "0";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2 = 0xFF & byArray[i2];
                if (n2 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return "0";
        }
    }

    public static HttpHost getHttpProxy(Context context) {
        if (null == context) {
            return null;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
                return null;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return null;
            }
            if (networkInfo.getTypeName() != null && networkInfo.getTypeName().equalsIgnoreCase("WIFI")) {
                return null;
            }
            String string = networkInfo.getExtraInfo();
            if (string == null) {
                return null;
            }
            if (string.equals("cmwap") || string.equals("3gwap") || string.equals("uniwap")) {
                return new HttpHost("10.0.0.172", 80);
            }
            if (string.equals("ctwap")) {
                return new HttpHost("10.0.0.200", 80);
            }
            String string2 = Proxy.getDefaultHost();
            if (string2 != null && string2.trim().length() > 0) {
                int n2 = Proxy.getDefaultPort();
                return new HttpHost(string2, n2);
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return null;
    }

    public static synchronized String getUserID(Context context) {
        if (null != a && a.trim().length() != 0) {
            return a;
        }
        a = Util.getDeviceID(context);
        if (null == a || a.trim().length() == 0) {
            for (int i2 = 0; i2 < 100; ++i2) {
                long l2 = StatCommonHelper.b().nextLong();
                String string = Long.toHexString(l2).toUpperCase();
                if (string.length() != 16 || string.startsWith("0")) continue;
                a = string;
                break;
            }
        }
        return a;
    }

    public static synchronized String getMacId(Context context) {
        if (null == c || c.trim().length() == 0) {
            c = Util.getWifiMacAddress(context);
        }
        return c;
    }

    public static Location getGPSLocation(Context context) {
        Location location = null;
        try {
            LocationManager locationManager;
            if (Util.checkPermission(context, "android.permission.ACCESS_FINE_LOCATION") && (locationManager = (LocationManager)context.getSystemService("location")).isProviderEnabled("gps")) {
                location = locationManager.getLastKnownLocation("gps");
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return location;
    }

    public static Location getNetworkLocation(Context context) {
        Location location = null;
        try {
            LocationManager locationManager;
            if ((Util.checkPermission(context, "android.permission.ACCESS_COARSE_LOCATION") || Util.checkPermission(context, "android.permission.ACCESS_FINE_LOCATION")) && (locationManager = (LocationManager)context.getSystemService("location")).isProviderEnabled("network")) {
                location = locationManager.getLastKnownLocation("network");
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return location;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        if (f == null) {
            f = new DisplayMetrics();
            ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(f);
        }
        return f;
    }

    public static StatReportStrategy getStatSendStrategy(Context context) {
        return StatConfig.getStatSendStrategy();
    }

    public static boolean isWiFiActive(Context context) {
        try {
            if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                NetworkInfo[] networkInfoArray;
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager != null && (networkInfoArray = connectivityManager.getAllNetworkInfo()) != null) {
                    for (int i2 = 0; i2 < networkInfoArray.length; ++i2) {
                        if (!networkInfoArray[i2].getTypeName().equalsIgnoreCase("WIFI") || !networkInfoArray[i2].isConnected()) continue;
                        return true;
                    }
                }
                return false;
            }
            m.warn("can not get the permission of android.permission.ACCESS_WIFI_STATE");
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return false;
    }

    public static String getProperty(Context context, String string) {
        try {
            String string2;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && (string2 = applicationInfo.metaData.getString(string)) != null) {
                return string2;
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return "";
    }

    public static String getAppKey(Context context) {
        if (null != b) {
            return b;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null) {
                String string = applicationInfo.metaData.getString("TA_APPKEY");
                if (string != null) {
                    b = string;
                    return string;
                }
                m.i("Could not read APPKEY meta-data from AndroidManifest.xml");
            }
        }
        catch (Throwable throwable) {
            m.i("Could not read APPKEY meta-data from AndroidManifest.xml");
        }
        return null;
    }

    public static String getDeviceModel(Context context) {
        if (null == d) {
            d = Build.MODEL;
        }
        return d;
    }

    public static String getInstallChannel(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null) {
                Object object = applicationInfo.metaData.get("InstallChannel");
                if (object != null) {
                    return object.toString();
                }
                m.w("Could not read InstallChannel meta-data from AndroidManifest.xml");
            }
        }
        catch (Throwable throwable) {
            m.w("Could not read InstallChannel meta-data from AndroidManifest.xml");
        }
        return null;
    }

    public static String getActivityName(Context context) {
        if (null == context) {
            return null;
        }
        return context.getClass().getName();
    }

    public static String getPackageName(Context context) {
        if (Util.checkPermission(context, "android.permission.GET_TASKS")) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            ComponentName componentName = ((ActivityManager.RunningTaskInfo)activityManager.getRunningTasks((int)1).get((int)0)).topActivity;
            return componentName.getPackageName();
        }
        m.e("Could not get permission of android.permission.GET_TASKS");
        return null;
    }

    public static String getSimOperator(Context context) {
        if (g != null) {
            return g;
        }
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager;
                if (StatCommonHelper.checkPhoneState(context) && (telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null) {
                    g = telephonyManager.getSimOperator();
                }
            } else {
                m.e("Could not get permission of android.permission.READ_PHONE_STATE");
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return g;
    }

    public static String getDeviceIMSI(Context context) {
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                String string = null;
                if (StatCommonHelper.checkPhoneState(context)) {
                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                    string = telephonyManager.getSubscriberId();
                }
                if (string != null) {
                    return string;
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return "";
    }

    public static String getCurAppVersion(Context context) {
        if (StatCommonHelper.isStringValid(h)) {
            return h;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            h = packageInfo.versionName;
            if (h == null) {
                return "";
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return h;
    }

    public static String getCurAppMd5Signature(Context context) {
        if (StatCommonHelper.isStringValid(i)) {
            return i;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 64);
            if (packageInfo == null) {
                m.e("packageInfo is null ");
                return "";
            }
            Signature[] signatureArray = packageInfo.signatures;
            if (signatureArray == null || signatureArray.length == 0) {
                m.e("signatures is null");
                return "";
            }
            i = StatCommonHelper.md5sum(signatureArray[0].toCharsString());
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return i;
    }

    public static String getCurAppSHA1Signature(Context context) {
        if (StatCommonHelper.isStringValid(j)) {
            return j;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            if (packageInfo == null) {
                m.e("packageInfo is null ");
                return "";
            }
            Signature[] signatureArray = packageInfo.signatures;
            if (signatureArray == null || signatureArray.length == 0) {
                m.e("signatures is null");
                return "";
            }
            byte[] byArray = signatureArray[0].toByteArray();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = byArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = Integer.toHexString(0xFF & byArray2[i2]).toUpperCase(Locale.US);
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
                if (i2 == n2 - 1) continue;
                stringBuffer.append(":");
            }
            j = stringBuffer.toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return j;
    }

    public static boolean checkPhoneState(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission("android.permission.READ_PHONE_STATE", context.getPackageName()) == 0;
    }

    public static String getLinkedWay(Context context) {
        String string = "";
        try {
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected()) {
                    String string2 = networkInfo.getTypeName();
                    String string3 = networkInfo.getExtraInfo();
                    if (string2 != null) {
                        string = string2.equalsIgnoreCase("WIFI") ? "WIFI" : (string2.equalsIgnoreCase("MOBILE") ? (string3 != null && string3.trim().length() > 0 ? string3 : "MOBILE") : (string3 != null && string3.trim().length() > 0 ? string3 : string2));
                    }
                }
            } else {
                m.e("can not get the permission of android.permission.ACCESS_WIFI_STATE");
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return string;
    }

    public static Integer getTelephonyNetworkType(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                return telephonyManager.getNetworkType();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean haveGravity(Context context) {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        return sensorManager != null;
    }

    public static String getAppVersion(Context context) {
        if (StatCommonHelper.isStringValid(k)) {
            return k;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            k = packageInfo.versionName;
            if (k == null || k.length() == 0) {
                return "unknown";
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return k;
    }

    public static int hasRootAccess(Context context) {
        if (l != -1) {
            return l;
        }
        l = 0;
        try {
            if (com.tencent.stat.common.StatCommonHelper$b.a()) {
                l = 1;
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return l;
    }

    public static synchronized StatLogger getLogger() {
        if (m == null) {
            m = new StatLogger("MtaSDK");
            m.setDebugEnable(false);
        }
        return m;
    }

    public static long getTomorrowStartMilliseconds() {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return 86400000L + calendar.getTimeInMillis();
        }
        catch (Throwable throwable) {
            m.e(throwable);
            return 86400000L + System.currentTimeMillis();
        }
    }

    public static String getDateString(int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.roll(6, n2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string = simpleDateFormat.format(calendar.getTime());
        return string;
    }

    public static Long convertStringToLong(String string, String string2, int n2, int n3, Long l2) {
        String[] stringArray;
        if (string == null || string2 == null) {
            return l2;
        }
        if (string2.equalsIgnoreCase(".") || string2.equalsIgnoreCase("|")) {
            string2 = "\\" + string2;
        }
        if ((stringArray = string.split(string2)).length == n3) {
            try {
                Long l3 = 0L;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    l3 = (long)n2 * (l3 + Long.valueOf(stringArray[i2]));
                }
                return l3;
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }
        return l2;
    }

    public static long getSDKLongVersion(String string) {
        return StatCommonHelper.convertStringToLong(string, ".", 100, 3, 0L);
    }

    public static boolean isStringValid(String string) {
        return string != null && string.trim().length() != 0;
    }

    public static String getExternalStorageInfo(Context context) {
        block5: {
            if (StatCommonHelper.isStringValid(n)) {
                return n;
            }
            try {
                if (Util.checkPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    String string;
                    String string2 = Environment.getExternalStorageState();
                    if (string2 != null && string2.equals("mounted") && (string = Environment.getExternalStorageDirectory().getPath()) != null) {
                        StatFs statFs = new StatFs(string);
                        long l2 = (long)statFs.getBlockCount() * (long)statFs.getBlockSize() / 1000000L;
                        long l3 = (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize() / 1000000L;
                        n = String.valueOf(l3) + "/" + String.valueOf(l2);
                        return n;
                    }
                    break block5;
                }
                m.warn("can not get the permission of android.permission.WRITE_EXTERNAL_STORAGE");
                return null;
            }
            catch (Throwable throwable) {
                m.e(throwable);
            }
        }
        return null;
    }

    public static String getDateFormat(long l2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return simpleDateFormat.format(new Date(l2));
    }

    public static String getTimeFormat(long l2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmSS");
        return simpleDateFormat.format(new Date(l2));
    }

    public static int getAndroidOsBuildVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static int checkBluetooth() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return -1;
        }
        if (bluetoothAdapter.isEnabled()) {
            return 1;
        }
        return 0;
    }

    public static boolean isMainProcess(Context context) {
        return context.getPackageName().equals(StatCommonHelper.getCurProcessName(context));
    }

    public static String getCurProcessName(Context context) {
        try {
            if (o != null) {
                return o;
            }
            int n2 = Process.myPid();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : activityManager.getRunningAppProcesses()) {
                if (runningAppProcessInfo.pid != n2) continue;
                o = runningAppProcessInfo.processName;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return o;
    }

    public static String getTagForConcurrentProcess(Context context, String string) {
        if (StatConfig.isEnableConcurrentProcess()) {
            if (o == null) {
                o = StatCommonHelper.getCurProcessName(context);
            }
            if (o != null) {
                return string + "_" + o;
            }
        }
        return string;
    }

    public static void destroyProcess(java.lang.Process process) {
        try {
            if (process != null) {
                process.exitValue();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getDatabaseName(Context context) {
        return StatCommonHelper.getTagForConcurrentProcess(context, StatConstants.DATABASE_NAME);
    }

    public static synchronized Integer getNextEventIndexNo(Context context) {
        if (p > 0) {
            if (p % 1000 == 0) {
                try {
                    int n2 = p + 1000;
                    if (p >= 2147383647) {
                        n2 = 0;
                    }
                    StatPreferences.putInt(context, "MTA_EVENT_INDEX", n2);
                }
                catch (Throwable throwable) {
                    m.w(throwable);
                }
            }
        } else {
            p = StatPreferences.getInt(context, "MTA_EVENT_INDEX", 0);
            StatPreferences.putInt(context, "MTA_EVENT_INDEX", p + 1000);
        }
        return ++p;
    }

    public static String getCpuString() {
        if (StatCommonHelper.isStringValid(q)) {
            return q;
        }
        if (Build.CPU_ABI.equalsIgnoreCase("x86")) {
            q = "Intel";
        } else {
            try {
                byte[] byArray = new byte[1024];
                RandomAccessFile randomAccessFile = new RandomAccessFile("/proc/cpuinfo", "r");
                randomAccessFile.read(byArray);
                randomAccessFile.close();
                String string = new String(byArray);
                int n2 = string.indexOf(0);
                q = n2 != -1 ? string.substring(0, n2) : string;
            }
            catch (Throwable throwable) {
                m.e(throwable);
            }
        }
        return q;
    }

    public static String getCpuType() {
        String string = StatCommonHelper.getCpuString();
        String string2 = null;
        if (string.contains("ARMv5")) {
            string2 = "armv5";
        } else if (string.contains("ARMv6")) {
            string2 = "armv6";
        } else if (string.contains("ARMv7")) {
            string2 = "armv7";
        } else if (string.contains("Intel")) {
            string2 = "x86";
        } else {
            string2 = "unknown";
            return string2;
        }
        string2 = string.contains("neon") ? string2 + "_neon" : (string.contains("vfpv3") ? string2 + "_vfpv3" : (string.contains(" vfp") ? string2 + "_vfp" : string2 + "_none"));
        return string2;
    }

    public static String getRomMemory() {
        if (StatCommonHelper.isStringValid(r)) {
            return r;
        }
        long l2 = StatCommonHelper.getTotalInternalMemorySize() / 1000000L;
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l3 = statFs.getBlockSize();
        long l4 = statFs.getAvailableBlocks();
        long l5 = l3 * l4 / 1000000L;
        r = String.valueOf(l5) + "/" + String.valueOf(l2);
        return r;
    }

    public static long getTotalInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l3 * l2;
    }

    public static String getSystemMemory(Context context) {
        try {
            long l2 = StatCommonHelper.a(context) / 1000000L;
            long l3 = StatCommonHelper.c() / 1000000L;
            return String.valueOf(l2) + "/" + String.valueOf(l3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static long a(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long c() {
        if (s > 0L) {
            return s;
        }
        String string = "/proc/meminfo";
        long l2 = 1L;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader, 8192);
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                String[] stringArray = string2.split("\\s+");
                l2 = (long)Integer.valueOf(stringArray[1]).intValue() * 1024L;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        s = l2;
        return s;
    }

    public static JSONObject getCpuInfo(Context context) {
        JSONObject jSONObject = new JSONObject();
        try {
            int n2;
            jSONObject.put("n", com.tencent.stat.common.StatCommonHelper$a.a());
            String string = com.tencent.stat.common.StatCommonHelper$a.d();
            if (string != null && string.length() > 0) {
                jSONObject.put("na", (Object)string);
            }
            if ((n2 = com.tencent.stat.common.StatCommonHelper$a.b()) > 0) {
                jSONObject.put("fx", n2 / 1000000);
            }
            if ((n2 = com.tencent.stat.common.StatCommonHelper$a.c()) > 0) {
                jSONObject.put("fn", n2 / 1000000);
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"MtaSDK", (String)"get cpu error", (Throwable)throwable);
        }
        return jSONObject;
    }

    public static String getAllSensors(Context context) {
        if (StatCommonHelper.isStringValid(t)) {
            return t;
        }
        try {
            List list;
            SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
            if (sensorManager != null && (list = sensorManager.getSensorList(-1)) != null) {
                StringBuilder stringBuilder = new StringBuilder(list.size() * 10);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    stringBuilder.append(((Sensor)list.get(i2)).getType());
                    if (i2 == list.size() - 1) continue;
                    stringBuilder.append(",");
                }
                t = stringBuilder.toString();
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return t;
    }

    public static synchronized int isTheFirstTimeActivate(Context context) {
        if (v != -1) {
            return v;
        }
        StatCommonHelper.checkFirstTimeActivate(context);
        return v;
    }

    public static void checkFirstTimeActivate(Context context) {
        v = StatPreferences.getInt(context, u, 1);
        if (v == 1) {
            StatPreferences.putInt(context, u, 0);
        }
    }

    public static boolean isSpecifyReportedValid(StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (statSpecifyReportedInfo == null) {
            return false;
        }
        return StatCommonHelper.isStringValid(statSpecifyReportedInfo.getAppKey());
    }

    public static boolean needCheckTime(Context context) {
        long l2;
        if (w < 0L) {
            w = StatPreferences.getLong(context, "mta.qq.com.checktime", 0L);
        }
        return (l2 = Math.abs(System.currentTimeMillis() - w)) > 86400000L;
    }

    public static void updateCheckTime(Context context) {
        w = System.currentTimeMillis();
        StatPreferences.putLong(context, "mta.qq.com.checktime", w);
    }

    public static int getDiffTime(Context context, boolean bl) {
        if (bl) {
            x = StatCommonHelper.readDiffTimeFromServer(context);
        }
        return x;
    }

    public static int readDiffTimeFromServer(Context context) {
        return StatPreferences.getInt(context, "mta.qq.com.difftime", 0);
    }

    public static void writeDiffTimeFromServer(Context context, int n2) {
        x = n2;
        StatPreferences.putInt(context, "mta.qq.com.difftime", n2);
    }

    public static boolean isBackgroundRunning(Context context) {
        if (context == null) {
            return false;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        String string = context.getPackageName();
        List list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (!runningAppProcessInfo.processName.startsWith(string)) continue;
            return runningAppProcessInfo.importance == 400;
        }
        return false;
    }

    public static Map<String, Integer> getRunningApp(Context context) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                hashMap.put(runningAppProcessInfo.processName, 1);
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return hashMap;
    }

    public static Map<String, Integer> getRecentTasks(Context context) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRecentTasks(64, 1);
            for (ActivityManager.RecentTaskInfo recentTaskInfo : list) {
                Intent intent = recentTaskInfo.baseIntent;
                ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
                if (resolveInfo == null) continue;
                hashMap.put(resolveInfo.resolvePackageName, 1);
            }
        }
        catch (Throwable throwable) {
            m.e(throwable);
        }
        return hashMap;
    }

    public static JSONArray formatThrowable(Throwable throwable) {
        JSONArray jSONArray = new JSONArray();
        if (throwable != null) {
            jSONArray.put((Object)throwable.toString());
            StatCommonHelper.formatStackTraceElement(jSONArray, throwable.getStackTrace());
        }
        return jSONArray;
    }

    public static JSONArray formatStackTraceElement(JSONArray jSONArray, StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                jSONArray.put((Object)stackTraceElement.toString());
            }
        }
        return jSONArray;
    }

    public static int getRunningCounter(Context context) {
        try {
            String string = StatCommonHelper.getCurAppVersion(context) + ".run.cnt";
            int n2 = StatPreferences.getInt(context, string, 1);
            StatPreferences.putInt(context, string, n2 + 1);
            return n2;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public static void encodeAppPackageInfo(JSONObject jSONObject, PackageInfo packageInfo) {
        try {
            String string = packageInfo.packageName;
            jSONObject.put("pn", (Object)string);
            jSONObject.put("av", (Object)packageInfo.versionName);
            jSONObject.put("vc", packageInfo.versionCode);
            jSONObject.put("fit", packageInfo.firstInstallTime / 1000L);
            jSONObject.put("lut", packageInfo.lastUpdateTime / 1000L);
            jSONObject.put("fg", packageInfo.applicationInfo.flags);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static JSONArray getAppList(Context context) {
        JSONArray jSONArray = new JSONArray();
        try {
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.getInstalledPackages(0);
            Map<String, Integer> map = StatCommonHelper.getRunningApp(context);
            Map<String, Integer> map2 = StatCommonHelper.getRecentTasks(context);
            for (PackageInfo packageInfo : list) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    String string = packageInfo.packageName;
                    StatCommonHelper.encodeAppPackageInfo(jSONObject, packageInfo);
                    if (map.containsKey(string)) {
                        jSONObject.put("rn", 1);
                    }
                    if (map2.containsKey(string)) {
                        jSONObject.put("rt", 1);
                    }
                    jSONArray.put((Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    m.e(jSONException);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return jSONArray;
    }

    public static String getLauncherPackageName(Context context) {
        if (context == null) {
            return null;
        }
        try {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
            if (resolveInfo.activityInfo == null) {
                return null;
            }
            if (resolveInfo.activityInfo.packageName.equals("android")) {
                return null;
            }
            return resolveInfo.activityInfo.packageName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (!runningAppProcessInfo.processName.equalsIgnoreCase(context.getPackageName())) continue;
            m.i("isBackground processName:" + runningAppProcessInfo.processName + ", importance:" + runningAppProcessInfo.importance);
            if (runningAppProcessInfo.importance != 100 && runningAppProcessInfo.importance != 200 || StatCommonHelper.isLockScreenOn(context)) break;
            return StatCommonHelper.isApplicationBroughtToBackground(context);
        }
        return true;
    }

    public static boolean isLockScreenOn(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    public static boolean isApplicationBroughtToBackground(Context context) {
        if (!Util.checkPermission(context, "android.permission.GET_TASKS")) {
            return true;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningTasks(1);
        if (!list.isEmpty()) {
            ComponentName componentName = ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity;
            m.i("isApplicationBroughtToBackground top package:" + componentName.getPackageName());
            if (!componentName.getPackageName().equals(context.getPackageName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean needReportApp(Context context) {
        if (!StatConfig.isAutoTrackAppsEvent()) {
            return false;
        }
        if (y == -1L) {
            long l2 = 86400L;
            String string = StatConfig.getSDKProperty("autoAL", String.valueOf(l2));
            z = Long.valueOf(string) * 1000L;
            y = z > 10800000L ? StatPreferences.getLong(context, NEXT_REPORT, 0L) : Long.MAX_VALUE;
            m.d("next_al_report_time:" + y);
        }
        return y < System.currentTimeMillis();
    }

    public static void updateNextReportTime(Context context) {
        y = System.currentTimeMillis() + z;
        StatPreferences.putLong(context, NEXT_REPORT, y);
    }

    public static String getNewMid(Context context) {
        Class<MidService> clazz = MidService.class;
        try {
            Method method = clazz.getMethod("getNewMid", Context.class);
            return (String)method.invoke(null, context);
        }
        catch (Throwable throwable) {
            m.w("MidService.getNewMid method notfound");
            return null;
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                closeable = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static int getArgumentsLength(Object ... objectArray) {
        int n2 = 0;
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object == null) continue;
                n2 += object.toString().length();
            }
        }
        return n2;
    }

    public static boolean checkArgumentsLength(Object ... objectArray) {
        return StatCommonHelper.getArgumentsLength(objectArray) > 61440;
    }

    public static String getUserAgent(Context context) {
        String string = "";
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                string = WebSettings.getDefaultUserAgent((Context)context);
            }
            catch (Exception exception) {
                string = System.getProperty("http.agent");
            }
        } else {
            string = System.getProperty("http.agent");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u001f' || c2 >= '\u007f') {
                stringBuffer.append(String.format("\\u%04x", c2));
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static JSONObject getBatteryInfo(Context context) {
        if (context == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            if (A == null) {
                A = Util.getContextSelf(context).registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            }
            int n2 = A.getIntExtra("status", 0);
            int n3 = A.getIntExtra("health", 1);
            boolean bl = A.getBooleanExtra("present", false);
            int n4 = A.getIntExtra("level", 0);
            int n5 = A.getIntExtra("scale", 0);
            int n6 = A.getIntExtra("plugged", 0);
            int n7 = A.getIntExtra("voltage", 0);
            int n8 = A.getIntExtra("temperature", 0);
            String string = A.getStringExtra("technology");
            jSONObject.put("status", n2);
            jSONObject.put("health", n3);
            jSONObject.put("present", bl);
            jSONObject.put("level", n4);
            jSONObject.put("scale", n5);
            jSONObject.put("plugged", n6);
            jSONObject.put("voltage", n7);
            jSONObject.put("temperature", n8);
            jSONObject.put("technology", (Object)string);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public static void saveMultiAccounts(Context context) {
    }

    public static void loadMultiAccounts(Context context) {
    }

    static class com.tencent.stat.common.StatCommonHelper$a {
        static int a() {
            try {
                File file = new File("/sys/devices/system/cpu/");
                class A
                implements FileFilter {
                    A() {
                    }

                    @Override
                    public boolean accept(File file) {
                        return Pattern.matches("cpu[0-9]", file.getName());
                    }
                }
                File[] fileArray = file.listFiles(new A());
                return fileArray.length;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 1;
            }
        }

        static int b() {
            int n2 = 0;
            try {
                String string = "";
                String[] stringArray = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"};
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                java.lang.Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[24];
                while (inputStream.read(byArray) != -1) {
                    string = string + new String(byArray);
                }
                inputStream.close();
                string = string.trim();
                if (string.length() > 0) {
                    n2 = Integer.valueOf(string);
                }
            }
            catch (Exception exception) {
                m.e(exception);
            }
            return n2 * 1000;
        }

        static int c() {
            int n2 = 0;
            try {
                String string = "";
                String[] stringArray = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq"};
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                java.lang.Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[24];
                while (inputStream.read(byArray) != -1) {
                    string = string + new String(byArray);
                }
                inputStream.close();
                string = string.trim();
                if (string.length() > 0) {
                    n2 = Integer.valueOf(string);
                }
            }
            catch (Throwable throwable) {
                m.e(throwable);
            }
            return n2 * 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String d() {
            String string = "/proc/cpuinfo";
            String string2 = "";
            String[] stringArray = new String[]{"", ""};
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader, 8192);
                string2 = bufferedReader.readLine();
                if (string2 != null) {
                    String[] stringArray2 = string2.split("\\s+");
                    for (int i2 = 2; i2 < stringArray2.length; ++i2) {
                        stringArray[0] = stringArray[0] + stringArray2[i2] + " ";
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return stringArray[0];
        }
    }

    static class b {
        private static int a = -1;

        public static boolean a() {
            if (a == 1) {
                return true;
            }
            if (a == 0) {
                return false;
            }
            File file = null;
            String[] stringArray = new String[]{"/bin", "/system/bin/", "/system/xbin/", "/system/sbin/", "/sbin/", "/vendor/bin/"};
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    file = new File(stringArray[i2] + "su");
                    if (file == null || !file.exists()) continue;
                    a = 1;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            a = 0;
            return false;
        }
    }
}

