/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.tencent.mid.api.MidService;
import com.tencent.stat.MtaSDkException;
import com.tencent.stat.NetworkManager;
import com.tencent.stat.NetworkMonitor;
import com.tencent.stat.StatAccount;
import com.tencent.stat.StatActionListener;
import com.tencent.stat.StatAppMonitor;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatCrashReporter;
import com.tencent.stat.StatDispatchCallback;
import com.tencent.stat.StatFBDispatchCallback;
import com.tencent.stat.StatGameUser;
import com.tencent.stat.StatMultiAccount;
import com.tencent.stat.StatNativeCrashReport;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatSpecifyReportedInfo;
import com.tencent.stat.app.api.AppInstallSourceMrg;
import com.tencent.stat.common.DeviceInfo;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.StatPreferences;
import com.tencent.stat.common.Util;
import com.tencent.stat.d;
import com.tencent.stat.e;
import com.tencent.stat.event.Event;
import com.tencent.stat.event.EventType;
import com.tencent.stat.event.c;
import com.tencent.stat.event.f;
import com.tencent.stat.event.g;
import com.tencent.stat.event.h;
import com.tencent.stat.event.i;
import com.tencent.stat.event.j;
import com.tencent.stat.event.k;
import com.tencent.stat.event.l;
import com.tencent.stat.event.m;
import com.tencent.stat.event.n;
import com.tencent.stat.lifecycle.MtaActivityLifeCycle;
import com.tencent.stat.lifecycle.MtaActivityLifecycleCallback;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatServiceImpl {
    private static Handler e;
    private static volatile Map<c.a, Long> f;
    private static volatile Map<String, Properties> g;
    private static volatile Map<Integer, Integer> h;
    private static volatile long i;
    private static volatile long j;
    private static volatile long k;
    private static String l;
    private static volatile int m;
    private static volatile String n;
    private static volatile String o;
    private static Map<String, Long> p;
    static List<String> a;
    private static Map<String, Long> q;
    private static StatLogger r;
    private static volatile boolean s;
    static volatile int b;
    static volatile long c;
    private static Context t;
    static volatile long d;
    private static long u;
    private static long v;
    private static volatile boolean w;
    private static volatile boolean x;
    private static volatile boolean y;
    private static Handler z;
    private static List<StatActionListener> A;
    private static volatile Runnable B;
    private static volatile long C;
    private static StatSpecifyReportedInfo D;
    private static Map<StatMultiAccount.AccountType, StatMultiAccount> E;

    public static long getAppStartupTime() {
        return u;
    }

    public static void initAppContext(Application application) {
        if (application != null) {
            t = application;
        }
    }

    public static long getFrontgroundStartupTime() {
        return v;
    }

    static boolean a() {
        if (b >= 2) {
            c = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static Context getContext(Context context) {
        if (context != null) {
            if (context.getApplicationContext() != null) {
                return context.getApplicationContext();
            }
            return context;
        }
        return t;
    }

    public static void setContext(Context context) {
        if (context != null) {
            t = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        }
    }

    public static void testJavaCrash(Context context) {
        com.tencent.stat.e.a(context).c();
    }

    static synchronized void a(Context context) {
        if (context == null) {
            return;
        }
        if (null == e) {
            if (!StatServiceImpl.b(context)) {
                return;
            }
            u = System.currentTimeMillis();
            StatServiceImpl.setContext(context);
            final Context context2 = StatServiceImpl.getContext(context);
            HandlerThread handlerThread = new HandlerThread("StatService");
            handlerThread.start();
            e = new Handler(handlerThread.getLooper());
            l = StatCommonHelper.getDateString(0);
            j = System.currentTimeMillis() + StatConfig.i;
            StatServiceImpl.u();
            com.tencent.stat.a.a(context2).a();
            e.post(new Runnable(){

                @Override
                public void run() {
                    NetworkManager.getInstance(context2).registerBroadcast();
                    if (com.tencent.mid.util.Util.isMidValid((String)MidService.getLocalMidOnly((Context)context2))) {
                        MidService.getMid((Context)context2);
                    }
                    StatCommonHelper.getDiffTime(context2, true);
                    com.tencent.stat.e.a(context2);
                    com.tencent.stat.d.b(context2);
                    if (StatConfig.getStatSendStrategy() == StatReportStrategy.APP_LAUNCH) {
                        StatServiceImpl.commitEvents(context2, -1);
                    }
                    StatServiceImpl.i(context2);
                    StatServiceImpl.c(context2);
                    com.tencent.stat.common.j.a(context2);
                    if (StatConfig.isDebugEnable()) {
                        r.d("Init MTA StatService success with sdk version3.4.7");
                    }
                }
            });
        }
    }

    private static void t() {
        try {
            DeviceInfo deviceInfo = com.tencent.stat.e.a(t).b(t);
            if (deviceInfo != null && deviceInfo.getUserType() == 0) {
                AppInstallSourceMrg.getInstance(t).reportInstallEvent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String fetchPageFlows() {
        if (a == null || a.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : a) {
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }

    static void a(Thread thread, Throwable throwable) {
        com.tencent.stat.event.e e2 = new com.tencent.stat.event.e(t, StatServiceImpl.getSessionID(t, false, null), 2, throwable, thread, null);
        if (e2.toJsonString().length() <= 0x100000) {
            StatServiceImpl.a(e2);
            StatCrashReporter.getStatCrashReporter(t).a(thread, throwable);
        } else {
            r.e("Java Crash event exceeds the limit:1048576, droped.");
        }
    }

    static void a(JSONArray jSONArray, Thread thread, String string) {
        com.tencent.stat.event.e e2 = new com.tencent.stat.event.e(t, StatServiceImpl.getSessionID(t, false, null), 3, jSONArray, thread, null);
        e2.b(string);
        final String string2 = StatCommonHelper.getTimeFormat(System.currentTimeMillis()) + ".native" + ".v1.crash";
        com.tencent.stat.common.b.a(t, "mtajcrash", string2, e2.toJsonString());
        if ((StatConfig.isDebugEnable() || StatCrashReporter.getStatCrashReporter(t).isEnableInstantReporting()) && NetworkManager.getInstance(t).isNetworkAvailable()) {
            com.tencent.stat.d.b(t).a(e2, new StatDispatchCallback(){

                @Override
                public void onDispatchSuccess() {
                    com.tencent.stat.common.b.a(t, "mtajcrash", string2);
                    r.debug("native crash has been reported.");
                }

                @Override
                public void onDispatchFailure() {
                }
            });
        }
        StatCrashReporter.getStatCrashReporter(t).a(e2.a());
        File file = new File(string);
        file.delete();
    }

    static void a(com.tencent.stat.event.e e2) {
        final String string = StatCommonHelper.getTimeFormat(System.currentTimeMillis()) + ".v1.crash";
        com.tencent.stat.common.b.a(t, "mtajcrash", string, e2.toJsonString());
        if ((StatConfig.isDebugEnable() || StatCrashReporter.getStatCrashReporter(t).isEnableInstantReporting()) && NetworkManager.getInstance(t).isNetworkAvailable()) {
            com.tencent.stat.d.b(t).a(e2, new StatDispatchCallback(){

                @Override
                public void onDispatchSuccess() {
                    com.tencent.stat.common.b.a(t, "mtajcrash", string);
                    r.debug("java crash has been reported.");
                }

                @Override
                public void onDispatchFailure() {
                }
            });
        }
    }

    static void b(Thread thread, Throwable throwable) {
        if (!StatConfig.isEnableStatService() || t == null) {
            return;
        }
        try {
            StatServiceImpl.a(t, null, true);
            if (StatConfig.isAutoExceptionCaught()) {
                StatServiceImpl.a(thread, throwable);
                String string = "MtaSDK.CaughtExp";
                Log.e((String)string, (String)"MTA has caught the following uncaught exception:");
                Log.e((String)string, (String)"", (Throwable)throwable);
                Log.e((String)string, (String)"App uncaught exception end.");
            } else {
                r.warn("crash happened, but MTA Auto Exception Caught Report is desable.");
            }
            StatServiceImpl.flushDataToDB(t);
            if (StatConfig.f() != null) {
                StatConfig.f().onMtaException(throwable);
            }
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
        }
    }

    static boolean b(Context context) {
        long l2;
        long l3 = StatPreferences.getLong(context, StatConfig.c, 0L);
        long l4 = StatCommonHelper.getSDKLongVersion("3.4.7");
        boolean bl = true;
        if (l4 <= l3) {
            r.error("MTA is disable for current version:" + l4 + ",wakeup version:" + l3);
            bl = false;
        }
        if ((l2 = StatPreferences.getLong(context, StatConfig.d, 0L)) > System.currentTimeMillis()) {
            r.error("MTA is disable for current time:" + System.currentTimeMillis() + ",wakeup time:" + l2);
            bl = false;
        }
        StatConfig.setEnableStatService(bl);
        return bl;
    }

    static boolean a(String string) {
        return string == null || string.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Handler getHandler(Context context) {
        if (null != e) return e;
        Class<StatServiceImpl> clazz = StatServiceImpl.class;
        synchronized (StatServiceImpl.class) {
            if (null != e) return e;
            try {
                Context context2 = context != null ? context : t;
                StatServiceImpl.a(context2);
            }
            catch (Throwable throwable) {
                r.error(throwable);
                StatConfig.setEnableStatService(false);
            }
            return e;
        }
    }

    static JSONObject b() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONObject jSONObject2 = new JSONObject();
            if (StatConfig.b.d != 0) {
                jSONObject2.put("v", StatConfig.b.d);
            }
            jSONObject.put(Integer.toString(StatConfig.b.a), (Object)jSONObject2);
            jSONObject2 = new JSONObject();
            if (StatConfig.a.d != 0) {
                jSONObject2.put("v", StatConfig.a.d);
            }
            jSONObject.put(Integer.toString(StatConfig.a.a), (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            r.e(jSONException);
        }
        return jSONObject;
    }

    static void a(Context context, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (StatServiceImpl.getHandler(context) != null) {
            if (StatConfig.isDebugEnable()) {
                r.d("start new session.");
            }
            if (statSpecifyReportedInfo == null || m == 0) {
                m = StatCommonHelper.getNextSessionID();
            }
            StatConfig.a(0);
            StatConfig.d();
            n n2 = new n(context, m, StatServiceImpl.b(), statSpecifyReportedInfo);
            String string = n2.getReportedAppkey();
            if (StatCommonHelper.isStringValid(string) && StatConfig.shouldSkipSessionReport(string)) {
                r.w("appkey :" + string + " skip session report.");
                return;
            }
            new c(n2).a();
            StatServiceImpl.t();
        }
    }

    public static int getSessionID(Context context, boolean bl, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        long l2 = System.currentTimeMillis();
        boolean bl2 = false;
        if (bl && l2 - i >= (long)StatConfig.getSessionTimoutMillis()) {
            bl2 = true;
        }
        i = l2;
        if (k == 0L) {
            k = StatCommonHelper.getTomorrowStartMilliseconds();
        }
        if (l2 >= k) {
            k = StatCommonHelper.getTomorrowStartMilliseconds();
            if (com.tencent.stat.e.a(context).b(context).getUserType() != 1) {
                com.tencent.stat.e.a(context).b(context).setUserType(1);
            }
            StatConfig.b(0);
            bl2 = true;
            b = 0;
            l = StatCommonHelper.getDateString(0);
        }
        String string = l;
        if (StatCommonHelper.isSpecifyReportedValid(statSpecifyReportedInfo)) {
            string = statSpecifyReportedInfo.getAppKey() + l;
        }
        boolean bl3 = false;
        if (!q.containsKey(string)) {
            bl2 = true;
            bl3 = true;
        }
        if (bl2) {
            if (!StatCommonHelper.isSpecifyReportedValid(statSpecifyReportedInfo)) {
                if (StatConfig.e() < StatConfig.getMaxDaySessionNumbers()) {
                    StatCommonHelper.checkFirstTimeActivate(context);
                    StatServiceImpl.a(context, null);
                } else {
                    r.e("Exceed StatConfig.getMaxDaySessionNumbers().");
                }
            } else {
                StatServiceImpl.a(context, statSpecifyReportedInfo);
            }
        }
        if (s || bl3) {
            q.put(string, 1L);
            StatServiceImpl.b(context, statSpecifyReportedInfo);
        }
        if (!s || !StatCommonHelper.isSpecifyReportedValid(statSpecifyReportedInfo)) {
            // empty if block
        }
        s = false;
        return m;
    }

    private static void b(Context context, final String string, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        final String string2 = new String(string);
        final Context context2 = context.getApplicationContext();
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Map map = p;
                        synchronized (map) {
                            r.d("inerTrackBeginPage:" + string);
                            a.add(string2);
                            if (a.size() > 40) {
                                a = a.subList(a.size() - 20, a.size());
                            }
                            if (p.size() >= StatConfig.getMaxParallelTimmingEvents()) {
                                r.error("The number of page events exceeds the maximum value " + Integer.toString(StatConfig.getMaxParallelTimmingEvents()));
                                return;
                            }
                            n = string2;
                            if (p.containsKey(n)) {
                                r.warn("Duplicate PageID : " + n + ", onResume() repeated?");
                            }
                            p.put(n, System.currentTimeMillis());
                        }
                        StatServiceImpl.getSessionID(context2, true, statSpecifyReportedInfo);
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void trackBeginPage(Context context, String string, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null || string == null || string.length() == 0) {
            r.error("The Context or pageName of StatService.trackBeginPage() can not be null or empty!");
            return;
        }
        StatServiceImpl.b(context2, string, statSpecifyReportedInfo);
    }

    private static void b(Context context, final String string, final int n2, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        final String string2 = new String(string);
        final Context context2 = Util.getContextSelf(context);
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        k k2;
                        StatServiceImpl.flushDataToDB(context2);
                        Long l2 = null;
                        Map map = p;
                        synchronized (map) {
                            l2 = (Long)p.remove(string2);
                        }
                        r.d("inerTrackEndPage:" + string + ",startTime:" + l2);
                        if (l2 != null) {
                            double d2 = (double)(System.currentTimeMillis() - l2) / 1000.0;
                            d2 = d2 <= 0.0 ? 0.1 : d2;
                            String string3 = o;
                            if (string3 != null && string3.equals(string2)) {
                                string3 = "-";
                            }
                            k2 = new k(context2, string3, string2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), d2, statSpecifyReportedInfo);
                            k2.addCommonProperty("auto", n2);
                            if (!string2.equals(n)) {
                                r.warn("Invalid invocation since previous onResume on diff page.");
                            }
                        } else {
                            r.e("Starttime for PageID:" + string2 + " not found, lost onResume()?");
                            return;
                        }
                        new c(k2).a();
                        o = string2;
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void trackEndPage(Context context, String string, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null || string == null || string.length() == 0) {
            r.error("The Context or pageName of StatService.trackEndPage() can not be null or empty!");
            return;
        }
        StatServiceImpl.b(context2, string, 0, statSpecifyReportedInfo);
    }

    public static void startNewSession(Context context, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.startNewSession() can not be null!");
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatServiceImpl.stopSession();
                        StatServiceImpl.getSessionID(context2, true, statSpecifyReportedInfo);
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void stopSession() {
        i = 0L;
    }

    static void a(Context context, StatSpecifyReportedInfo statSpecifyReportedInfo, boolean bl) {
        try {
            if (statSpecifyReportedInfo == null) {
                statSpecifyReportedInfo = D;
            }
            r.d("trackBackground lastForegroundTs:" + C);
            if (C > 0L && StatConfig.r) {
                double d2 = (double)(System.currentTimeMillis() - C - StatConfig.getBackgroundDelayTimestamp()) / 1000.0;
                d2 = d2 <= 0.0 ? 0.1 : d2;
                StatServiceImpl.a(t, d2, statSpecifyReportedInfo, bl);
            }
        }
        catch (Throwable throwable) {
            r.e(throwable);
        }
        C = -1L;
    }

    public static void trackBackground(Context context, long l2, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        StatServiceImpl.a(context, l2, statSpecifyReportedInfo, false);
    }

    private static void a(Context context, final double d2, final StatSpecifyReportedInfo statSpecifyReportedInfo, final boolean bl) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackBackground() can not be null!");
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.i("trackBackground duration:" + d2);
                        StatServiceImpl.flushDataToDB(context2);
                        double d22 = d2 <= 0.0 ? 0.1 : d2;
                        com.tencent.stat.event.b b2 = new com.tencent.stat.event.b(StatServiceImpl.getContext(context2), StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), d22, statSpecifyReportedInfo);
                        if (!bl) {
                            new c(b2).a();
                        } else {
                            com.tencent.stat.e.a(context2).a(b2, null, false, true);
                        }
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static boolean isEnableAutoMonitorActivityCycle() {
        return w;
    }

    public static boolean isForeground() {
        return x;
    }

    public static boolean isBackground() {
        return !x;
    }

    public static void addActionListener(StatActionListener statActionListener) {
        A.add(statActionListener);
    }

    public static void removeActionListener(StatActionListener statActionListener) {
        A.remove(statActionListener);
    }

    private static void u() {
        block9: {
            try {
                String string = StatConfig.getSDKProperty("autoTm", "1");
                if (Integer.valueOf(string) != 1) break block9;
                Application application = null;
                if (t instanceof Application) {
                    application = (Application)t;
                } else if (t instanceof Activity) {
                    application = ((Activity)t).getApplication();
                } else {
                    try {
                        application = (Application)t;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if (application != null) {
                    StatServiceImpl.registerActivityLifecycleAutoStat(application, null);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityLifecycleAutoStat(Application application, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableAutoMonitorActivityCycle()) {
            r.warn("MTA Auto Monitor Activity Cycle is disable by user!");
            return;
        }
        if (w || application == null || Build.VERSION.SDK_INT < 14) {
            return;
        }
        StatConfig.q = true;
        t = Util.getContextSelf((Context)application);
        StatServiceImpl.getHandler(t);
        D = statSpecifyReportedInfo;
        if (z == null) {
            z = new Handler();
        }
        Class<StatServiceImpl> clazz = StatServiceImpl.class;
        synchronized (StatServiceImpl.class) {
            if (w) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            MtaActivityLifecycleCallback mtaActivityLifecycleCallback = new MtaActivityLifecycleCallback(){

                @Override
                public void onActivityStopped(Activity activity) {
                }

                @Override
                public void onActivityStarted(Activity activity) {
                }

                @Override
                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                @Override
                public void onActivityResumed(Activity activity) {
                    if (!StatConfig.isEnableStatService()) {
                        return;
                    }
                    if (StatConfig.q) {
                        StatServiceImpl.b((Context)activity, StatCommonHelper.getActivityName((Context)activity), statSpecifyReportedInfo);
                    }
                    y = false;
                    boolean bl = !x;
                    x = true;
                    if (B != null) {
                        z.removeCallbacks(B);
                    }
                    if (bl) {
                        r.i("went foreground");
                        v = System.currentTimeMillis();
                        for (StatActionListener statActionListener : A) {
                            try {
                                statActionListener.onBecameForeground();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                    } else {
                        r.i("still foreground");
                    }
                }

                @Override
                public void onActivityPaused(Activity activity) {
                    if (!StatConfig.isEnableStatService()) {
                        return;
                    }
                    if (StatConfig.q) {
                        StatServiceImpl.b((Context)activity, StatCommonHelper.getActivityName((Context)activity), 1, statSpecifyReportedInfo);
                    }
                    y = true;
                    if (B != null) {
                        z.removeCallbacks(B);
                    }
                    z.postDelayed(B = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (x && y) {
                                    r.i("went background");
                                    for (StatActionListener statActionListener : A) {
                                        try {
                                            statActionListener.onBecameBackground();
                                        }
                                        catch (Throwable throwable) {
                                            r.e(throwable);
                                        }
                                    }
                                    x = false;
                                } else {
                                    r.i("still foreground");
                                }
                            }
                            catch (Throwable throwable) {
                                r.e(throwable);
                            }
                        }
                    }, StatConfig.getBackgroundDelayTimestamp());
                }

                @Override
                public void onActivityDestroyed(Activity activity) {
                }

                @Override
                public void onActivityCreated(Activity activity, Bundle bundle) {
                }
            };
            StatActionListener statActionListener = new StatActionListener(){

                @Override
                public void onBecameForeground() {
                    C = System.currentTimeMillis();
                }

                @Override
                public void onBecameBackground() {
                    StatServiceImpl.a(t, statSpecifyReportedInfo, com.tencent.stat.common.c.a());
                }
            };
            try {
                StatServiceImpl.addActionListener(statActionListener);
                w = MtaActivityLifeCycle.registerActivityLifecycleCallbacks(application, mtaActivityLifecycleCallback);
                r.d("enableAutoMonitorActivityCycle:" + w + ",isAntoActivityLifecycleStat:" + StatConfig.isAntoActivityLifecycleStat());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
        }
    }

    public static void onResume(Context context, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        Context context2 = Util.getContextSelf(context);
        StatServiceImpl.trackBeginPage(context2, StatCommonHelper.getActivityName(context2), statSpecifyReportedInfo);
    }

    public static void setEnvAttributes(Context context, Map<String, String> map) {
        if (map == null || map.size() > 512) {
            r.error("The map in setEnvAttributes can't be null or its size can't exceed 512.");
            return;
        }
        try {
            com.tencent.stat.common.a.a(context, map);
        }
        catch (JSONException jSONException) {
            r.e(jSONException);
        }
    }

    public static void reportEvent(Context context, final Event event, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null || event == null) {
            r.error("context or event is null in reportEvent()");
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        new c(event).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void reportQQ(Context context, final String string, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("context is null in reportQQ()");
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    if (string == null || string.trim().length() == 0) {
                        r.w("qq num is null or empty.");
                        return;
                    }
                    StatConfig.f = string;
                    StatServiceImpl.b(context2, new StatAccount(string), statSpecifyReportedInfo);
                }
            });
        }
    }

    public static void reportAccount(Context context, final StatAccount statAccount, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.e("context is null in reportAccount.");
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    if (statAccount == null || statAccount.getAccount().trim().length() == 0) {
                        r.w("account is null or empty.");
                        return;
                    }
                    StatConfig.setQQ(context2, statAccount.getAccount());
                    StatServiceImpl.b(context2, statAccount, statSpecifyReportedInfo);
                }
            });
        }
    }

    private static void h(Context context) {
        JSONArray jSONArray = StatCommonHelper.multiAccountMapToJSONArray(E);
        StatPreferences.putString(context, ".stat.multi.acc.", jSONArray.toString());
    }

    private static void i(Context context) {
        String string = StatPreferences.getString(context, ".stat.multi.acc.", "");
        E = StatCommonHelper.multiAccounStrToMap(string);
    }

    public static Map<StatMultiAccount.AccountType, StatMultiAccount> getMultiAccount() {
        return E;
    }

    public static void addMultiAccount(StatMultiAccount statMultiAccount) {
        E.put(statMultiAccount.getType(), statMultiAccount);
    }

    public static void removeMultiAccount(Context context, StatMultiAccount.AccountType accountType, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        StatMultiAccount statMultiAccount = E.get((Object)accountType);
        if (statMultiAccount != null) {
            Context context2 = StatServiceImpl.getContext(context);
            statMultiAccount.setCurrentStatusType(StatMultiAccount.AccountStatus.LOGOUT);
            StatServiceImpl.h(context2);
            StatServiceImpl.c(context2, statSpecifyReportedInfo);
        }
    }

    public static void clearMultiAccount() {
        E.clear();
    }

    public static void reportMultiAccount(Context context, StatMultiAccount statMultiAccount, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (statMultiAccount == null) {
            r.e("account is null in reportAccount.");
            return;
        }
        List<StatMultiAccount> list = Arrays.asList(statMultiAccount);
        StatServiceImpl.reportMultiAccount(context, list, statSpecifyReportedInfo);
    }

    public static void reportMultiAccount(Context context, List<StatMultiAccount> list, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.e("context is null in reportAccount.");
            return;
        }
        if (list == null) {
            r.e("accountList is null in reportAccount.");
            return;
        }
        for (StatMultiAccount statMultiAccount : list) {
            E.put(statMultiAccount.getType(), statMultiAccount);
        }
        StatServiceImpl.c(context2, statSpecifyReportedInfo);
    }

    private static void c(final Context context, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (StatServiceImpl.getHandler(context) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    if (E == null) {
                        r.w("multiAccount is null or empty.");
                        return;
                    }
                    try {
                        com.tencent.stat.event.a a2 = new com.tencent.stat.event.a(context, StatServiceImpl.getSessionID(context, false, statSpecifyReportedInfo), E, statSpecifyReportedInfo);
                        new c(a2).a();
                        StatServiceImpl.h(context);
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context, throwable);
                    }
                }
            });
        }
    }

    public static void reportGameUser(Context context, final StatGameUser statGameUser, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.reportGameUser() can not be null!");
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    if (statGameUser == null) {
                        r.error("The gameUser of StatService.reportGameUser() can not be null!");
                        return;
                    }
                    if (statGameUser.getAccount() == null || statGameUser.getAccount().length() == 0) {
                        r.error("The account of gameUser on StatService.reportGameUser() can not be null or empty!");
                        return;
                    }
                    try {
                        f f2 = new f(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), statGameUser, statSpecifyReportedInfo);
                        new c(f2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static boolean startStatService(final Context context, String string, String string2, final StatSpecifyReportedInfo statSpecifyReportedInfo) throws MtaSDkException {
        try {
            if (!StatConfig.isEnableStatService()) {
                r.error("MTA StatService is disable.");
                return false;
            }
            String string3 = "3.4.7";
            if (StatConfig.isDebugEnable()) {
                r.d("MTA SDK version, current: " + string3 + " ,required: " + string2);
            }
            String string4 = "";
            if (context == null || string2 == null) {
                string4 = "Context or mtaSdkVersion in StatService.startStatService() is null, please check it!";
                r.error(string4);
                StatConfig.setEnableStatService(false);
                return false;
            }
            if (StatCommonHelper.getSDKLongVersion(string3) < StatCommonHelper.getSDKLongVersion(string2)) {
                string4 = "MTA SDK version conflicted, current: " + string3 + ",required: " + string2;
                string4 = string4 + ". please delete the current SDK and download the latest one. official website: http://mta.qq.com/ or http://mta.oa.com/";
                r.error(string4);
                StatConfig.setEnableStatService(false);
                return false;
            }
            String string5 = StatConfig.getInstallChannel(context);
            if (string5 == null || string5.length() == 0) {
                StatConfig.setInstallChannel("-");
            }
            if (string != null) {
                StatConfig.setAppKey(context, string);
            }
            if (StatServiceImpl.getHandler(context) != null) {
                e.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StatServiceImpl.getSessionID(context, false, statSpecifyReportedInfo);
                        }
                        catch (Throwable throwable) {
                            r.e(throwable);
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            r.e(throwable);
            return false;
        }
        return true;
    }

    public static void onPause(Context context, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        Context context2 = Util.getContextSelf(context);
        StatServiceImpl.trackEndPage(context2, StatCommonHelper.getActivityName(context2), statSpecifyReportedInfo);
    }

    public static void onStop(Context context, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    if (context2 == null) {
                        r.error("The Context of StatService.onStop() can not be null!");
                        return;
                    }
                    StatServiceImpl.flushDataToDB(context2);
                    if (!StatServiceImpl.a()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        if (StatCommonHelper.isBackgroundRunning(context2)) {
                            if (StatConfig.isDebugEnable()) {
                                r.i("onStop isBackgroundRunning flushDataToDB");
                            }
                            StatServiceImpl.commitEvents(context2, -1);
                        }
                    }
                }
            });
        }
    }

    public static void onLowMemory(final Context context) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    StatServiceImpl.flushDataToDB(context);
                }
            });
        }
    }

    public static int reportError(Context context, final String string, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.reportError() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.reportError() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string)) {
            r.error("The length of err for StatService.reportError() exceeds the limit:61440");
            return 1001;
        }
        final Thread thread = Thread.currentThread();
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        com.tencent.stat.event.e e2 = new com.tencent.stat.event.e(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), string, 0, StatConfig.getMaxReportEventLength(), thread, statSpecifyReportedInfo);
                        new c(e2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    public static int reportException(Context context, int n2, String string) {
        return StatServiceImpl.reportException(context, n2, "", string);
    }

    public static int reportException(Context context, int n2, String string, String string2) {
        return StatServiceImpl.reportException(context, n2, string, string2);
    }

    public static int reportException(Context context, int n2, String string, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        return StatServiceImpl.reportException(context, n2, -1L, "", string, statSpecifyReportedInfo);
    }

    public static int reportException(Context context, final int n2, final long l2, final String string, final String string2, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.reportException() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string2)) {
            r.error("The event_id of StatService.reportException() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string, string2)) {
            r.error("The length of err for StatService.reportException() exceeds the limit:61440");
            return 1001;
        }
        final Thread thread = Thread.currentThread();
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        com.tencent.stat.event.e e2 = new com.tencent.stat.event.e(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), string2, n2, StatConfig.getMaxReportEventLength(), thread, statSpecifyReportedInfo);
                        e2.a(string);
                        e2.a(l2);
                        new c(e2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    static void a(Context context, final Throwable throwable) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.reportSdkSelfException() can not be null!");
            return;
        }
        final Thread thread = Thread.currentThread();
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!StatConfig.isEnableStatService()) {
                            return;
                        }
                        com.tencent.stat.event.e e2 = new com.tencent.stat.event.e(context2, StatServiceImpl.getSessionID(context2, false, null), 99, throwable, thread, com.tencent.stat.event.h.a);
                        new c(e2).a();
                    }
                    catch (Throwable throwable2) {
                        r.e("reportSdkSelfException error: " + throwable2);
                    }
                }
            });
        }
    }

    private static void b(Context context, StatAccount statAccount, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        try {
            com.tencent.stat.event.a a2 = new com.tencent.stat.event.a(context, StatServiceImpl.getSessionID(context, false, statSpecifyReportedInfo), statAccount, statSpecifyReportedInfo);
            new c(a2).a();
        }
        catch (Throwable throwable) {
            r.e(throwable);
            StatServiceImpl.a(context, throwable);
        }
    }

    public static int reportException(Context context, final Throwable throwable, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.reportException() can not be null!");
            return 1000;
        }
        if (throwable == null) {
            r.error("The Throwable of StatService.reportException() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(throwable)) {
            r.error("The length of err for StatService.reportException() exceeds the limit:61440");
            return 1001;
        }
        final Thread thread = Thread.currentThread();
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    com.tencent.stat.event.e e2 = new com.tencent.stat.event.e(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), 1, throwable, thread, statSpecifyReportedInfo);
                    new c(e2).a();
                }
            });
        }
        return 0;
    }

    static void c(Context context) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (StatServiceImpl.getHandler(context2) != null) {
            e.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (context2 == null) {
                        r.error("The Context of StatService.reportNativeCrash() can not be null!");
                        return;
                    }
                    try {
                        new Thread((Runnable)new a(context2), "NativeCrashRepoter").start();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            }, (long)(StatCrashReporter.getStatCrashReporter(context2).getReportDelaySecOnStart() * 1000));
        }
    }

    public static int reportCustomProperty(Context context, final JSONObject jSONObject, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.reportCustomProperty() can not be null!");
            return 1000;
        }
        if (jSONObject == null) {
            r.error("The jsonObject of StatService.reportCustomProperty() can not be null ");
            return 1000;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        com.tencent.stat.event.d d2 = new com.tencent.stat.event.d(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), statSpecifyReportedInfo);
                        d2.a(jSONObject);
                        new c(d2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    public static int trackCustomEvent(Context context, final String string, final StatSpecifyReportedInfo statSpecifyReportedInfo, final String ... stringArray) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackCustomEvent() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.trackCustomEvent() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string, stringArray)) {
            r.error("The length of event_id/args for StatService.trackCustomEvent() exceeds the limit:61440");
            return 1001;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.a a2 = new c.a(string, stringArray, null);
                        com.tencent.stat.event.c c2 = new com.tencent.stat.event.c(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), a2.a, statSpecifyReportedInfo);
                        c2.a().b = a2.b;
                        new c(c2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    static void d(Context context) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.sendNetworkDetector() can not be null!");
            return;
        }
        try {
            h h2 = new h(context2);
            com.tencent.stat.d.b(context2).a(h2, new StatDispatchCallback(){

                @Override
                public void onDispatchSuccess() {
                    StatServiceImpl.c();
                }

                @Override
                public void onDispatchFailure() {
                    StatServiceImpl.d();
                }
            });
        }
        catch (Throwable throwable) {
            r.e(throwable);
        }
    }

    public static void trackCustomKVEvent(Context context, final String string, final Properties properties, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        Context context2;
        if (!StatConfig.isEnableStatService()) {
            // empty if block
        }
        if ((context2 = StatServiceImpl.getContext(context)) == null) {
            r.error("The Context of StatService.trackCustomKVEvent() can not be null!");
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.trackCustomKVEvent() can not be null or empty.");
        }
        if (StatCommonHelper.checkArgumentsLength(string, properties)) {
            r.error("The length of event_id/properties for StatService.trackCustomKVEvent() exceeds the limit:61440");
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.a a2 = new c.a(string, null, properties);
                        com.tencent.stat.event.c c2 = new com.tencent.stat.event.c(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), a2.a, statSpecifyReportedInfo);
                        c2.a().c = a2.c;
                        new c(c2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void trackRegAccountEvent(Context context, final String string, final StatConfig.AccountType accountType) {
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackRegAccountEvent() can not be null!");
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        m m2 = new m(context2, StatServiceImpl.getSessionID(context2, false, null), string, accountType);
                        new c(m2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void trackPayEvent(Context context, final String string, final String string2, final double d2, final StatConfig.CurrencyType currencyType) {
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackRegAccountEvent() can not be null!");
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        l l2 = new l(context2, StatServiceImpl.getSessionID(context2, false, null), string, string2, d2, currencyType);
                        new c(l2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void setCommonKeyValueForKVEvent(String string, Properties properties) {
        if (StatCommonHelper.isStringValid(string)) {
            if (properties != null && properties.size() > 0) {
                g.put(string, (Properties)properties.clone());
            } else {
                g.remove(string);
            }
        } else {
            r.e("event_id or commonProp for setCommonKeyValueForKVEvent is invalid.");
        }
    }

    public static Properties getCommonKeyValueForKVEvent(String string) {
        return g.get(string);
    }

    public static int trackCustomBeginEvent(Context context, final String string, StatSpecifyReportedInfo statSpecifyReportedInfo, final String ... stringArray) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackCustomBeginEvent() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.trackCustomBeginEvent() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string, stringArray)) {
            r.error("The length of event_id/args for StatService.trackCustomBeginEvent() exceeds the limit:61440");
            return 1001;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.a a2 = new c.a(string, stringArray, null);
                        if (StatConfig.isDebugEnable()) {
                            r.i("add begin key:" + a2.toString());
                        }
                        if (f.containsKey(a2)) {
                            r.error("Duplicate CustomEvent key: " + a2.toString() + ", trackCustomBeginEvent() repeated?");
                            return;
                        }
                        if (f.size() <= StatConfig.getMaxParallelTimmingEvents()) {
                            f.put(a2, System.currentTimeMillis());
                        } else {
                            r.error("The number of timedEvent exceeds the maximum value " + Integer.toString(StatConfig.getMaxParallelTimmingEvents()));
                        }
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    public static int trackCustomEndEvent(Context context, final String string, final StatSpecifyReportedInfo statSpecifyReportedInfo, final String ... stringArray) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackCustomEndEvent() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.trackCustomEndEvent() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string, stringArray)) {
            r.error("The length of event_id/args for StatService.trackCustomEndEvent() exceeds the limit:61440");
            return 1001;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.a a2 = new c.a(string, stringArray, null);
                        Long l2 = (Long)f.remove(a2);
                        if (null != l2) {
                            com.tencent.stat.event.c c2 = new com.tencent.stat.event.c(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), a2.a, statSpecifyReportedInfo);
                            c2.a().b = a2.b;
                            double d2 = (double)(System.currentTimeMillis() - l2) / 1000.0;
                            d2 = d2 <= 0.0 ? 0.1 : d2;
                            c2.a(d2);
                            new c(c2).a();
                        } else {
                            r.error("No start time found for custom event: " + a2.toString() + ", lost trackCustomBeginEvent()?");
                        }
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    public static int trackCustomBeginKVEvent(Context context, final String string, final Properties properties, StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackCustomBeginKVEvent() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.trackCustomBeginKVEvent() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string, properties)) {
            r.error("The length of event_id/properties for StatService.trackCustomBeginKVEvent() exceeds the limit:61440");
            return 1001;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.a a2 = new c.a(string, null, properties);
                        if (StatConfig.isDebugEnable()) {
                            r.i("add begin key:" + a2);
                        }
                        if (f.containsKey(a2)) {
                            r.warn("Duplicate CustomEvent key: " + a2.toString() + ", trackCustomBeginKVEvent() repeated?");
                            return;
                        }
                        if (f.size() <= StatConfig.getMaxParallelTimmingEvents()) {
                            f.put(a2, System.currentTimeMillis());
                        } else {
                            r.error("The number of timedEvent exceeds the maximum value " + Integer.toString(StatConfig.getMaxParallelTimmingEvents()));
                        }
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    public static int trackCustomEndKVEvent(Context context, final String string, final Properties properties, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackCustomEndKVEvent() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.trackCustomEndKVEvent() can not be null or empty.");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string, properties)) {
            r.error("The length of event_id/properties for StatService.trackCustomEndKVEvent() exceeds the limit:61440");
            return 1001;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.a a2 = new c.a(string, null, properties);
                        Long l2 = (Long)f.remove(a2);
                        if (null != l2) {
                            com.tencent.stat.event.c c2 = new com.tencent.stat.event.c(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), a2.a, statSpecifyReportedInfo);
                            c2.a().c = a2.c;
                            double d2 = (double)(System.currentTimeMillis() - l2) / 1000.0;
                            d2 = d2 <= 0.0 ? 0.1 : d2;
                            c2.a(d2);
                            new c(c2).a();
                        } else {
                            r.warn("No start time found for custom event: " + a2.toString() + ", lost trackCustomBeginKVEvent()?");
                        }
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    public static void reportAppMonitorStat(Context context, StatAppMonitor statAppMonitor, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.reportAppMonitorStat() can not be null!");
            return;
        }
        if (statAppMonitor == null) {
            r.error("The StatAppMonitor of StatService.reportAppMonitorStat() can not be null!");
            return;
        }
        if (statAppMonitor.getInterfaceName() == null) {
            r.error("The interfaceName of StatAppMonitor on StatService.reportAppMonitorStat() can not be null!");
            return;
        }
        final StatAppMonitor statAppMonitor2 = statAppMonitor.clone();
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        g g2 = new g(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), statAppMonitor2, statSpecifyReportedInfo);
                        new c(g2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static int trackCustomKVTimeIntervalEvent(Context context, final String string, final Properties properties, final int n2, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return -1;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.trackCustomKVTimeIntervalEvent() can not be null!");
            return 1000;
        }
        if (StatServiceImpl.a(string)) {
            r.error("The event_id of StatService.trackCustomKVTimeIntervalEvent() can not be null or empty.");
            return 1000;
        }
        if (n2 <= 0) {
            r.error("The intervalSecond of StatService.trackCustomTimeIntervalEvent() can must bigger than 0!");
            return 1000;
        }
        if (StatCommonHelper.checkArgumentsLength(string, properties)) {
            r.error("The length of event_id/properties for StatService.trackCustomKVTimeIntervalEvent() exceeds the limit:61440");
            return 1001;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.a a2 = new c.a(string, null, properties);
                        com.tencent.stat.event.c c2 = new com.tencent.stat.event.c(context2, StatServiceImpl.getSessionID(context2, false, statSpecifyReportedInfo), a2.a, statSpecifyReportedInfo);
                        c2.a().c = a2.c;
                        double d2 = n2;
                        d2 = d2 <= 0.0 ? 0.1 : d2;
                        c2.a(d2);
                        new c(c2).a();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
        return 0;
    }

    public static void commitEvents(Context context, final int n2) {
        Context context2;
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (StatConfig.isDebugEnable()) {
            r.i("commitEvents, maxNumber=" + n2);
        }
        if ((context2 = StatServiceImpl.getContext(context)) == null) {
            r.error("The Context of StatService.commitEvents() can not be null!");
            return;
        }
        if (n2 < -1 || n2 == 0) {
            r.error("The maxNumber of StatService.commitEvents() should be -1 or bigger than 0.");
            return;
        }
        if (!NetworkManager.getInstance(context2).isNetworkAvailable()) {
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatServiceImpl.flushDataToDB(context2);
                        com.tencent.stat.e.a(context2).a(n2);
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void testSpeed(Context context) {
        StatServiceImpl.b(context, null);
    }

    static void b(Context context, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.testSpeed() can not be null!");
            return;
        }
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        new Thread((Runnable)new b(context2, null, statSpecifyReportedInfo), "NetworkMonitorTask").start();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void testSpeed(Context context, Map<String, Integer> map, final StatSpecifyReportedInfo statSpecifyReportedInfo) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        final Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.testSpeed() can not be null!");
            return;
        }
        if (map == null || map.size() == 0) {
            r.error("The domainMap of StatService.testSpeed() can not be null or empty!");
            return;
        }
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>(map);
        if (StatServiceImpl.getHandler(context2) != null) {
            e.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        new Thread((Runnable)new b(context2, hashMap, statSpecifyReportedInfo), "NetworkMonitorTask").start();
                    }
                    catch (Throwable throwable) {
                        r.e(throwable);
                        StatServiceImpl.a(context2, throwable);
                    }
                }
            });
        }
    }

    public static void flushDataToDB(Context context) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        if (StatConfig.m <= 0) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.testSpeed() can not be null!");
            return;
        }
        com.tencent.stat.e.a(context2).d();
    }

    public static void getFeedBackMessage(Context context, int n2, int n3, StatFBDispatchCallback statFBDispatchCallback) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.getFeedBackMessage() can not be null!");
            return;
        }
        try {
            com.tencent.stat.d.b(context2).b(n2, n3, statFBDispatchCallback);
        }
        catch (Throwable throwable) {
            r.e(throwable);
        }
    }

    public static void postFeedBackFiles(Context context, String string, String string2, StatFBDispatchCallback statFBDispatchCallback) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.postFeedBackFiles() can not be null!");
            return;
        }
        try {
            com.tencent.stat.d.b(context2).b(string, string2, statFBDispatchCallback);
        }
        catch (Throwable throwable) {
            r.e(throwable);
        }
    }

    public static void replyFeedBackMessage(Context context, String string, String string2, StatFBDispatchCallback statFBDispatchCallback) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        Context context2 = StatServiceImpl.getContext(context);
        if (context2 == null) {
            r.error("The Context of StatService.replyFeedBackMessage() can not be null!");
            return;
        }
        try {
            com.tencent.stat.d.b(context2).c(string, string2, statFBDispatchCallback);
        }
        catch (Throwable throwable) {
            r.e(throwable);
        }
    }

    static boolean a(File file) {
        String string = StatServiceImpl.b(file);
        int n2 = StatPreferences.getInt(t, string, 0);
        if (n2 == 65535) {
            file.delete();
            return true;
        }
        return false;
    }

    static String b(File file) {
        return "__MTA.CRASH.FILE.SEND.CNT." + file.getName();
    }

    static void c(File file) {
        file.delete();
        String string = StatServiceImpl.b(file);
        StatPreferences.putInt(t, string, 65535);
    }

    static void d(File file) {
        String string = StatServiceImpl.b(file);
        int n2 = StatPreferences.getInt(t, string, 0) + 1;
        if (n2 >= StatCrashReporter.getStatCrashReporter(t).getMaxNumOfRetries()) {
            StatServiceImpl.c(file);
        } else {
            StatPreferences.putInt(t, string, n2);
        }
    }

    static void c() {
        b = 0;
        c = 0L;
    }

    static void d() {
        ++b;
        c = System.currentTimeMillis();
        StatServiceImpl.flushDataToDB(t);
    }

    static void e(Context context) {
        d = System.currentTimeMillis() + (long)(60000 * StatConfig.getSendPeriodMinutes());
        StatPreferences.putLong(context, "last_period_ts", d);
        StatServiceImpl.commitEvents(context, -1);
    }

    static {
        f = new ConcurrentHashMap<c.a, Long>();
        g = new ConcurrentHashMap<String, Properties>();
        h = new ConcurrentHashMap<Integer, Integer>(10);
        i = 0L;
        j = 0L;
        k = 0L;
        l = "";
        m = 0;
        n = "";
        o = "";
        p = new ConcurrentHashMap<String, Long>();
        a = new ArrayList<String>();
        q = new ConcurrentHashMap<String, Long>();
        r = StatCommonHelper.getLogger();
        s = true;
        b = 0;
        c = 0L;
        t = null;
        d = 0L;
        u = 0L;
        v = 0L;
        w = false;
        x = false;
        y = true;
        z = null;
        A = new CopyOnWriteArrayList<StatActionListener>();
        B = null;
        C = -1L;
        D = null;
        E = new ConcurrentHashMap<StatMultiAccount.AccountType, StatMultiAccount>();
    }

    public static class c {
        private Event a;
        private StatReportStrategy b = null;
        private boolean c = false;
        private Context d = null;
        private long e = System.currentTimeMillis();
        private static volatile long f = 0L;

        public c(Event event) {
            this.a = event;
            this.b = StatConfig.getStatSendStrategy();
            this.c = event.isImportant();
            this.d = event.getContext();
        }

        private void b() {
            if (this.a.getType() == EventType.CUSTOM) {
                com.tencent.stat.event.c c2 = (com.tencent.stat.event.c)this.a;
                String string = c2.a().a;
                if (StatConfig.a(string)) {
                    r.d("eventid=" + string + " matched, report instant.");
                    this.d();
                    return;
                }
                if (StatConfig.isEventIdInDontReportEventIdsSet(string)) {
                    r.w("eventid=" + string + " In DontReportEventIdsSet, droped.");
                    return;
                }
            }
            if (this.a.getStatSpecifyReportedInfo() != null && this.a.getStatSpecifyReportedInfo().isSendImmediately()) {
                this.b = StatReportStrategy.INSTANT;
            }
            if (StatConfig.j && NetworkManager.getInstance(t).isWifi()) {
                this.b = StatReportStrategy.INSTANT;
            }
            if (StatConfig.isDebugEnable()) {
                r.i("strategy=" + this.b.name());
            }
            switch (this.b) {
                case INSTANT: {
                    this.c();
                    break;
                }
                case PERIOD: {
                    com.tencent.stat.e.a(this.d).a(this.a, null, this.c, false);
                    if (StatConfig.isDebugEnable()) {
                        r.i("PERIOD currTime=" + this.e + ",nextPeriodSendTs=" + d + ",difftime=" + (d - this.e));
                    }
                    if (d == 0L) {
                        long l2;
                        d = StatPreferences.getLong(this.d, "last_period_ts", 0L);
                        if (this.e > d) {
                            StatServiceImpl.e(this.d);
                        }
                        if (d > (l2 = this.e + (long)(StatConfig.getSendPeriodMinutes() * 60 * 1000))) {
                            d = l2;
                        }
                        com.tencent.stat.b.a(this.d).a();
                    }
                    if (StatConfig.isDebugEnable()) {
                        r.i("PERIOD currTime=" + this.e + ",nextPeriodSendTs=" + d + ",difftime=" + (d - this.e));
                    }
                    if (this.e <= d) break;
                    StatServiceImpl.e(this.d);
                    break;
                }
                case APP_LAUNCH: 
                case DEVELOPER: {
                    com.tencent.stat.e.a(this.d).a(this.a, null, this.c, false);
                    break;
                }
                case BATCH: {
                    com.tencent.stat.e.a(this.d).a(this.a, new StatDispatchCallback(){

                        @Override
                        public void onDispatchSuccess() {
                            StatServiceImpl.c();
                            if (com.tencent.stat.e.b().a() >= StatConfig.getMaxBatchReportCount()) {
                                com.tencent.stat.e.b().a(StatConfig.getMaxBatchReportCount());
                            }
                        }

                        @Override
                        public void onDispatchFailure() {
                            StatServiceImpl.d();
                        }
                    }, this.c, true);
                    break;
                }
                case ONLY_WIFI: {
                    if (NetworkManager.getInstance(t).getNetworkType() == 1) {
                        this.c();
                        break;
                    }
                    com.tencent.stat.e.a(this.d).a(this.a, null, this.c, false);
                    break;
                }
                case ONLY_WIFI_NO_CACHE: {
                    if (!StatCommonHelper.isWiFiActive(this.d)) break;
                    this.a(new StatDispatchCallback(){

                        @Override
                        public void onDispatchSuccess() {
                            StatServiceImpl.c();
                        }

                        @Override
                        public void onDispatchFailure() {
                            StatServiceImpl.d();
                        }
                    });
                    break;
                }
                default: {
                    r.error("Invalid stat strategy:" + (Object)((Object)StatConfig.getStatSendStrategy()));
                }
            }
        }

        private void c() {
            if (com.tencent.stat.e.b().a > 0 && StatConfig.l || this.a.getType() == EventType.BACKGROUND) {
                com.tencent.stat.e.b().a(this.a, null, this.c, true);
                com.tencent.stat.e.b().a(-1);
            } else {
                this.a(new StatDispatchCallback(){

                    @Override
                    public void onDispatchSuccess() {
                        StatServiceImpl.c();
                        if (c.this.a.getType() == EventType.SESSION_ENV && StatCommonHelper.needReportApp(t)) {
                            r.d("OnceEvent report");
                            j j2 = new j(t, m, null, c.this.a.getStatSpecifyReportedInfo());
                            com.tencent.stat.d.b(t).a(j2, new StatDispatchCallback(){

                                @Override
                                public void onDispatchSuccess() {
                                    StatCommonHelper.updateNextReportTime(t);
                                }

                                @Override
                                public void onDispatchFailure() {
                                }
                            });
                        }
                        if (com.tencent.stat.e.b().a > 0) {
                            StatServiceImpl.commitEvents(c.this.d, -1);
                        }
                    }

                    @Override
                    public void onDispatchFailure() {
                        com.tencent.stat.e.b().a(c.this.a, null, c.this.c, true);
                        StatServiceImpl.d();
                    }
                });
            }
        }

        private void d() {
            this.a(new StatDispatchCallback(){

                @Override
                public void onDispatchSuccess() {
                    StatServiceImpl.c();
                }

                @Override
                public void onDispatchFailure() {
                    com.tencent.stat.e.b().a(c.this.a, null, c.this.c, true);
                    StatServiceImpl.d();
                }
            });
        }

        private void a(StatDispatchCallback statDispatchCallback) {
            com.tencent.stat.d.b(t).a(this.a, statDispatchCallback);
        }

        private boolean e() {
            if (StatConfig.h > 0) {
                if (this.e > j) {
                    h.clear();
                    j = this.e + StatConfig.i;
                    if (StatConfig.isDebugEnable()) {
                        r.i("clear methodsCalledLimitMap, nextLimitCallClearTime=" + j);
                    }
                }
                Integer n2 = this.a.getType().GetIntValue();
                Integer n3 = (Integer)h.get(n2);
                if (n3 != null) {
                    h.put(n2, n3 + 1);
                    if (n3 > StatConfig.h) {
                        if (StatConfig.isDebugEnable()) {
                            r.e("event " + this.a.toJsonString() + " was discard, cause of called limit, current:" + n3 + ", limit:" + StatConfig.h + ", period:" + StatConfig.i + " ms");
                        }
                        return true;
                    }
                } else {
                    h.put(n2, 1);
                }
            }
            return false;
        }

        public void a() {
            if (this.e()) {
                return;
            }
            if (StatConfig.p != null) {
                String string = this.a.toJsonString();
                if (StatConfig.isDebugEnable()) {
                    r.i("transfer event data:" + string);
                }
                StatConfig.p.onTransfer(string);
                return;
            }
            if (StatConfig.m > 0 && this.e >= f) {
                StatServiceImpl.flushDataToDB(this.d);
                f = this.e + StatConfig.n;
                if (StatConfig.isDebugEnable()) {
                    r.i("nextFlushTime=" + f);
                }
            }
            if (NetworkManager.getInstance(this.d).isNetworkAvailable()) {
                if (StatConfig.isDebugEnable()) {
                    r.i("sendFailedCount=" + b);
                }
                if (!StatServiceImpl.a()) {
                    this.b();
                } else {
                    com.tencent.stat.e.a(this.d).a(this.a, null, this.c, false);
                    long l2 = this.e - c;
                    if (l2 > 1800000L) {
                        StatServiceImpl.d(this.d);
                    }
                }
            } else {
                com.tencent.stat.e.a(this.d).a(this.a, null, this.c, false);
            }
        }
    }

    static class b
    implements Runnable {
        private Context a = null;
        private Map<String, Integer> b = null;
        private StatSpecifyReportedInfo c = null;

        public b(Context context, Map<String, Integer> map, StatSpecifyReportedInfo statSpecifyReportedInfo) {
            this.a = context;
            this.c = statSpecifyReportedInfo;
            if (map != null) {
                this.b = map;
            }
        }

        private Map<String, Integer> a() {
            String[] stringArray;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            String string = StatConfig.getSDKProperty("__MTA_TEST_SPEED__", null);
            if (string == null || string.trim().length() == 0) {
                return hashMap;
            }
            for (String string2 : stringArray = string.split(";")) {
                String string3;
                String[] stringArray2 = string2.split(",");
                if (stringArray2 == null || stringArray2.length != 2 || (string3 = stringArray2[0]) == null || string3.trim().length() == 0) continue;
                int n2 = 80;
                try {
                    n2 = Integer.valueOf(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    r.e(numberFormatException);
                    continue;
                }
                hashMap.put(string3, n2);
            }
            return hashMap;
        }

        @Override
        public void run() {
            try {
                if (this.b == null) {
                    this.b = this.a();
                }
                if (this.b == null || this.b.size() == 0) {
                    r.i("empty domain list.");
                    return;
                }
                NetworkMonitor networkMonitor = null;
                JSONArray jSONArray = new JSONArray();
                for (Map.Entry<String, Integer> entry : this.b.entrySet()) {
                    String string = entry.getKey();
                    if (string == null || string.length() == 0) {
                        r.w("empty domain name.");
                        continue;
                    }
                    Integer n2 = entry.getValue();
                    if (n2 == null) {
                        r.w("port is null for " + string);
                        continue;
                    }
                    networkMonitor = this.a(entry.getKey(), entry.getValue());
                    jSONArray.put((Object)networkMonitor.toJSONObject());
                }
                if (jSONArray.length() == 0) {
                    return;
                }
                i i2 = new i(this.a, StatServiceImpl.getSessionID(this.a, false, this.c), this.c);
                i2.a(jSONArray.toString());
                new c(i2).a();
            }
            catch (Throwable throwable) {
                r.e(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NetworkMonitor a(String string, int n2) {
            NetworkMonitor networkMonitor = new NetworkMonitor();
            Socket socket = new Socket();
            int n3 = 0;
            try {
                networkMonitor.setDomain(string);
                networkMonitor.setPort(n2);
                long l2 = System.currentTimeMillis();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
                socket.connect(inetSocketAddress, 30000);
                networkMonitor.setMillisecondsConsume(System.currentTimeMillis() - l2);
                networkMonitor.setRemoteIp(inetSocketAddress.getAddress().getHostAddress());
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                n3 = -1;
                r.e(iOException);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {
                    r.e(throwable);
                }
            }
            networkMonitor.setStatusCode(n3);
            return networkMonitor;
        }
    }

    static class a
    implements Runnable {
        private Context a = null;

        public a(Context context) {
            this.a = context;
        }

        @Override
        public void run() {
            LinkedHashSet<File> linkedHashSet = StatNativeCrashReport.getCrashEventsFilesList(this.a);
            for (final File file : linkedHashSet) {
                if (!StatConfig.isDebugEnable() || !NetworkManager.getInstance(t).isNetworkAvailable() || StatServiceImpl.a(file)) continue;
                String string = com.tencent.stat.common.b.a(this.a, file.getAbsolutePath());
                com.tencent.stat.d.b(t).a(string, new StatDispatchCallback(){

                    @Override
                    public void onDispatchSuccess() {
                        file.delete();
                        StatServiceImpl.c(file);
                    }

                    @Override
                    public void onDispatchFailure() {
                        StatServiceImpl.d(file);
                    }
                });
            }
        }
    }
}

