/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.text.TextUtils;
import com.tencent.stat.common.Util;
import org.json.JSONException;
import org.json.JSONObject;

public class StatMultiAccount {
    private AccountType a = AccountType.UNDEFINED;
    private String b;
    private AccountRequestType c = AccountRequestType.UNDEFINED;
    private AccountStatus d = AccountStatus.UNDEFINED;
    private long e;
    private long f = System.currentTimeMillis() / 1000L;
    private String g;

    private StatMultiAccount() {
    }

    public StatMultiAccount(AccountType accountType, String string) {
        this.a = accountType;
        this.b = string;
    }

    public AccountType getType() {
        return this.a;
    }

    public StatMultiAccount setType(AccountType accountType) {
        this.a = accountType;
        return this;
    }

    public String getId() {
        return this.b;
    }

    public StatMultiAccount setId(String string) {
        this.b = string;
        return this;
    }

    public AccountRequestType getRequestType() {
        return this.c;
    }

    public StatMultiAccount setRequestType(AccountRequestType accountRequestType) {
        this.c = accountRequestType;
        return this;
    }

    public AccountStatus getCurrentStatusType() {
        return this.d;
    }

    public StatMultiAccount setCurrentStatusType(AccountStatus accountStatus) {
        this.d = accountStatus;
        return this;
    }

    public long getExpireTimeSec() {
        return this.e;
    }

    public StatMultiAccount setExpireTimeSec(long l2) {
        this.e = l2;
        return this;
    }

    public long getLastTimeSec() {
        return this.f;
    }

    public StatMultiAccount setLastTimeSec(long l2) {
        this.f = l2;
        return this;
    }

    public String getBind() {
        return this.g;
    }

    public StatMultiAccount setBind(String string) {
        this.g = string;
        return this;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("t", this.a.getIntValue());
            jSONObject.put("rty", this.c.getIntValue());
            jSONObject.put("csts", this.d.getIntValue());
            jSONObject.put("exp", this.e);
            jSONObject.put("tm", this.f);
            Util.jsonPut(jSONObject, "a", this.b);
            Util.jsonPut(jSONObject, "bind", this.g);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public static StatMultiAccount parse(String string) {
        StatMultiAccount statMultiAccount = new StatMultiAccount();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                statMultiAccount.b = jSONObject.optString("a");
                statMultiAccount.g = jSONObject.optString("bind");
                statMultiAccount.e = jSONObject.optLong("exp");
                statMultiAccount.f = jSONObject.optLong("tm");
                statMultiAccount.a = AccountType.fromInt(jSONObject.optInt("t"));
                statMultiAccount.c = AccountRequestType.fromInt(jSONObject.optInt("rty"));
                statMultiAccount.d = AccountStatus.fromInt(jSONObject.optInt("csts"));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return statMultiAccount;
    }

    public static enum AccountRequestType {
        UNDEFINED(-1),
        NORMAL_LOGIN(1),
        REFLESH_TOKEN(2),
        EXCH_SHORT_TOKEN(3),
        EXCH_3PART_TOKEN(4);

        private int a;

        private AccountRequestType(int n3) {
            this.a = n3;
        }

        public int getIntValue() {
            return this.a;
        }

        public static AccountRequestType fromInt(int n2) {
            for (AccountRequestType accountRequestType : AccountRequestType.values()) {
                if (n2 != accountRequestType.getIntValue()) continue;
                return accountRequestType;
            }
            return null;
        }
    }

    public static enum AccountStatus {
        UNDEFINED(-1),
        NORMAL(1),
        LOGOUT(0);

        private int a;

        private AccountStatus(int n3) {
            this.a = n3;
        }

        public int getIntValue() {
            return this.a;
        }

        public static AccountStatus fromInt(int n2) {
            for (AccountStatus accountStatus : AccountStatus.values()) {
                if (n2 != accountStatus.getIntValue()) continue;
                return accountStatus;
            }
            return null;
        }
    }

    public static enum AccountType {
        UNDEFINED(0),
        PHONE_NO(1),
        EMAIL(2),
        QQ_NUM(3),
        OPEN_WEIXIN(1000),
        OPEN_QQ(1001),
        OPEN_WEIBO(1002),
        OPEN_ALIPAY(1003),
        OPEN_TAOBAO(1004),
        OPEN_DOUBAN(1005),
        OPEN_FACEBOOK(1006),
        OPEN_TWITTER(1007),
        OPEN_GOOGLE(1008),
        OPEN_BAIDU(1009),
        OPEN_JINGDONG(1010),
        OPEN_DINGDING(1011),
        OPEN_XIAOMI(1012),
        OPEN_LINKIN(1013),
        OPEN_LINE(1014),
        OPEN_INSTAGRAM(1015),
        GUEST_MODE(2000),
        CUSTOM(2001);

        private int a;

        private AccountType(int n3) {
            this.a = n3;
        }

        public int getIntValue() {
            return this.a;
        }

        public static AccountType fromInt(int n2) {
            for (AccountType accountType : AccountType.values()) {
                if (n2 != accountType.getIntValue()) continue;
                return accountType;
            }
            return null;
        }
    }
}

