/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.mtaUtils;

import android.content.Context;
import android.util.Log;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class MTAServer {
    private static final String TAG = "MTAServer";
    private String mtaAppKey = "A3D1DC4YFR8E";
    private Context applicationContext;
    private ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal();
    private String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public String fmtTime(long secondMillis) {
        DateFormat dateFormat = this.dateFormatThreadLocal.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(this.TIME_FORMAT, Locale.ENGLISH);
            this.dateFormatThreadLocal.set(dateFormat);
        }
        return dateFormat.format(new Date(secondMillis));
    }

    public MTAServer(Context applicationContext) {
        this.applicationContext = applicationContext;
        StatConfig.setAppKey((Context)this.applicationContext, (String)this.mtaAppKey);
        StatService.setContext((Context)this.applicationContext);
        Log.d((String)TAG, (String)"MTAServer instance success");
    }

    public void reportCosXmlClientException(String key, String exceptionMessage) {
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(key).append("-").append(exceptionMessage);
        String value = stringBuffer.toString();
        properties.setProperty("ClientException", value);
        StatService.trackCustomKVEvent((Context)this.applicationContext, (String)"cos_xml_android_error", (Properties)properties);
        Log.d((String)TAG, (String)("report client exception : " + value));
    }

    public void reportCosXmlClientException(String exceptionMessage) {
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fmtTime(System.currentTimeMillis())).append("-").append(exceptionMessage);
        String value = stringBuffer.toString();
        properties.setProperty("ClientException", value);
        StatService.trackCustomKVEvent((Context)this.applicationContext, (String)"cos_xml_android_error", (Properties)properties);
        Log.d((String)TAG, (String)("report client exception : " + value));
    }

    public void reportCosXmlServerException(String key, String requestId) {
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(key).append("-").append(requestId);
        String value = stringBuffer.toString();
        properties.setProperty("ServerException", value);
        StatService.trackCustomKVEvent((Context)this.applicationContext, (String)"cos_xml_android_error", (Properties)properties);
        Log.d((String)TAG, (String)("report server exception : " + value));
    }

    public void reportCosXmlServerException(String requestId) {
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fmtTime(System.currentTimeMillis())).append("-").append(requestId);
        String value = stringBuffer.toString();
        properties.setProperty("ServerException", value);
        StatService.trackCustomKVEvent((Context)this.applicationContext, (String)"cos_xml_android_error", (Properties)properties);
        Log.d((String)TAG, (String)("report server exception : " + value));
    }
}

