/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class OcrIdCardResult
extends QImageResult {
    private int code;
    private String message;
    Map<String, FaceSideResult> faceSideResults;
    Map<String, BackSideResult> backSideResults;

    public OcrIdCardResult(int httpCode, String httpMessage, Map<String, FaceSideResult> faceSideResults, Map<String, BackSideResult> backSideResults) {
        super(httpCode, httpMessage);
        this.faceSideResults = faceSideResults;
        this.backSideResults = backSideResults;
        this.code = 0;
        this.message = "ok";
    }

    public OcrIdCardResult(int httpCode, String httpMessage, int code, String message) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
    }

    public OcrIdCardResult(int httpCode, String httpMessage, int code, String message, Map<String, FaceSideResult> faceSideResults, Map<String, BackSideResult> backSideResults) {
        super(httpCode, httpMessage);
        this.faceSideResults = faceSideResults;
        this.backSideResults = backSideResults;
        this.code = code;
        this.message = message;
    }

    public Map<String, FaceSideResult> getFaceSideResults() {
        return this.faceSideResults;
    }

    public Map<String, BackSideResult> getBackSideResults() {
        return this.backSideResults;
    }

    private static String intArray2String(int[] iArr) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < iArr.length; ++i) {
            stringBuilder.append(iArr[i]);
            if (i == iArr.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        String resultString;
        Iterator<Map.Entry<String, Object>> iterator;
        StringBuilder desc = new StringBuilder(String.format(Locale.ENGLISH, "http code = %d, http message = %s, error code = %d, error message = %s\n", this.httpCode, this.httpMessage, this.code, this.message));
        desc.append("OcrIdCardResult : \n");
        if (this.faceSideResults != null && !this.faceSideResults.isEmpty()) {
            iterator = this.faceSideResults.entrySet().iterator();
            while (iterator.hasNext()) {
                FaceSideResult faceSideResult = (FaceSideResult)iterator.next().getValue();
                resultString = faceSideResult.toString();
                desc.append(resultString + "\n");
            }
        }
        if (this.backSideResults != null && !this.backSideResults.isEmpty()) {
            iterator = this.backSideResults.entrySet().iterator();
            while (iterator.hasNext()) {
                BackSideResult backSideResult = (BackSideResult)iterator.next().getValue();
                resultString = backSideResult.toString();
                desc.append(resultString + "\n");
            }
        }
        return desc.toString();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static class BackSideResult {
        int code;
        String message;
        String key;
        String authority;
        String validDate;
        int[] authorityConfidence;
        int[] validDateConfidence;

        public BackSideResult(int code, String message, String key, String authority, String validDate, int[] authorityConfidence, int[] validDateConfidence) {
            this.code = code;
            this.message = message;
            this.key = key;
            this.authority = authority;
            this.validDate = validDate;
            this.authorityConfidence = authorityConfidence;
            this.validDateConfidence = validDateConfidence;
        }

        public BackSideResult(int code, String message, String key) {
            this(code, message, key, null, null, null, null);
        }

        public int getCode() {
            return this.code;
        }

        public String getKey() {
            return this.key;
        }

        public int[] getAuthorityConfidence() {
            return this.authorityConfidence;
        }

        public int[] getValidDateConfidence() {
            return this.validDateConfidence;
        }

        public String getAuthority() {
            return this.authority;
        }

        public String getMessage() {
            return this.message;
        }

        public String getValidDate() {
            return this.validDate;
        }

        public String toString() {
            String desc = null;
            desc = this.code == 0 ? String.format(Locale.US, "back side recognize result :\nkey = %s\ncode = %d, message = %s\nauthority = %s, valid date = %s\nauthority confidence = [%s]\nvalid date confidence = [%s]\n", this.key, this.code, this.message, this.authority, this.validDate, OcrIdCardResult.intArray2String(this.authorityConfidence), OcrIdCardResult.intArray2String(this.validDateConfidence)) : String.format(Locale.US, "back side recognize result :\nkey = %s\ncode = %d, message = %s\n", this.key, this.code, this.message);
            return desc;
        }
    }

    public static class FaceSideResult {
        int code;
        String message;
        String key;
        String name;
        String sex;
        String nation;
        String birth;
        String address;
        String id;
        int[] nameConfidence;
        int[] sexConfidence;
        int[] nationConfidence;
        int[] birthConfidence;
        int[] addressConfidence;
        int[] idConfidence;

        public FaceSideResult(int code, String message, String key, String name, String sex, String nation, String birth, String address, String id, int[] nameConfidence, int[] sexConfidence, int[] nationConfidence, int[] birthConfidence, int[] addressConfidence, int[] idConfidence) {
            this.code = code;
            this.message = message;
            this.key = key;
            this.name = name;
            this.sex = sex;
            this.nation = nation;
            this.birth = birth;
            this.address = address;
            this.id = id;
            this.nameConfidence = nameConfidence;
            this.sexConfidence = sexConfidence;
            this.nationConfidence = nationConfidence;
            this.birthConfidence = birthConfidence;
            this.addressConfidence = addressConfidence;
            this.idConfidence = idConfidence;
        }

        public FaceSideResult(int code, String message, String key) {
            this(code, message, key, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public int[] getAddressConfidence() {
            return this.addressConfidence;
        }

        public int[] getBirthConfidence() {
            return this.birthConfidence;
        }

        public int[] getIdConfidence() {
            return this.idConfidence;
        }

        public int[] getNameConfidence() {
            return this.nameConfidence;
        }

        public int[] getNationConfidence() {
            return this.nationConfidence;
        }

        public int[] getSexConfidence() {
            return this.sexConfidence;
        }

        public String getAddress() {
            return this.address;
        }

        public String getBirth() {
            return this.birth;
        }

        public String getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getNation() {
            return this.nation;
        }

        public String getSex() {
            return this.sex;
        }

        public String toString() {
            String desc = null;
            desc = this.code == 0 ? String.format(Locale.US, "face side recognize result :\nkey = %s\ncode = %d, message = %s\nname = %s, sex = %s, nation = %s, birth = %s, address = %s, id = %s\nname confidence = [%s]\nsex confidence = [%s]\nnation confidence = [%s]\nbirth confidence = [%s]\naddress confidence = [%s]\nid confidence = [%s]\n", this.key, this.code, this.message, this.name, this.sex, this.nation, this.birth, this.address, this.id, OcrIdCardResult.intArray2String(this.nameConfidence), OcrIdCardResult.intArray2String(this.sexConfidence), OcrIdCardResult.intArray2String(this.nameConfidence), OcrIdCardResult.intArray2String(this.birthConfidence), OcrIdCardResult.intArray2String(this.addressConfidence), OcrIdCardResult.intArray2String(this.idConfidence)) : String.format(Locale.US, "face side recognize result :\nkey = %s\ncode = %d, message = %s", this.key, this.code, this.message);
            return desc;
        }
    }
}

