/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services;

import android.content.Context;
import com.tencent.qcloud.image.auth.AbsCredentialProvider;
import com.tencent.qcloud.image.services.QImage;
import com.tencent.qcloud.image.services.QImageGlobalConfig;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ServerException;
import com.tencent.qcloud.image.services.model.FaceAddFaceRequest;
import com.tencent.qcloud.image.services.model.FaceAddFaceResult;
import com.tencent.qcloud.image.services.model.FaceCompareRequest;
import com.tencent.qcloud.image.services.model.FaceCompareResult;
import com.tencent.qcloud.image.services.model.FaceDeleteFaceRequest;
import com.tencent.qcloud.image.services.model.FaceDeleteFaceResult;
import com.tencent.qcloud.image.services.model.FaceDeletePersonRequest;
import com.tencent.qcloud.image.services.model.FaceDeletePersonResult;
import com.tencent.qcloud.image.services.model.FaceDetectRequest;
import com.tencent.qcloud.image.services.model.FaceDetectResult;
import com.tencent.qcloud.image.services.model.FaceGetFaceIdsRequest;
import com.tencent.qcloud.image.services.model.FaceGetFaceIdsResult;
import com.tencent.qcloud.image.services.model.FaceGetFaceInfoRequest;
import com.tencent.qcloud.image.services.model.FaceGetFaceInfoResult;
import com.tencent.qcloud.image.services.model.FaceGetGroupIdsRequest;
import com.tencent.qcloud.image.services.model.FaceGetGroupIdsResult;
import com.tencent.qcloud.image.services.model.FaceGetPersonIdsRequest;
import com.tencent.qcloud.image.services.model.FaceGetPersonIdsResult;
import com.tencent.qcloud.image.services.model.FaceGetPersonInfoRequest;
import com.tencent.qcloud.image.services.model.FaceGetPersonInfoResult;
import com.tencent.qcloud.image.services.model.FaceIdentifyRequest;
import com.tencent.qcloud.image.services.model.FaceIdentifyResult;
import com.tencent.qcloud.image.services.model.FaceNewPersonRequest;
import com.tencent.qcloud.image.services.model.FaceNewPersonResult;
import com.tencent.qcloud.image.services.model.FaceSetPersonInfoRequest;
import com.tencent.qcloud.image.services.model.FaceSetPersonInfoResult;
import com.tencent.qcloud.image.services.model.FaceShapeRequest;
import com.tencent.qcloud.image.services.model.FaceShapeResult;
import com.tencent.qcloud.image.services.model.FaceVerifyRequest;
import com.tencent.qcloud.image.services.model.FaceVerifyResult;
import com.tencent.qcloud.image.services.model.ImageTagDetectRequest;
import com.tencent.qcloud.image.services.model.ImageTagDetectResult;
import com.tencent.qcloud.image.services.model.OcrIdCardRequest;
import com.tencent.qcloud.image.services.model.OcrIdCardResult;
import com.tencent.qcloud.image.services.model.OcrNameCardRequest;
import com.tencent.qcloud.image.services.model.OcrNameCardResult;
import com.tencent.qcloud.image.services.model.PornDetectRequest;
import com.tencent.qcloud.image.services.model.PornDetectResult;
import com.tencent.qcloud.image.services.task.TaskConfig;
import com.tencent.qcloud.image.services.task.TaskManager;
import com.tencent.qcloud.image.services.task.tasks.Tasks;

public class QImageClient
implements QImage {
    Context context;
    String appid;
    AbsCredentialProvider credentialProvider;
    TaskManager taskManager;

    public QImageClient(Context context, String appid, AbsCredentialProvider credentialProvider) {
        this.context = context;
        this.appid = appid;
        this.credentialProvider = credentialProvider;
        TaskConfig taskConfig = new TaskConfig.Builder().maxConcurrentTaskNumber(QImageGlobalConfig.getMaxRequestConcurrentNumber()).httpConnectTimeout(QImageGlobalConfig.getHttpConnectTimeout()).httpReadTimeout(QImageGlobalConfig.getHttpReadTimeout()).httpWriteTimeout(QImageGlobalConfig.getHttpWriteTimeout()).isHttps(QImageGlobalConfig.isHttpsProtocol()).build();
        this.taskManager = new TaskManager(context, appid, credentialProvider, taskConfig);
    }

    public QImageClient(Context context, String appid) {
        this(context, appid, null);
    }

    @Override
    public OcrIdCardResult ocrIdCard(OcrIdCardRequest ocrIdCardRequest) throws ClientException, ServerException {
        ocrIdCardRequest.checkRequestPara();
        Tasks.OcrIdCardTask task = new Tasks.OcrIdCardTask(this.appid, ocrIdCardRequest, this.credentialProvider);
        return (OcrIdCardResult)this.taskManager.sendTask(task);
    }

    @Override
    public OcrNameCardResult ocrNameCard(OcrNameCardRequest ocrNameCardRequest) throws ClientException, ServerException {
        ocrNameCardRequest.checkRequestPara();
        Tasks.OcrNameCardTask task = new Tasks.OcrNameCardTask(this.appid, ocrNameCardRequest, this.credentialProvider);
        return (OcrNameCardResult)this.taskManager.sendTask(task);
    }

    @Override
    public PornDetectResult pornDetect(PornDetectRequest pornDetectRequest) throws ClientException, ServerException {
        pornDetectRequest.checkRequestPara();
        Tasks.PornDetectTask task = new Tasks.PornDetectTask(this.appid, pornDetectRequest, this.credentialProvider);
        return (PornDetectResult)this.taskManager.sendTask(task);
    }

    @Override
    public ImageTagDetectResult imageTagDetect(ImageTagDetectRequest imageTagDetectRequest) throws ClientException, ServerException {
        imageTagDetectRequest.checkRequestPara();
        Tasks.ImageTagDetectTask task = new Tasks.ImageTagDetectTask(this.appid, imageTagDetectRequest, this.credentialProvider);
        return (ImageTagDetectResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceNewPersonResult faceNewPerson(FaceNewPersonRequest faceNewPersonRequest) throws ClientException, ServerException {
        faceNewPersonRequest.checkRequestPara();
        Tasks.FaceNewPersonTask task = new Tasks.FaceNewPersonTask(this.appid, faceNewPersonRequest, this.credentialProvider);
        return (FaceNewPersonResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceDeletePersonResult faceDeletePerson(FaceDeletePersonRequest faceDeletePersonRequest) throws ClientException, ServerException {
        faceDeletePersonRequest.checkRequestPara();
        Tasks.FaceDeletePersonTask task = new Tasks.FaceDeletePersonTask(this.appid, faceDeletePersonRequest, this.credentialProvider);
        return (FaceDeletePersonResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceAddFaceResult faceAddFace(FaceAddFaceRequest faceAddFaceRequest) throws ClientException, ServerException {
        faceAddFaceRequest.checkRequestPara();
        Tasks.FaceAddFaceTask task = new Tasks.FaceAddFaceTask(this.appid, faceAddFaceRequest, this.credentialProvider);
        return (FaceAddFaceResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceDeleteFaceResult faceDeleteFace(FaceDeleteFaceRequest faceDeleteFaceRequest) throws ClientException, ServerException {
        faceDeleteFaceRequest.checkRequestPara();
        Tasks.FaceDeleteFaceTask task = new Tasks.FaceDeleteFaceTask(this.appid, faceDeleteFaceRequest, this.credentialProvider);
        return (FaceDeleteFaceResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceSetPersonInfoResult faceSetInfo(FaceSetPersonInfoRequest faceSetInfoRequest) throws ClientException, ServerException {
        faceSetInfoRequest.checkRequestPara();
        Tasks.FaceSetInfoTask task = new Tasks.FaceSetInfoTask(this.appid, faceSetInfoRequest, this.credentialProvider);
        return (FaceSetPersonInfoResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceGetPersonInfoResult faceGetInfo(FaceGetPersonInfoRequest faceGetInfoRequest) throws ClientException, ServerException {
        faceGetInfoRequest.checkRequestPara();
        Tasks.FaceGetInfoTask task = new Tasks.FaceGetInfoTask(this.appid, faceGetInfoRequest, this.credentialProvider);
        return (FaceGetPersonInfoResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceGetGroupIdsResult faceGetGroupIds(FaceGetGroupIdsRequest faceGetGroupIdsRequest) throws ClientException, ServerException {
        faceGetGroupIdsRequest.checkRequestPara();
        Tasks.FaceGetGroupIdsTask task = new Tasks.FaceGetGroupIdsTask(this.appid, faceGetGroupIdsRequest, this.credentialProvider);
        return (FaceGetGroupIdsResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceGetPersonIdsResult faceGetPersonIds(FaceGetPersonIdsRequest faceGetPersonIdsRequest) throws ClientException, ServerException {
        faceGetPersonIdsRequest.checkRequestPara();
        Tasks.FaceGetPersonIdsTask task = new Tasks.FaceGetPersonIdsTask(this.appid, faceGetPersonIdsRequest, this.credentialProvider);
        return (FaceGetPersonIdsResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceGetFaceIdsResult faceGetFaceIds(FaceGetFaceIdsRequest faceGetFaceIdsRequest) throws ClientException, ServerException {
        faceGetFaceIdsRequest.checkRequestPara();
        Tasks.FaceGetFaceIdsTask task = new Tasks.FaceGetFaceIdsTask(this.appid, faceGetFaceIdsRequest, this.credentialProvider);
        return (FaceGetFaceIdsResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceGetFaceInfoResult faceGetFaceInfo(FaceGetFaceInfoRequest faceGetFaceInfoRequest) throws ClientException, ServerException {
        faceGetFaceInfoRequest.checkRequestPara();
        Tasks.FaceGetFaceInfoTask task = new Tasks.FaceGetFaceInfoTask(this.appid, faceGetFaceInfoRequest, this.credentialProvider);
        return (FaceGetFaceInfoResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceDetectResult faceDetect(FaceDetectRequest faceDetectRequest) throws ClientException, ServerException {
        faceDetectRequest.checkRequestPara();
        Tasks.FaceDetectTask task = new Tasks.FaceDetectTask(this.appid, faceDetectRequest, this.credentialProvider);
        return (FaceDetectResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceShapeResult faceShape(FaceShapeRequest faceShapeRequest) throws ClientException, ServerException {
        faceShapeRequest.checkRequestPara();
        Tasks.FaceShapeTask task = new Tasks.FaceShapeTask(this.appid, faceShapeRequest, this.credentialProvider);
        return (FaceShapeResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceCompareResult faceCompare(FaceCompareRequest faceCompareRequest) throws ClientException, ServerException {
        faceCompareRequest.checkRequestPara();
        Tasks.FaceCompareTask task = new Tasks.FaceCompareTask(this.appid, faceCompareRequest, this.credentialProvider);
        return (FaceCompareResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceIdentifyResult faceIdentify(FaceIdentifyRequest faceIdentifyRequest) throws ClientException, ServerException {
        faceIdentifyRequest.checkRequestPara();
        Tasks.FaceIdentifyTask task = new Tasks.FaceIdentifyTask(this.appid, faceIdentifyRequest, this.credentialProvider);
        return (FaceIdentifyResult)this.taskManager.sendTask(task);
    }

    @Override
    public FaceVerifyResult faceVerify(FaceVerifyRequest faceVerifyRequest) throws ClientException, ServerException {
        faceVerifyRequest.checkRequestPara();
        Tasks.FaceVerifyTask task = new Tasks.FaceVerifyTask(this.appid, faceVerifyRequest, this.credentialProvider);
        return (FaceVerifyResult)this.taskManager.sendTask(task);
    }

    @Override
    public boolean cancel(int requestId) {
        return this.taskManager.cancelTask(requestId);
    }

    @Override
    public void cancelAll() {
        this.taskManager.cancelAllTask();
    }

    @Override
    public void release() {
        this.taskManager.release();
    }
}

