/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.task.parser.model;

import com.tencent.qcloud.image.services.exception.ServerException;
import com.tencent.qcloud.image.services.exception.ServerExceptionType;
import com.tencent.qcloud.image.services.model.FaceAddFaceResult;
import com.tencent.qcloud.image.services.model.FaceCompareResult;
import com.tencent.qcloud.image.services.model.FaceDeleteFaceResult;
import com.tencent.qcloud.image.services.model.FaceDeletePersonResult;
import com.tencent.qcloud.image.services.model.FaceDetectResult;
import com.tencent.qcloud.image.services.model.FaceGetFaceIdsResult;
import com.tencent.qcloud.image.services.model.FaceGetFaceInfoResult;
import com.tencent.qcloud.image.services.model.FaceGetGroupIdsResult;
import com.tencent.qcloud.image.services.model.FaceGetPersonIdsResult;
import com.tencent.qcloud.image.services.model.FaceGetPersonInfoResult;
import com.tencent.qcloud.image.services.model.FaceIdentifyResult;
import com.tencent.qcloud.image.services.model.FaceNewPersonResult;
import com.tencent.qcloud.image.services.model.FaceSetPersonInfoResult;
import com.tencent.qcloud.image.services.model.FaceShapeResult;
import com.tencent.qcloud.image.services.model.FaceVerifyResult;
import com.tencent.qcloud.image.services.model.ImageTagDetectResult;
import com.tencent.qcloud.image.services.model.OcrIdCardResult;
import com.tencent.qcloud.image.services.model.OcrNameCardResult;
import com.tencent.qcloud.image.services.model.PornDetectResult;
import com.tencent.qcloud.image.services.task.parser.model.ResponseParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseParsers {
    static final Logger logger = LoggerFactory.getLogger(ResponseParsers.class);

    public static final class FaceVerifyResultParser
    implements ResponseParser<FaceVerifyResult> {
        Logger logger = LoggerFactory.getLogger(FaceIdentifyResultParser.class);

        @Override
        public FaceVerifyResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceVerifyResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = null;
                float confidence = 0.0f;
                boolean isMatch = false;
                if (data != null) {
                    sessionId = data.getString("session_id");
                    confidence = (float)data.getDouble("confidence");
                    isMatch = data.getBoolean("ismatch");
                }
                return new FaceVerifyResult(httpCode, httpMessage, code, message, sessionId, isMatch, confidence);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceIdentifyResultParser
    implements ResponseParser<FaceIdentifyResult> {
        Logger logger = LoggerFactory.getLogger(FaceIdentifyResultParser.class);

        @Override
        public FaceIdentifyResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceIdentifyResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                JSONArray candidatesArray = data.getJSONArray("candidates");
                LinkedList<FaceIdentifyResult.IdentifyItem> candidates = new LinkedList<FaceIdentifyResult.IdentifyItem>();
                for (int i = 0; i < candidatesArray.length(); ++i) {
                    JSONObject item = candidatesArray.getJSONObject(i);
                    String personId = item.getString("person_id");
                    String faceId = item.getString("face_id");
                    double confidence = item.getDouble("confidence");
                    String tag = item.getString("tag");
                    candidates.add(new FaceIdentifyResult.IdentifyItem(personId, faceId, confidence, tag));
                }
                return new FaceIdentifyResult(httpCode, httpMessage, code, message, sessionId, candidates);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceCompareResultParser
    implements ResponseParser<FaceCompareResult> {
        @Override
        public FaceCompareResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                String sessionId = null;
                double similarity = 0.0;
                int failFlag = -1;
                if (jsonObject.has("data")) {
                    JSONObject data = jsonObject.getJSONObject("data");
                    if (data.has("session_id")) {
                        sessionId = data.getString("session_id");
                    }
                    if (data.has("similarity")) {
                        similarity = data.getDouble("similarity");
                    }
                    if (data.has("fail_flag")) {
                        failFlag = data.getInt("fail_flag");
                    }
                }
                return new FaceCompareResult(httpCode, httpMessage, code, message, sessionId, similarity, failFlag);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceShapeResultParser
    implements ResponseParser<FaceShapeResult> {
        Logger logger = LoggerFactory.getLogger(FaceShapeResultParser.class);

        @Override
        public FaceShapeResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceShapeResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                int imageWidth = data.getInt("image_width");
                int imageHeight = data.getInt("image_height");
                JSONArray faceShapeArray = data.getJSONArray("face_shape");
                LinkedList<FaceShapeResult.FaceShape> faceShapes = new LinkedList<FaceShapeResult.FaceShape>();
                for (int i = 0; i < faceShapeArray.length(); ++i) {
                    JSONObject faceShape = faceShapeArray.getJSONObject(i);
                    JSONArray faceProfileArray = faceShape.getJSONArray("face_profile");
                    JSONArray leftEyeArray = faceShape.getJSONArray("left_eye");
                    JSONArray rightEyeArray = faceShape.getJSONArray("right_eye");
                    JSONArray leftEyeBrowArray = faceShape.getJSONArray("left_eyebrow");
                    JSONArray rightEyeBrowArray = faceShape.getJSONArray("right_eyebrow");
                    JSONArray mouthArray = faceShape.getJSONArray("mouth");
                    JSONArray noseArray = faceShape.getJSONArray("nose");
                    faceShapes.add(new FaceShapeResult.FaceShape(this.jsonArray2List(faceProfileArray), this.jsonArray2List(leftEyeArray), this.jsonArray2List(rightEyeArray), this.jsonArray2List(leftEyeBrowArray), this.jsonArray2List(rightEyeBrowArray), this.jsonArray2List(mouthArray), this.jsonArray2List(noseArray)));
                }
                return new FaceShapeResult(httpCode, httpMessage, code, message, sessionId, imageWidth, imageHeight, faceShapes);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }

        private List<FaceShapeResult.Point> jsonArray2List(JSONArray jsonArray) throws JSONException {
            LinkedList<FaceShapeResult.Point> points = new LinkedList<FaceShapeResult.Point>();
            if (jsonArray != null && jsonArray.length() > 0) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonPoint = jsonArray.getJSONObject(i);
                    points.add(new FaceShapeResult.Point(jsonPoint.getInt("x"), jsonPoint.getInt("y")));
                }
            }
            return points;
        }
    }

    public static final class FaceDetectResultParser
    implements ResponseParser<FaceDetectResult> {
        @Override
        public FaceDetectResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceDetectResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                int imageWidth = data.getInt("image_width");
                int imageHeight = data.getInt("image_height");
                LinkedList<FaceDetectResult.FaceItem> faceIdList = new LinkedList<FaceDetectResult.FaceItem>();
                JSONArray faces = data.getJSONArray("face");
                for (int i = 0; i < faces.length(); ++i) {
                    JSONObject face = faces.getJSONObject(i);
                    String faceId = face.getString("face_id");
                    int x = face.getInt("x");
                    int y = face.getInt("y");
                    double width = face.getDouble("width");
                    double height = face.getDouble("height");
                    int pitch = face.getInt("pitch");
                    int roll = face.getInt("roll");
                    int yaw = face.getInt("yaw");
                    int age = face.getInt("age");
                    int gender = face.getInt("gender");
                    boolean glass = face.getBoolean("glass");
                    int expression = face.getInt("expression");
                    int beauty = face.getInt("beauty");
                    faceIdList.add(new FaceDetectResult.FaceItem(faceId, x, y, width, height, gender, age, expression, glass, pitch, yaw, roll, beauty));
                }
                return new FaceDetectResult(httpCode, httpMessage, code, message, sessionId, imageWidth, imageHeight, faceIdList);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceGetFaceInfoResultParser
    implements ResponseParser<FaceGetFaceInfoResult> {
        @Override
        public FaceGetFaceInfoResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceGetFaceInfoResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                JSONObject faceInfo = data.getJSONObject("face_info");
                String faceId = faceInfo.getString("face_id");
                int x = faceInfo.getInt("x");
                int y = faceInfo.getInt("y");
                double width = faceInfo.getDouble("width");
                double height = faceInfo.getDouble("height");
                int gender = faceInfo.getInt("gender");
                int age = faceInfo.getInt("age");
                int expression = faceInfo.getInt("expression");
                boolean glass = faceInfo.getBoolean("glass");
                int pitch = faceInfo.getInt("pitch");
                int yaw = faceInfo.getInt("yaw");
                int roll = faceInfo.getInt("roll");
                FaceGetFaceInfoResult.FaceItem face = new FaceGetFaceInfoResult.FaceItem(faceId, x, y, width, height, gender, age, expression, glass, pitch, yaw, roll);
                return new FaceGetFaceInfoResult(httpCode, httpMessage, code, message, face);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceGetFaceIdsResultParser
    implements ResponseParser<FaceGetFaceIdsResult> {
        @Override
        public FaceGetFaceIdsResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceGetFaceIdsResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                LinkedList<String> faceIdList = new LinkedList<String>();
                JSONArray groupIds = data.getJSONArray("face_ids");
                for (int i = 0; i < groupIds.length(); ++i) {
                    faceIdList.add(groupIds.getString(i));
                }
                return new FaceGetFaceIdsResult(httpCode, httpMessage, code, message, faceIdList);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceGetPersonIdsResultParser
    implements ResponseParser<FaceGetPersonIdsResult> {
        @Override
        public FaceGetPersonIdsResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceGetPersonIdsResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                LinkedList<String> personIdList = new LinkedList<String>();
                JSONArray groupIds = data.getJSONArray("person_ids");
                for (int i = 0; i < groupIds.length(); ++i) {
                    personIdList.add(groupIds.getString(i));
                }
                return new FaceGetPersonIdsResult(httpCode, httpMessage, code, message, personIdList);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceGetGroupIdsResultParser
    implements ResponseParser<FaceGetGroupIdsResult> {
        @Override
        public FaceGetGroupIdsResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceGetGroupIdsResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                LinkedList<String> groupIdList = new LinkedList<String>();
                JSONArray groupIds = data.getJSONArray("group_ids");
                for (int i = 0; i < groupIds.length(); ++i) {
                    groupIdList.add(groupIds.getString(i));
                }
                return new FaceGetGroupIdsResult(httpCode, httpMessage, code, message, groupIdList);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceGetInfoResultParser
    implements ResponseParser<FaceGetPersonInfoResult> {
        @Override
        public FaceGetPersonInfoResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceGetPersonInfoResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String personName = data.getString("person_name");
                String personId = data.getString("person_id");
                String sessionId = data.getString("session_id");
                String tag = data.getString("tag");
                LinkedList<String> faceIdList = new LinkedList<String>();
                JSONArray faceIds = data.getJSONArray("face_ids");
                for (int i = 0; i < faceIds.length(); ++i) {
                    faceIdList.add(faceIds.getString(i));
                }
                LinkedList<String> groupIdList = new LinkedList<String>();
                JSONArray groupIds = data.getJSONArray("group_ids");
                for (int i = 0; i < groupIds.length(); ++i) {
                    groupIdList.add(groupIds.getString(i));
                }
                return new FaceGetPersonInfoResult(httpCode, httpMessage, code, message, personName, personId, faceIdList, groupIdList, sessionId, tag);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceSetInfoResultParser
    implements ResponseParser<FaceSetPersonInfoResult> {
        @Override
        public FaceSetPersonInfoResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceSetPersonInfoResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                String personId = data.getString("person_id");
                return new FaceSetPersonInfoResult(httpCode, httpMessage, code, message, sessionId, personId);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceDeleteFaceResultParser
    implements ResponseParser<FaceDeleteFaceResult> {
        @Override
        public FaceDeleteFaceResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceDeleteFaceResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                int deletedNumber = data.getInt("deleted");
                LinkedList<String> faceIdList = new LinkedList<String>();
                JSONArray faceIds = data.getJSONArray("face_ids");
                for (int i = 0; i < faceIds.length(); ++i) {
                    faceIdList.add(faceIds.getString(i));
                }
                return new FaceDeleteFaceResult(httpCode, httpMessage, code, message, sessionId, deletedNumber, faceIdList);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceAddFaceResultParser
    implements ResponseParser<FaceAddFaceResult> {
        @Override
        public FaceAddFaceResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                int i;
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceAddFaceResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                int added = data.getInt("added");
                LinkedList<String> faceIdList = new LinkedList<String>();
                LinkedList<Integer> codeList = new LinkedList<Integer>();
                JSONArray faceIds = data.getJSONArray("face_ids");
                JSONArray retCodes = data.getJSONArray("ret_codes");
                for (i = 0; i < faceIds.length(); ++i) {
                    faceIdList.add(faceIds.getString(i));
                }
                for (i = 0; i < retCodes.length(); ++i) {
                    codeList.add(new Integer(retCodes.getInt(i)));
                }
                return new FaceAddFaceResult(httpCode, httpMessage, code, message, sessionId, added, faceIdList, codeList);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceDeletePersonResultParser
    implements ResponseParser<FaceDeletePersonResult> {
        @Override
        public FaceDeletePersonResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceDeletePersonResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                String personId = data.getString("person_id");
                int deleted = data.getInt("deleted");
                return new FaceDeletePersonResult(httpCode, httpMessage, code, message, sessionId, personId, deleted);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class FaceNewPersonResultParser
    implements ResponseParser<FaceNewPersonResult> {
        @Override
        public FaceNewPersonResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                int code = jsonObject.getInt("code");
                String message = jsonObject.getString("message");
                if (code != 0) {
                    return new FaceNewPersonResult(httpCode, httpMessage, code, message);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                String sessionId = data.getString("session_id");
                int successGroup = data.getInt("suc_group");
                int successFace = data.getInt("suc_face");
                String personId = data.getString("person_id");
                String faceId = data.getString("face_id");
                JSONArray jsonArray = data.getJSONArray("group_ids");
                LinkedList<String> groupIds = new LinkedList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    groupIds.add(jsonArray.getString(i));
                }
                return new FaceNewPersonResult(httpCode, httpMessage, code, message, sessionId, successGroup, successFace, personId, faceId, groupIds);
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
        }
    }

    public static final class ImageTagDetectResultParser
    implements ResponseParser<ImageTagDetectResult> {
        @Override
        public ImageTagDetectResult parse(Response response) throws ServerException {
            LinkedList<ImageTagDetectResult.ImageTagResult> imageTagResults;
            String message;
            int code;
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                code = jsonObject.getInt("code");
                message = jsonObject.getString("message");
                if (code != 0) {
                    return new ImageTagDetectResult(httpCode, httpMessage, code, message);
                }
                imageTagResults = new LinkedList<ImageTagDetectResult.ImageTagResult>();
                JSONArray jsonArray = jsonObject.getJSONArray("tags");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject item = jsonArray.getJSONObject(i);
                    String tagName = item.getString("tag_name");
                    int tagConfidence = item.getInt("tag_confidence");
                    imageTagResults.add(new ImageTagDetectResult.ImageTagResult(tagName, tagConfidence));
                }
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
            return new ImageTagDetectResult(httpCode, httpMessage, code, message, imageTagResults);
        }
    }

    public static final class PornDetectResultParser
    implements ResponseParser<PornDetectResult> {
        @Override
        public PornDetectResult parse(Response response) throws ServerException {
            HashMap<String, PornDetectResult.PornResult> pornResults;
            String errorMessage;
            int errorCode;
            String httpMessage;
            int httpCode;
            block8: {
                if (response == null || response.body() == null) {
                    throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
                }
                httpCode = response.code();
                httpMessage = response.message();
                errorCode = 0;
                errorMessage = "ok";
                pornResults = new HashMap<String, PornDetectResult.PornResult>();
                try {
                    JSONObject jsonObject = new JSONObject(response.body().string());
                    errorCode = jsonObject.optInt("code", 0);
                    errorMessage = jsonObject.optString("message", "ok");
                    JSONArray jsonArray = jsonObject.optJSONArray("result_list");
                    if (jsonArray == null) break block8;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String key;
                        JSONObject item = jsonArray.getJSONObject(i);
                        int code = item.getInt("code");
                        String message = item.getString("message");
                        try {
                            key = item.getString("url");
                        }
                        catch (JSONException e) {
                            key = item.getString("filename");
                        }
                        if (code != 0) {
                            pornResults.put(key, new PornDetectResult.PornResult(code, message, key));
                            continue;
                        }
                        JSONObject data = item.getJSONObject("data");
                        int result = data.getInt("result");
                        double confidence = data.getDouble("confidence");
                        double normalScore = data.getDouble("normal_score");
                        double hotScore = data.getDouble("hot_score");
                        double pornScore = data.getDouble("porn_score");
                        int forbidStatus = data.getInt("forbid_status");
                        PornDetectResult.PornResult pornResult = new PornDetectResult.PornResult(code, message, key, result, confidence, normalScore, hotScore, pornScore, forbidStatus);
                        pornResults.put(key, pornResult);
                    }
                }
                catch (JSONException e) {
                    throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
                }
                catch (IOException e) {
                    throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
                }
            }
            return new PornDetectResult(httpCode, httpMessage, errorCode, errorMessage, pornResults);
        }
    }

    public static final class OcrNameCardResultParser
    implements ResponseParser<OcrNameCardResult> {
        private final boolean retImage;

        public OcrNameCardResultParser(boolean retImage) {
            this.retImage = retImage;
        }

        @Override
        public OcrNameCardResult parse(Response response) throws ServerException {
            HashMap<String, OcrNameCardResult.NameCardResult> nameCardResults;
            String errorMessage;
            int errorCode;
            String httpMessage;
            int httpCode;
            block9: {
                if (response == null || response.body() == null) {
                    throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
                }
                httpCode = response.code();
                httpMessage = response.message();
                errorCode = 0;
                errorMessage = "ok";
                nameCardResults = new HashMap<String, OcrNameCardResult.NameCardResult>();
                try {
                    JSONObject jsonObject = new JSONObject(response.body().string());
                    JSONArray jsonArray = jsonObject.optJSONArray("result_list");
                    errorCode = jsonObject.optInt("code", 0);
                    errorMessage = jsonObject.optString("message", "ok");
                    if (jsonArray == null) break block9;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String key;
                        JSONObject item = jsonArray.getJSONObject(i);
                        int code = item.getInt("code");
                        String message = item.getString("message");
                        try {
                            key = item.getString("url");
                        }
                        catch (JSONException e) {
                            key = item.getString("filename");
                        }
                        if (code != 0) {
                            nameCardResults.put(key, new OcrNameCardResult.NameCardResult(code, message, key));
                            continue;
                        }
                        JSONObject data = item.getJSONObject("data");
                        String name = data.getString("name");
                        String phone = data.getString("phone");
                        String uin = data.getString("uin");
                        double nameConfidence = data.getDouble("name_confidence");
                        double phoneConfidence = data.getDouble("phone_confidence");
                        double uinConfidence = data.getDouble("uin_confidence");
                        String imageBase64 = null;
                        if (this.retImage) {
                            imageBase64 = data.getString("image");
                        }
                        OcrNameCardResult.NameCardResult nameCardResult = new OcrNameCardResult.NameCardResult(code, message, key, name, phone, uin, nameConfidence, phoneConfidence, uinConfidence, imageBase64);
                        nameCardResults.put(key, nameCardResult);
                    }
                }
                catch (JSONException e) {
                    throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_RESULT_FAILED);
                }
                catch (IOException e) {
                    throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
                }
            }
            return new OcrNameCardResult(httpCode, httpMessage, errorCode, errorMessage, nameCardResults);
        }
    }

    public static final class OcrIdCardResultParser
    implements ResponseParser<OcrIdCardResult> {
        private final boolean isFaceSide;

        public OcrIdCardResultParser(boolean isFaceSide) {
            this.isFaceSide = isFaceSide;
        }

        @Override
        public OcrIdCardResult parse(Response response) throws ServerException {
            if (response == null || response.body() == null) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_NULL);
            }
            int httpCode = response.code();
            String httpMessage = response.message();
            int code = 0;
            String message = "ok";
            Map<String, OcrIdCardResult.FaceSideResult> faceSideResults = null;
            Map<String, OcrIdCardResult.BackSideResult> backSideResults = null;
            try {
                JSONObject jsonObject = new JSONObject(response.body().string());
                code = jsonObject.optInt("code", 0);
                message = jsonObject.optString("message", "ok");
                if (this.isFaceSide) {
                    faceSideResults = this.faceSideResult(jsonObject);
                } else {
                    backSideResults = this.backSideResult(jsonObject);
                }
            }
            catch (JSONException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
            catch (IOException e) {
                throw new ServerException(ServerExceptionType.HTTP_BODY_TRANSFER_TO_JSON_FAILED);
            }
            return new OcrIdCardResult(httpCode, httpMessage, code, message, faceSideResults, backSideResults);
        }

        private int[] getConfidenceArray(JSONArray jsonArray) throws JSONException {
            if (jsonArray == null) {
                return null;
            }
            int size = jsonArray.length();
            int[] confidence = new int[size];
            for (int i = 0; i < confidence.length; ++i) {
                confidence[i] = jsonArray.getInt(i);
            }
            return confidence;
        }

        private Map<String, OcrIdCardResult.FaceSideResult> faceSideResult(JSONObject jsonObject) {
            HashMap<String, OcrIdCardResult.FaceSideResult> resultMap = new HashMap<String, OcrIdCardResult.FaceSideResult>();
            try {
                JSONArray jsonArray = jsonObject.optJSONArray("result_list");
                if (jsonArray == null) {
                    return null;
                }
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String key;
                    JSONObject item = jsonArray.getJSONObject(i);
                    int code = item.getInt("code");
                    String message = item.getString("message");
                    try {
                        key = item.getString("url");
                    }
                    catch (JSONException e) {
                        key = item.getString("filename");
                    }
                    if (code != 0) {
                        resultMap.put(key, new OcrIdCardResult.FaceSideResult(code, message, key));
                        continue;
                    }
                    JSONObject data = item.getJSONObject("data");
                    String name = data.getString("name");
                    String sex = data.getString("sex");
                    String nation = data.getString("nation");
                    String birth = data.getString("birth");
                    String address = data.getString("address");
                    String id = data.getString("id");
                    int[] nameConfidence = this.getConfidenceArray(data.getJSONArray("name_confidence_all"));
                    int[] sexConfidence = this.getConfidenceArray(data.getJSONArray("sex_confidence_all"));
                    int[] nationConfidence = this.getConfidenceArray(data.getJSONArray("nation_confidence_all"));
                    int[] birthConfidence = this.getConfidenceArray(data.getJSONArray("birth_confidence_all"));
                    int[] addressConfidence = this.getConfidenceArray(data.getJSONArray("address_confidence_all"));
                    int[] idConfidence = this.getConfidenceArray(data.getJSONArray("id_confidence_all"));
                    OcrIdCardResult.FaceSideResult faceSideResult = new OcrIdCardResult.FaceSideResult(code, message, key, name, sex, nation, birth, address, id, nameConfidence, sexConfidence, nationConfidence, birthConfidence, addressConfidence, idConfidence);
                    resultMap.put(key, faceSideResult);
                }
            }
            catch (JSONException e) {
                return null;
            }
            return resultMap;
        }

        private Map<String, OcrIdCardResult.BackSideResult> backSideResult(JSONObject jsonObject) {
            HashMap<String, OcrIdCardResult.BackSideResult> resultMap = new HashMap<String, OcrIdCardResult.BackSideResult>();
            try {
                JSONArray jsonArray = jsonObject.optJSONArray("result_list");
                if (jsonArray == null) {
                    return null;
                }
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String key;
                    JSONObject item = jsonArray.getJSONObject(i);
                    int code = item.getInt("code");
                    String message = item.getString("message");
                    try {
                        key = item.getString("url");
                    }
                    catch (JSONException e) {
                        key = item.getString("filename");
                    }
                    if (code != 0) {
                        resultMap.put(key, new OcrIdCardResult.BackSideResult(code, message, key));
                        continue;
                    }
                    JSONObject data = item.getJSONObject("data");
                    String authority = data.getString("authority");
                    String validDate = data.getString("valid_date");
                    int[] authorityConfidence = this.getConfidenceArray(data.getJSONArray("authority_confidence_all"));
                    int[] validDateConfidence = this.getConfidenceArray(data.getJSONArray("valid_date_confidence_all"));
                    OcrIdCardResult.BackSideResult backSideResult = new OcrIdCardResult.BackSideResult(code, message, key, authority, validDate, authorityConfidence, validDateConfidence);
                    resultMap.put(key, backSideResult);
                }
            }
            catch (JSONException e) {
                return null;
            }
            return resultMap;
        }
    }
}

