/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.task.parser.model;

import android.text.TextUtils;
import android.util.Base64;
import com.tencent.qcloud.image.log.QLogger;
import com.tencent.qcloud.image.net.RequestMessage;
import com.tencent.qcloud.image.net.body.FileRequestBody;
import com.tencent.qcloud.image.services.common.MimeType;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.FaceAddFaceRequest;
import com.tencent.qcloud.image.services.model.FaceCompareRequest;
import com.tencent.qcloud.image.services.model.FaceDeleteFaceRequest;
import com.tencent.qcloud.image.services.model.FaceDeletePersonRequest;
import com.tencent.qcloud.image.services.model.FaceDetectRequest;
import com.tencent.qcloud.image.services.model.FaceGetFaceIdsRequest;
import com.tencent.qcloud.image.services.model.FaceGetFaceInfoRequest;
import com.tencent.qcloud.image.services.model.FaceGetGroupIdsRequest;
import com.tencent.qcloud.image.services.model.FaceGetPersonIdsRequest;
import com.tencent.qcloud.image.services.model.FaceGetPersonInfoRequest;
import com.tencent.qcloud.image.services.model.FaceIdentifyRequest;
import com.tencent.qcloud.image.services.model.FaceNewPersonRequest;
import com.tencent.qcloud.image.services.model.FaceSetPersonInfoRequest;
import com.tencent.qcloud.image.services.model.FaceShapeRequest;
import com.tencent.qcloud.image.services.model.FaceVerifyRequest;
import com.tencent.qcloud.image.services.model.ImageTagDetectRequest;
import com.tencent.qcloud.image.services.model.OcrIdCardRequest;
import com.tencent.qcloud.image.services.model.OcrNameCardRequest;
import com.tencent.qcloud.image.services.model.PornDetectRequest;
import com.tencent.qcloud.image.services.task.parser.model.RequestParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParsers {

    public static class FaceVerifyRequestParser
    implements RequestParser<FaceVerifyRequest> {
        @Override
        public RequestMessage parse(FaceVerifyRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            String imageUrl = request.getImageUrl();
            File imageFile = request.getImageFile();
            String personId = request.getPersonId();
            if (TextUtils.isEmpty((CharSequence)personId)) {
                throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
            }
            if (TextUtils.isEmpty((CharSequence)imageUrl) && (imageFile == null || !imageFile.exists())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    jsonObject.put("person_id", (Object)personId);
                    jsonObject.put("url", (Object)imageUrl);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (imageFile != null && imageFile.exists()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                multipartBuilder.addFormDataPart("person_id", personId);
                multipartBuilder.addFormDataPart("image", imageFile.getName(), (RequestBody)new FileRequestBody(imageFile, MimeType.getTypeByFileName(imageFile.getName())));
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class FaceIdentifyRequestParser
    implements RequestParser<FaceIdentifyRequest> {
        @Override
        public RequestMessage parse(FaceIdentifyRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            String imageUrl = request.getImageUrl();
            File imageFile = request.getImageFile();
            String groupId = request.getGroupId();
            if (TextUtils.isEmpty((CharSequence)groupId)) {
                throw new ClientException(ClientExceptionType.GROUP_ID_NULL);
            }
            if (TextUtils.isEmpty((CharSequence)imageUrl) && (imageFile == null || !imageFile.exists())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    jsonObject.put("group_id", (Object)groupId);
                    jsonObject.put("url", (Object)imageUrl);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (imageFile != null && imageFile.exists()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                multipartBuilder.addFormDataPart("group_id", groupId);
                multipartBuilder.addFormDataPart("image", imageFile.getName(), (RequestBody)new FileRequestBody(imageFile, MimeType.getTypeByFileName(imageFile.getName())));
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class FaceCompareRequestParser
    implements RequestParser<FaceCompareRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceDetectRequestParser.class);

        @Override
        public RequestMessage parse(FaceCompareRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            String imageUrl1 = request.getImageUrl1();
            String imageUrl2 = request.getImageUrl2();
            File imageFile1 = request.getImageFile1();
            File imageFile2 = request.getImageFile2();
            RequestMessage requestMessage = null;
            if (!TextUtils.isEmpty((CharSequence)imageUrl1) && !TextUtils.isEmpty((CharSequence)imageUrl2)) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    jsonObject.put("urlA", (Object)imageUrl1);
                    jsonObject.put("urlB", (Object)imageUrl2);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (imageFile1 != null && imageFile1.exists() && imageFile2 != null && imageFile2.exists()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                multipartBuilder.addFormDataPart("imageA", imageFile1.getName(), (RequestBody)new FileRequestBody(imageFile1, MimeType.getTypeByFileName(imageFile1.getName())));
                multipartBuilder.addFormDataPart("imageB", imageFile2.getName(), (RequestBody)new FileRequestBody(imageFile2, MimeType.getTypeByFileName(imageFile2.getName())));
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class FaceShapeRequestParser
    implements RequestParser<FaceShapeRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceDetectRequestParser.class);

        @Override
        public RequestMessage parse(FaceShapeRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            String imageUrl = request.getImageUrl();
            File imageFile = request.getImageFile();
            int mode = request.getMode();
            if (mode != 0 && mode != 1) {
                throw new ClientException(ClientExceptionType.UNSUPPORTED_DETECT_MODE);
            }
            if (TextUtils.isEmpty((CharSequence)imageUrl) && (imageFile == null || !imageFile.exists())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    jsonObject.put("mode", mode);
                    jsonObject.put("url", (Object)imageUrl);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (imageFile != null && imageFile.exists()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                multipartBuilder.addFormDataPart("mode", String.valueOf(mode));
                multipartBuilder.addFormDataPart("image", imageFile.getName(), (RequestBody)new FileRequestBody(imageFile, MimeType.getTypeByFileName(imageFile.getName())));
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class FaceDetectRequestParser
    implements RequestParser<FaceDetectRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceDetectRequestParser.class);

        @Override
        public RequestMessage parse(FaceDetectRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            String imageUrl = request.getImageUrl();
            File imageFile = request.getImageFile();
            int mode = request.getMode();
            if (mode != 0 && mode != 1) {
                throw new ClientException(ClientExceptionType.UNSUPPORTED_DETECT_MODE);
            }
            if (TextUtils.isEmpty((CharSequence)imageUrl) && (imageFile == null || !imageFile.exists())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    jsonObject.put("mode", mode);
                    jsonObject.put("url", (Object)imageUrl);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (imageFile != null && imageFile.exists()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                multipartBuilder.addFormDataPart("mode", String.valueOf(mode));
                multipartBuilder.addFormDataPart("image", imageFile.getName(), (RequestBody)new FileRequestBody(imageFile, MimeType.getTypeByFileName(imageFile.getName())));
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class FaceGetFaceInfoRequestParser
    implements RequestParser<FaceGetFaceInfoRequest> {
        @Override
        public RequestMessage parse(FaceGetFaceInfoRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            if (TextUtils.isEmpty((CharSequence)request.getFaceId())) {
                throw new ClientException(ClientExceptionType.FACE_ID_IS_EMPTY);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                jsonObject.put("face_id", (Object)request.getFaceId());
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceGetFaceIdsRequestParser
    implements RequestParser<FaceGetFaceIdsRequest> {
        @Override
        public RequestMessage parse(FaceGetFaceIdsRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            if (TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                jsonObject.put("person_id", (Object)request.getPersonId());
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceGetPersonIdsRequestParser
    implements RequestParser<FaceGetPersonIdsRequest> {
        @Override
        public RequestMessage parse(FaceGetPersonIdsRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            if (TextUtils.isEmpty((CharSequence)request.getGroupId())) {
                throw new ClientException(ClientExceptionType.GROUP_ID_NULL);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                jsonObject.put("group_id", (Object)request.getGroupId());
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceGetGroupIdsRequestParser
    implements RequestParser<FaceGetGroupIdsRequest> {
        @Override
        public RequestMessage parse(FaceGetGroupIdsRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceGetInfoRequestParser
    implements RequestParser<FaceGetPersonInfoRequest> {
        @Override
        public RequestMessage parse(FaceGetPersonInfoRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                if (!TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                    jsonObject.put("person_id", (Object)request.getPersonId());
                }
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceSetInfoRequestParser
    implements RequestParser<FaceSetPersonInfoRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceDeleteFaceRequestParser.class);

        @Override
        public RequestMessage parse(FaceSetPersonInfoRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                if (!TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                    jsonObject.put("person_id", (Object)request.getPersonId());
                }
                if (!TextUtils.isEmpty((CharSequence)request.getPersonName())) {
                    jsonObject.put("person_name", (Object)request.getPersonName());
                }
                if (!TextUtils.isEmpty((CharSequence)request.getTag())) {
                    jsonObject.put("tag", (Object)request.getTag());
                }
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceDeleteFaceRequestParser
    implements RequestParser<FaceDeleteFaceRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceDeleteFaceRequestParser.class);

        @Override
        public RequestMessage parse(FaceDeleteFaceRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                if (!TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                    jsonObject.put("person_id", (Object)request.getPersonId());
                }
                JSONArray faceIds = new JSONArray(request.getFaceIds());
                jsonObject.put("face_ids", (Object)faceIds);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceAddFaceRequestParser
    implements RequestParser<FaceAddFaceRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceAddFaceRequestParser.class);

        @Override
        public RequestMessage parse(FaceAddFaceRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            Set<String> imageUrls = request.getUrlSet();
            HashSet<String> imagePaths = new HashSet<String>();
            if (!TextUtils.isEmpty((CharSequence)request.getImagePath())) {
                imagePaths.add(request.getImagePath());
            }
            if ((imageUrls == null || imageUrls.isEmpty()) && (imagePaths == null || imagePaths.isEmpty())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            if (imageUrls != null && !imageUrls.isEmpty()) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    if (TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                        throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
                    }
                    jsonObject.put("person_id", (Object)request.getPersonId());
                    if (!TextUtils.isEmpty((CharSequence)request.getTag())) {
                        jsonObject.put("tag", (Object)request.getTag());
                    }
                    JSONArray urlArray = new JSONArray(imageUrls);
                    jsonObject.put("urls", (Object)urlArray);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (imagePaths != null && !imagePaths.isEmpty()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                if (TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                    throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
                }
                multipartBuilder.addFormDataPart("person_id", request.getPersonId());
                if (!TextUtils.isEmpty((CharSequence)request.getTag())) {
                    multipartBuilder.addFormDataPart("tag", request.getTag());
                }
                Iterator iterator = imagePaths.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    String imagePath = (String)iterator.next();
                    if (imagePath == null) {
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_PATH_NULL);
                    }
                    File file = new File(imagePath);
                    if (file == null || !file.exists()) {
                        QLogger.warn(this.logger, "file : {} is not exist.", imagePath);
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
                    }
                    String fileKey = String.format(Locale.US, "images[%d]", i++);
                    multipartBuilder.addFormDataPart(fileKey, file.getName(), (RequestBody)new FileRequestBody(file, MimeType.getTypeByFileName(file.getName())));
                }
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class FaceDeletePersonRequestParser
    implements RequestParser<FaceDeletePersonRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceDeletePersonRequestParser.class);

        @Override
        public RequestMessage parse(FaceDeletePersonRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            if (TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
            }
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                if (!TextUtils.isEmpty((CharSequence)request.getPersonId())) {
                    jsonObject.put("person_id", (Object)request.getPersonId());
                }
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            return requestMessage;
        }
    }

    public static class FaceNewPersonRequestParser
    implements RequestParser<FaceNewPersonRequest> {
        private Logger logger = LoggerFactory.getLogger(FaceNewPersonRequestParser.class);

        @Override
        public RequestMessage parse(FaceNewPersonRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            File imageFile = request.getImageFile();
            String imageUrl = request.getImageUrl();
            if (TextUtils.isEmpty((CharSequence)imageUrl) && imageFile == null) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    String tag;
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    JSONArray urlArray = new JSONArray(request.getGroupIds());
                    jsonObject.put("group_ids", (Object)urlArray);
                    jsonObject.put("person_id", (Object)request.getPersonId());
                    jsonObject.put("url", (Object)imageUrl);
                    String personName = request.getPersonName();
                    if (!TextUtils.isEmpty((CharSequence)personName)) {
                        jsonObject.put("person_name", (Object)personName);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(tag = request.getTag()))) {
                        jsonObject.put("tag", (Object)tag);
                    }
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (imageFile != null && imageFile.exists()) {
                String tag;
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                Set<String> groupIds = request.getGroupIds();
                if (groupIds != null && !groupIds.isEmpty()) {
                    Iterator<String> iterator = groupIds.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        String groupId = iterator.next();
                        if (TextUtils.isEmpty((CharSequence)groupId)) {
                            throw new ClientException(ClientExceptionType.EXIST_NULL_GROUP_ID);
                        }
                        String fileKey = String.format(Locale.US, "group_ids[%d]", i++);
                        multipartBuilder.addFormDataPart(fileKey, groupId);
                    }
                }
                multipartBuilder.addFormDataPart("person_id", request.getPersonId());
                multipartBuilder.addFormDataPart("image", imageFile.getName(), (RequestBody)new FileRequestBody(imageFile, MimeType.getTypeByFileName(imageFile.getName())));
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
                String personName = request.getPersonName();
                if (!TextUtils.isEmpty((CharSequence)personName)) {
                    multipartBuilder.addFormDataPart("person_name", personName);
                }
                if (!TextUtils.isEmpty((CharSequence)(tag = request.getTag()))) {
                    multipartBuilder.addFormDataPart("tag", tag);
                }
            }
            return requestMessage;
        }
    }

    public static class ImageTagDetectRequestParser
    implements RequestParser<ImageTagDetectRequest> {
        private Logger logger = LoggerFactory.getLogger(PornDetectRequestParser.class);

        @Override
        public RequestMessage parse(ImageTagDetectRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            File imageFile = request.getImageFile();
            String imageUrl = request.getImageUrl();
            if (TextUtils.isEmpty((CharSequence)imageUrl) && imageFile == null) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            headers.put("Content-type", "application/json");
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("appid", (Object)appid);
                jsonObject.put("bucket", (Object)request.getBucket());
                if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                    jsonObject.put("url", (Object)imageUrl);
                } else if (imageFile != null && imageFile.exists()) {
                    FileInputStream fis = new FileInputStream(imageFile);
                    byte[] rs = new byte[fis.available()];
                    if (fis != null) {
                        fis.read(rs);
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    String base64Image = Base64.encodeToString((byte[])rs, (int)2);
                    jsonObject.put("image", (Object)base64Image);
                } else {
                    throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
                }
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                requestMessage = new RequestMessage(serverUrl, headers, requestBody);
            }
            catch (JSONException e) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return requestMessage;
        }
    }

    public static class PornDetectRequestParser
    implements RequestParser<PornDetectRequest> {
        private Logger logger = LoggerFactory.getLogger(PornDetectRequestParser.class);

        @Override
        public RequestMessage parse(PornDetectRequest request, Map<String, String> extraPara) throws ClientException {
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            Set<String> urlList = request.getUrlSet();
            HashSet<String> fileList = new HashSet<String>();
            if (!TextUtils.isEmpty((CharSequence)request.getImagePath())) {
                fileList.add(request.getImagePath());
            }
            if ((urlList == null || urlList.isEmpty()) && (fileList == null || fileList.isEmpty())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            if (urlList != null && !urlList.isEmpty()) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    JSONArray urlArray = new JSONArray(urlList);
                    jsonObject.put("url_list", (Object)urlArray);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (fileList != null && !fileList.isEmpty()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                Iterator iterator = fileList.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    String imagePath = (String)iterator.next();
                    if (imagePath == null) {
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_PATH_NULL);
                    }
                    File file = new File(imagePath);
                    if (file == null || !file.exists()) {
                        QLogger.warn(this.logger, "file : {} is not exist.", imagePath);
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
                    }
                    String fileKey = String.format(Locale.US, "image[%d]", i++);
                    multipartBuilder.addFormDataPart(fileKey, file.getName(), (RequestBody)new FileRequestBody(file, MimeType.getTypeByFileName(file.getName())));
                }
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class OcrNameCardRequestParser
    implements RequestParser<OcrNameCardRequest> {
        private Logger logger = LoggerFactory.getLogger(OcrNameCardRequestParser.class);

        @Override
        public RequestMessage parse(OcrNameCardRequest request, Map<String, String> extraPara) throws ClientException {
            int retImage;
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            Set<String> urlList = request.getUrlSet();
            HashSet<String> fileList = new HashSet<String>();
            if (!TextUtils.isEmpty((CharSequence)request.getImagePath())) {
                fileList.add(request.getImagePath());
            }
            if ((urlList == null || urlList.isEmpty()) && (fileList == null || fileList.isEmpty())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            int n = retImage = request.isRetImage() ? 1 : 0;
            if (urlList != null && !urlList.isEmpty()) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    jsonObject.put("ret_image", retImage);
                    JSONArray urlArray = new JSONArray(urlList);
                    jsonObject.put("url_list", (Object)urlArray);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (fileList != null && !fileList.isEmpty()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                multipartBuilder.addFormDataPart("ret_image", String.valueOf(retImage));
                Iterator iterator = fileList.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    String imagePath = (String)iterator.next();
                    if (imagePath == null) {
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_PATH_NULL);
                    }
                    File file = new File(imagePath);
                    if (file == null || !file.exists()) {
                        QLogger.warn(this.logger, "file : {} is not exist.", imagePath);
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
                    }
                    String fileKey = String.format(Locale.US, "image[%d]", i++);
                    multipartBuilder.addFormDataPart(fileKey, file.getName(), (RequestBody)new FileRequestBody(file, MimeType.getTypeByFileName(file.getName())));
                }
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }

    public static class OcrIdCardRequestParser
    implements RequestParser<OcrIdCardRequest> {
        private Logger logger = LoggerFactory.getLogger(OcrIdCardRequestParser.class);

        @Override
        public RequestMessage parse(OcrIdCardRequest request, Map<String, String> extraPara) throws ClientException {
            int type;
            String serverUrl = extraPara.get("server_url");
            String appid = extraPara.get("appid");
            if (appid == null) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_APP_ID_NOT_EXIST);
            }
            String sign = extraPara.get("Authorization");
            if (TextUtils.isEmpty((CharSequence)sign)) {
                throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_SIGN_NOT_EXIST);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", sign);
            headers.put("User-Agent", "ci-android-sdk-v2.0");
            headers.put("Host", "service.image.myqcloud.com");
            Set<String> urlList = request.getUrlSet();
            HashSet<String> fileList = new HashSet<String>();
            if (!TextUtils.isEmpty((CharSequence)request.getImagePath())) {
                fileList.add(request.getImagePath());
            }
            if ((urlList == null || urlList.isEmpty()) && (fileList == null || fileList.isEmpty())) {
                throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
            }
            RequestMessage requestMessage = null;
            int n = type = request.isFaceSide() ? 0 : 1;
            if (urlList != null && !urlList.isEmpty()) {
                headers.put("Content-type", "application/json");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("appid", (Object)appid);
                    jsonObject.put("bucket", (Object)request.getBucket());
                    jsonObject.put("card_type", type);
                    JSONArray urlArray = new JSONArray(urlList);
                    jsonObject.put("url_list", (Object)urlArray);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
                    requestMessage = new RequestMessage(serverUrl, headers, requestBody);
                }
                catch (JSONException e) {
                    throw new ClientException(ClientExceptionType.Q_IMAGE_REQUEST_PARA_ERROR_TO_JSON);
                }
            } else if (fileList != null && !fileList.isEmpty()) {
                headers.put("Content-type", "multipart/form-data");
                MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
                multipartBuilder = multipartBuilder.setType(MediaType.parse((String)"multipart/form-data"));
                multipartBuilder.addFormDataPart("appid", appid);
                multipartBuilder.addFormDataPart("bucket", request.getBucket());
                multipartBuilder.addFormDataPart("card_type", String.valueOf(type));
                Iterator iterator = fileList.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    String imagePath = (String)iterator.next();
                    if (imagePath == null) {
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_PATH_NULL);
                    }
                    File file = new File(imagePath);
                    if (file == null || !file.exists()) {
                        QLogger.warn(this.logger, "file : {} is not exist.", imagePath);
                        throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
                    }
                    String fileKey = String.format(Locale.US, "image[%d]", i++);
                    multipartBuilder.addFormDataPart(fileKey, file.getName(), (RequestBody)new FileRequestBody(file, MimeType.getTypeByFileName(file.getName())));
                }
                requestMessage = new RequestMessage(serverUrl, headers, (RequestBody)multipartBuilder.build());
            }
            return requestMessage;
        }
    }
}

