/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.task;

public class TaskConfig {
    private int maxConcurrentTaskNumber;
    private int httpConnectTimeout;
    private int httpWriteTimeout;
    private int httpReadTimeout;
    private boolean isHttps;

    private TaskConfig(int maxConcurrentTaskNumber, int httpConnectTimeout, int httpWriteTimeout, int httpReadTimeout, boolean isHttps) {
        this.maxConcurrentTaskNumber = maxConcurrentTaskNumber;
        this.httpConnectTimeout = httpConnectTimeout;
        this.httpReadTimeout = httpReadTimeout;
        this.httpWriteTimeout = httpWriteTimeout;
        this.isHttps = isHttps;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public int getHttpWriteTimeout() {
        return this.httpWriteTimeout;
    }

    public int getMaxConcurrentTaskNumber() {
        return this.maxConcurrentTaskNumber;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public static class Builder {
        private int maxConcurrentTaskNumber;
        private int httpConnectTimeout;
        private int httpReadTimeout;
        private int httpWriteTimeout;
        private boolean isHttps;

        public Builder maxConcurrentTaskNumber(int maxConcurrentTaskNumber) {
            this.maxConcurrentTaskNumber = maxConcurrentTaskNumber;
            return this;
        }

        public Builder httpConnectTimeout(int httpConnectTimeout) {
            this.httpConnectTimeout = httpConnectTimeout;
            return this;
        }

        public Builder httpReadTimeout(int httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
            return this;
        }

        public Builder httpWriteTimeout(int httpWriteTimeout) {
            this.httpWriteTimeout = httpWriteTimeout;
            return this;
        }

        public Builder isHttps(boolean isHttps) {
            this.isHttps = isHttps;
            return this;
        }

        public TaskConfig build() {
            return new TaskConfig(this.maxConcurrentTaskNumber, this.httpConnectTimeout, this.httpWriteTimeout, this.httpReadTimeout, this.isHttps);
        }
    }
}

