/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.QImageGlobalConfig;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;

public final class FaceVerifyRequest
extends QImageRequest {
    private String bucket;
    private String personId;
    private String imageUrl;
    private File imageFile;

    public FaceVerifyRequest(String bucket, String personId, String imageUrl, String sign) {
        super(sign);
        this.bucket = bucket;
        this.personId = personId;
        this.imageUrl = imageUrl;
    }

    public FaceVerifyRequest(String bucket, String personId, String imageUrl) {
        this(bucket, personId, imageUrl, null);
    }

    public FaceVerifyRequest(String bucket, String personId, File imageFile, String sign) {
        super(sign);
        this.bucket = bucket;
        this.personId = personId;
        this.imageFile = imageFile;
    }

    public FaceVerifyRequest(String bucket, String personId, File imageFile) {
        this(bucket, personId, imageFile, null);
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.personId)) {
            throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile == null) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile != null) {
            if (!this.imageFile.exists() || this.imageFile.isDirectory()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
            }
            if (this.imageFile.length() > (long)QImageGlobalConfig.getMaxFaceRecognizeImageSize()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_TOO_LARGE);
            }
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }
}

