/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FaceShapeResult
extends QImageResult {
    private final int code;
    private final String message;
    private final String sessionId;
    private final int imageWidth;
    private final int imageHeight;
    private final List<FaceShape> faceShapes;

    public FaceShapeResult(int httpCode, String httpMessage, int code, String message, String sessionId, int imageWidth, int imageHeight, List<FaceShape> faceShapes) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
        this.sessionId = sessionId;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.faceShapes = faceShapes;
    }

    public FaceShapeResult(int httpCode, String httpMessage, int code, String message) {
        this(httpCode, httpMessage, code, message, null, 0, 0, null);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public List<FaceShape> getFaceShapes() {
        return this.faceShapes;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(String.format(Locale.US, "http code = %d, http message = %s\n", this.httpCode, this.httpMessage));
        desc.append(String.format(Locale.US, "code = %d, message = %s\n", this.code, this.message));
        if (this.code == 0 && this.faceShapes != null && !this.faceShapes.isEmpty()) {
            desc.append(String.format(Locale.US, "session id = %s, image width = %d, image height = %d\n", this.sessionId, this.imageWidth, this.imageHeight));
            int i = 0;
            Iterator<FaceShape> iterator = this.faceShapes.iterator();
            while (iterator.hasNext()) {
                desc.append(String.format(Locale.US, "face %d = \n %s", i++, iterator.next().toString()));
            }
        }
        return desc.toString();
    }

    public static class Point {
        int x;
        int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return String.format(Locale.US, "x = %d, y = %d", this.x, this.y);
        }
    }

    public static class FaceShape {
        List<Point> faceProfile;
        List<Point> leftEye;
        List<Point> rightEye;
        List<Point> leftEyeBrow;
        List<Point> rightEyeBrow;
        List<Point> mouth;
        List<Point> nose;

        public FaceShape(List<Point> faceProfile, List<Point> leftEye, List<Point> rightEye, List<Point> leftEyeBrow, List<Point> rightEyeBrow, List<Point> mouth, List<Point> nose) {
            this.faceProfile = faceProfile;
            this.leftEye = leftEye;
            this.rightEye = rightEye;
            this.leftEyeBrow = leftEyeBrow;
            this.rightEyeBrow = rightEyeBrow;
            this.mouth = mouth;
            this.nose = nose;
        }

        public List<Point> getFaceProfile() {
            return this.faceProfile;
        }

        public List<Point> getLeftEye() {
            return this.leftEye;
        }

        public List<Point> getLeftEyeBrow() {
            return this.leftEyeBrow;
        }

        public List<Point> getMouth() {
            return this.mouth;
        }

        public List<Point> getNose() {
            return this.nose;
        }

        public List<Point> getRightEye() {
            return this.rightEye;
        }

        public List<Point> getRightEyeBrow() {
            return this.rightEyeBrow;
        }

        public String toString() {
            StringBuilder desc = new StringBuilder();
            desc.append("face profile : \n" + this.descPointList(this.faceProfile));
            desc.append("left eye : \n" + this.descPointList(this.leftEye));
            desc.append("right eye : \n" + this.descPointList(this.rightEye));
            desc.append("left eye brow : \n" + this.descPointList(this.leftEyeBrow));
            desc.append("right eye brow : \n" + this.descPointList(this.rightEyeBrow));
            desc.append("mouth : \n" + this.descPointList(this.mouth));
            desc.append("nose : \n" + this.descPointList(this.nose));
            return desc.toString();
        }

        private String descPointList(List<Point> points) {
            StringBuilder desc = new StringBuilder();
            if (points != null && !points.isEmpty()) {
                Iterator<Point> iterator = points.iterator();
                while (iterator.hasNext()) {
                    desc.append(iterator.next().toString() + "\n");
                }
            }
            return desc.toString();
        }
    }
}

