/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.QImageGlobalConfig;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;

public class FaceShapeRequest
extends QImageRequest {
    private String bucket;
    private int mode = 0;
    private String imageUrl;
    private File imageFile;

    public FaceShapeRequest(String bucket, String imageUrl, String sign) {
        super(sign);
        this.bucket = bucket;
        this.imageUrl = imageUrl;
    }

    public FaceShapeRequest(String bucket, String imageUrl) {
        this(bucket, imageUrl, null);
    }

    public FaceShapeRequest(String bucket, File imageFile, String sign) {
        super(sign);
        this.bucket = bucket;
        this.imageFile = imageFile;
    }

    public FaceShapeRequest(String bucket, File imageFile) {
        this(bucket, imageFile, null);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public int getMode() {
        return this.mode;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (this.mode != 0 && this.mode != 1) {
            throw new ClientException(ClientExceptionType.UNSUPPORTED_DETECT_MODE);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile == null) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile != null) {
            if (!this.imageFile.exists() || this.imageFile.isDirectory()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
            }
            if (this.imageFile.length() > (long)QImageGlobalConfig.getMaxFaceRecognizeImageSize()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_TOO_LARGE);
            }
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }
}

