/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.QImageGlobalConfig;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class FaceNewPersonRequest
extends QImageRequest {
    String bucket;
    Set<String> groupIds;
    String personId;
    String imageUrl;
    File imageFile;
    String personName;
    String tag;

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, File imageFile, String personName, String tag, String sign) {
        super(sign);
        this.bucket = bucket;
        this.groupIds = new HashSet<String>(groupIds);
        this.personId = personId;
        this.imageFile = imageFile;
        this.personName = personName;
        this.tag = tag;
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, File imageFile, String personName, String tag, String sign) {
        super(sign);
        this.bucket = bucket;
        this.groupIds = new HashSet<String>();
        this.groupIds.add(groupId);
        this.personId = personId;
        this.imageFile = imageFile;
        this.personName = personName;
        this.tag = tag;
    }

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, File imageFile, String sign) {
        this(bucket, groupIds, personId, imageFile, null, null, sign);
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, File imageFile, String sign) {
        this(bucket, groupId, personId, imageFile, null, null, sign);
    }

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, File imageFile, String personName, String tag) {
        this(bucket, groupIds, personId, imageFile, personName, tag, null);
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, File imageFile, String personName, String tag) {
        this(bucket, groupId, personId, imageFile, personName, tag, null);
    }

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, File imageFile) {
        this(bucket, groupIds, personId, imageFile, null);
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, File imageFile) {
        this(bucket, groupId, personId, imageFile, null);
    }

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, String imageUrl, String personName, String tag, String sign) {
        super(sign);
        this.bucket = bucket;
        this.groupIds = new HashSet<String>(groupIds);
        this.personId = personId;
        this.imageUrl = imageUrl;
        this.personName = personName;
        this.tag = tag;
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, String imageUrl, String personName, String tag, String sign) {
        super(sign);
        this.bucket = bucket;
        this.groupIds = new HashSet<String>();
        this.groupIds.add(groupId);
        this.personId = personId;
        this.imageUrl = imageUrl;
        this.personName = personName;
        this.tag = tag;
    }

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, String imageUrl, String personName, String tag) {
        this(bucket, groupIds, personId, imageUrl, personName, tag, null);
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, String imageUrl, String personName, String tag) {
        this(bucket, groupId, personId, imageUrl, personName, tag, null);
    }

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, String imageUrl, String sign) {
        this(bucket, groupIds, personId, imageUrl, null, null, sign);
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, String imageUrl, String sign) {
        this(bucket, groupId, personId, imageUrl, null, null, sign);
    }

    public FaceNewPersonRequest(String bucket, Set<String> groupIds, String personId, String imageUrl) {
        this(bucket, groupIds, personId, imageUrl, null);
    }

    public FaceNewPersonRequest(String bucket, String groupId, String personId, String imageUrl) {
        this(bucket, groupId, personId, imageUrl, null);
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getPersonId() {
        return this.personId;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (this.groupIds == null || this.groupIds.isEmpty()) {
            throw new ClientException(ClientExceptionType.GROUP_ID_NULL);
        }
        if (TextUtils.isEmpty((CharSequence)this.personId)) {
            throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile == null) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile != null) {
            if (!this.imageFile.exists() || this.imageFile.isDirectory()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
            }
            if (this.imageFile.length() > (long)QImageGlobalConfig.getMaxFaceRecognizeImageSize()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_TOO_LARGE);
            }
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }
}

