/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.QImageGlobalConfig;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;

public class FaceCompareRequest
extends QImageRequest {
    private String bucket;
    private String imageUrl1;
    private String imageUrl2;
    private File imageFile1;
    private File imageFile2;

    public FaceCompareRequest(String bucket, String imageUrl1, String imageUrl2, String sign) {
        super(sign);
        this.bucket = bucket;
        this.imageUrl1 = imageUrl1;
        this.imageUrl2 = imageUrl2;
    }

    public FaceCompareRequest(String bucket, String imageUrl1, String imageUrl2) {
        this(bucket, imageUrl1, imageUrl2, null);
    }

    public FaceCompareRequest(String bucket, File imageFile1, File imageFile2, String sign) {
        super(sign);
        this.bucket = bucket;
        this.imageFile1 = imageFile1;
        this.imageFile2 = imageFile2;
    }

    public FaceCompareRequest(String bucket, File imageFile1, File imageFile2) {
        this(bucket, imageFile1, imageFile2, null);
    }

    public File getImageFile1() {
        return this.imageFile1;
    }

    public File getImageFile2() {
        return this.imageFile2;
    }

    public String getImageUrl1() {
        return this.imageUrl1;
    }

    public String getImageUrl2() {
        return this.imageUrl2;
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if ((TextUtils.isEmpty((CharSequence)this.imageUrl1) || TextUtils.isEmpty((CharSequence)this.imageUrl2)) && (this.imageFile1 == null || this.imageFile2 == null)) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl1) || TextUtils.isEmpty((CharSequence)this.imageUrl2)) {
            if (!this.imageFile1.exists() || this.imageFile1.isDirectory() || !this.imageFile2.exists() || this.imageFile2.isDirectory()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
            }
            if (this.imageFile1.length() + this.imageFile2.length() > (long)QImageGlobalConfig.getMaxFaceRecognizeImageSize()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_TOO_LARGE);
            }
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }
}

