/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.net.body;

import com.tencent.qcloud.image.log.QLogger;
import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRequestBody
extends RequestBody {
    private final Logger logger = LoggerFactory.getLogger(FileRequestBody.class);
    private final File file;
    private final String contentType;

    public FileRequestBody(File file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        long all;
        Source source = Okio.source((File)this.file);
        long remain = all = this.file.length();
        int bufferSize = 2048;
        int percent = 0;
        while (remain > 0L) {
            int progress;
            long maxReadSize = Math.min((long)bufferSize, remain);
            long readLength = source.read(bufferedSink.buffer(), maxReadSize);
            if (readLength == -1L || (progress = (int)Math.floor(100.0 * (double)(all - (remain -= readLength)) / (double)all)) < percent) continue;
            percent += 5;
        }
        QLogger.info(this.logger, "file finished.");
        if (source != null) {
            source.close();
        }
    }

    public long contentLength() throws IOException {
        return this.file.length();
    }
}

