/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.text.TextUtils;
import com.tencent.cos.xml.model.tag.AccessControlPolicy;
import com.tencent.cos.xml.model.tag.BucketLoggingStatus;
import com.tencent.cos.xml.model.tag.CORSConfiguration;
import com.tencent.cos.xml.model.tag.CreateBucketConfiguration;
import com.tencent.cos.xml.model.tag.Delete;
import com.tencent.cos.xml.model.tag.DomainConfiguration;
import com.tencent.cos.xml.model.tag.InventoryConfiguration;
import com.tencent.cos.xml.model.tag.LifecycleConfiguration;
import com.tencent.cos.xml.model.tag.ReplicationConfiguration;
import com.tencent.cos.xml.model.tag.RestoreConfigure;
import com.tencent.cos.xml.model.tag.Tagging;
import com.tencent.cos.xml.model.tag.VersioningConfiguration;
import com.tencent.cos.xml.model.tag.WebsiteConfiguration;
import com.tencent.cos.xml.model.tag.eventstreaming.CSVInput;
import com.tencent.cos.xml.model.tag.eventstreaming.CSVOutput;
import com.tencent.cos.xml.model.tag.eventstreaming.JSONInput;
import com.tencent.cos.xml.model.tag.eventstreaming.JSONOutput;
import com.tencent.cos.xml.model.tag.eventstreaming.SelectRequest;
import com.tencent.cos.xml.transfer.XmlSlimBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class XmlBuilder
extends XmlSlimBuilder {
    public static String buildPutBucketAccelerateXML(boolean enable) throws XmlPullParserException, IOException {
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "AccelerateConfiguration");
        XmlBuilder.addElement(xmlSerializer, "Status", enable ? "Enabled" : "Suspended");
        xmlSerializer.endTag("", "AccelerateConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildAccessControlPolicyXML(AccessControlPolicy accessControlPolicy) throws XmlPullParserException, IOException {
        if (accessControlPolicy == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "AccessControlPolicy");
        xmlSerializer.startTag("", "Owner");
        XmlBuilder.addElement(xmlSerializer, "ID", accessControlPolicy.owner.id);
        xmlSerializer.endTag("", "Owner");
        xmlSerializer.startTag("", "AccessControlList");
        for (AccessControlPolicy.Grant grant : accessControlPolicy.accessControlList.grants) {
            xmlSerializer.startTag("", "Grant");
            if (!TextUtils.isEmpty((CharSequence)grant.grantee.uri)) {
                xmlSerializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xmlSerializer.startTag("", "Grantee");
                xmlSerializer.attribute("", "xsi:type", "CanonicalUser");
                XmlBuilder.addElement(xmlSerializer, "URI", grant.grantee.uri);
                xmlSerializer.endTag("", "Grantee");
            } else if (!TextUtils.isEmpty((CharSequence)grant.grantee.id)) {
                xmlSerializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xmlSerializer.startTag("", "Grantee");
                xmlSerializer.attribute("", "xsi:type", "Group");
                XmlBuilder.addElement(xmlSerializer, "ID", grant.grantee.id);
                xmlSerializer.endTag("", "Grantee");
            }
            XmlBuilder.addElement(xmlSerializer, "Permission", grant.permission);
            xmlSerializer.endTag("", "Grant");
        }
        xmlSerializer.endTag("", "AccessControlList");
        xmlSerializer.endTag("", "AccessControlPolicy");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildCORSConfigurationXML(CORSConfiguration corsConfiguration) throws XmlPullParserException, IOException {
        if (corsConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "CORSConfiguration");
        if (corsConfiguration.corsRules != null) {
            for (CORSConfiguration.CORSRule corsRule : corsConfiguration.corsRules) {
                if (corsRule == null) continue;
                xmlSerializer.startTag("", "CORSRule");
                XmlBuilder.addElement(xmlSerializer, "ID", corsRule.id);
                XmlBuilder.addElement(xmlSerializer, "AllowedOrigin", corsRule.allowedOrigin);
                if (corsRule.allowedMethod != null) {
                    for (String allowedMethod : corsRule.allowedMethod) {
                        XmlBuilder.addElement(xmlSerializer, "AllowedMethod", allowedMethod);
                    }
                }
                if (corsRule.allowedHeader != null) {
                    for (String allowedHeader : corsRule.allowedHeader) {
                        XmlBuilder.addElement(xmlSerializer, "AllowedHeader", allowedHeader);
                    }
                }
                if (corsRule.exposeHeader != null) {
                    for (String exposeHeader : corsRule.exposeHeader) {
                        XmlBuilder.addElement(xmlSerializer, "ExposeHeader", exposeHeader);
                    }
                }
                XmlBuilder.addElement(xmlSerializer, "MaxAgeSeconds", String.valueOf(corsRule.maxAgeSeconds));
                xmlSerializer.endTag("", "CORSRule");
            }
        }
        xmlSerializer.endTag("", "CORSConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildLifecycleConfigurationXML(LifecycleConfiguration lifecycleConfiguration) throws XmlPullParserException, IOException {
        if (lifecycleConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "LifecycleConfiguration");
        if (lifecycleConfiguration.rules != null) {
            for (LifecycleConfiguration.Rule rule : lifecycleConfiguration.rules) {
                if (rule == null) continue;
                xmlSerializer.startTag("", "Rule");
                XmlBuilder.addElement(xmlSerializer, "ID", rule.id);
                if (rule.filter != null) {
                    xmlSerializer.startTag("", "Filter");
                    XmlBuilder.addElement(xmlSerializer, "Prefix", rule.filter.prefix);
                    xmlSerializer.endTag("", "Filter");
                }
                XmlBuilder.addElement(xmlSerializer, "Status", rule.status);
                if (rule.transition != null) {
                    xmlSerializer.startTag("", "Transition");
                    XmlBuilder.addElement(xmlSerializer, "Days", String.valueOf(rule.transition.days));
                    XmlBuilder.addElement(xmlSerializer, "StorageClass", rule.transition.storageClass);
                    XmlBuilder.addElement(xmlSerializer, "Date", rule.transition.date);
                    xmlSerializer.endTag("", "Transition");
                }
                if (rule.expiration != null) {
                    xmlSerializer.startTag("", "Expiration");
                    XmlBuilder.addElement(xmlSerializer, "Days", String.valueOf(rule.expiration.days));
                    XmlBuilder.addElement(xmlSerializer, "ExpiredObjectDeleteMarker", rule.expiration.expiredObjectDeleteMarker);
                    XmlBuilder.addElement(xmlSerializer, "Date", rule.expiration.date);
                    xmlSerializer.endTag("", "Expiration");
                }
                if (rule.noncurrentVersionTransition != null) {
                    xmlSerializer.startTag("", "NoncurrentVersionTransition");
                    XmlBuilder.addElement(xmlSerializer, "NoncurrentDays", String.valueOf(rule.noncurrentVersionTransition.noncurrentDays));
                    XmlBuilder.addElement(xmlSerializer, "StorageClass", rule.noncurrentVersionTransition.storageClass);
                    xmlSerializer.endTag("", "NoncurrentVersionTransition");
                }
                if (rule.noncurrentVersionExpiration != null) {
                    xmlSerializer.startTag("", "NoncurrentVersionExpiration");
                    XmlBuilder.addElement(xmlSerializer, "NoncurrentDays", String.valueOf(rule.noncurrentVersionExpiration.noncurrentDays));
                    xmlSerializer.endTag("", "NoncurrentVersionExpiration");
                }
                if (rule.abortIncompleteMultiUpload != null) {
                    xmlSerializer.startTag("", "AbortIncompleteMultipartUpload");
                    XmlBuilder.addElement(xmlSerializer, "DaysAfterInitiation", String.valueOf(rule.abortIncompleteMultiUpload.daysAfterInitiation));
                    xmlSerializer.endTag("", "AbortIncompleteMultipartUpload");
                }
                xmlSerializer.endTag("", "Rule");
            }
        }
        xmlSerializer.endTag("", "LifecycleConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildReplicationConfiguration(ReplicationConfiguration replicationConfiguration) throws XmlPullParserException, IOException {
        if (replicationConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "ReplicationConfiguration");
        XmlBuilder.addElement(xmlSerializer, "Role", replicationConfiguration.role);
        if (replicationConfiguration.rules != null) {
            for (ReplicationConfiguration.Rule rule : replicationConfiguration.rules) {
                if (rule == null) continue;
                xmlSerializer.startTag("", "Rule");
                XmlBuilder.addElement(xmlSerializer, "Status", rule.status);
                XmlBuilder.addElement(xmlSerializer, "ID", rule.id);
                XmlBuilder.addElement(xmlSerializer, "Prefix", rule.prefix);
                if (rule.destination != null) {
                    xmlSerializer.startTag("", "Destination");
                    XmlBuilder.addElement(xmlSerializer, "Bucket", rule.destination.bucket);
                    XmlBuilder.addElement(xmlSerializer, "StorageClass", rule.destination.storageClass);
                    xmlSerializer.endTag("", "Destination");
                }
                xmlSerializer.endTag("", "Rule");
            }
        }
        xmlSerializer.endTag("", "ReplicationConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildVersioningConfiguration(VersioningConfiguration versioningConfiguration) throws XmlPullParserException, IOException {
        if (versioningConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "VersioningConfiguration");
        XmlBuilder.addElement(xmlSerializer, "Status", versioningConfiguration.status);
        xmlSerializer.endTag("", "VersioningConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildCreateBucketConfiguration(CreateBucketConfiguration createBucketConfiguration) throws XmlPullParserException, IOException {
        if (createBucketConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "CreateBucketConfiguration");
        XmlBuilder.addElement(xmlSerializer, "BucketAZConfig", createBucketConfiguration.bucketAzConfig);
        xmlSerializer.endTag("", "CreateBucketConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildDelete(Delete delete) throws XmlPullParserException, IOException {
        if (delete == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "Delete");
        XmlBuilder.addElement(xmlSerializer, "Quiet", String.valueOf(delete.quiet));
        if (delete.deleteObjects != null) {
            for (Delete.DeleteObject deleteObject : delete.deleteObjects) {
                if (deleteObject == null) continue;
                xmlSerializer.startTag("", "Object");
                XmlBuilder.addElement(xmlSerializer, "Key", deleteObject.key);
                XmlBuilder.addElement(xmlSerializer, "VersionId", deleteObject.versionId);
                xmlSerializer.endTag("", "Object");
            }
        }
        xmlSerializer.endTag("", "Delete");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildRestore(RestoreConfigure restoreConfigure) throws XmlPullParserException, IOException {
        if (restoreConfigure == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "RestoreRequest");
        XmlBuilder.addElement(xmlSerializer, "Days", String.valueOf(restoreConfigure.days));
        if (restoreConfigure.casJobParameters != null) {
            xmlSerializer.startTag("", "CASJobParameters");
            XmlBuilder.addElement(xmlSerializer, "Tier", restoreConfigure.casJobParameters.tier);
            xmlSerializer.endTag("", "CASJobParameters");
        }
        xmlSerializer.endTag("", "RestoreRequest");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildBucketLogging(BucketLoggingStatus bucketLoggingStatus) throws XmlPullParserException, IOException {
        if (bucketLoggingStatus == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "BucketLoggingStatus");
        if (bucketLoggingStatus.loggingEnabled != null) {
            xmlSerializer.startTag("", "LoggingEnabled");
            XmlBuilder.addElement(xmlSerializer, "TargetBucket", bucketLoggingStatus.loggingEnabled.targetBucket);
            XmlBuilder.addElement(xmlSerializer, "TargetPrefix", bucketLoggingStatus.loggingEnabled.targetPrefix);
            xmlSerializer.endTag("", "LoggingEnabled");
        }
        xmlSerializer.endTag("", "BucketLoggingStatus");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildTagging(Tagging tagging) throws XmlPullParserException, IOException {
        if (tagging == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "Tagging");
        xmlSerializer.startTag("", "TagSet");
        if (!tagging.tagSet.tags.isEmpty()) {
            for (Tagging.Tag tag : tagging.tagSet.tags) {
                xmlSerializer.startTag("", "Tag");
                XmlBuilder.addElement(xmlSerializer, "Key", tag.key);
                XmlBuilder.addElement(xmlSerializer, "Value", tag.value);
                xmlSerializer.endTag("", "Tag");
            }
        }
        xmlSerializer.endTag("", "TagSet");
        xmlSerializer.endTag("", "Tagging");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildWebsiteConfiguration(WebsiteConfiguration websiteConfiguration) throws XmlPullParserException, IOException {
        if (websiteConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "WebsiteConfiguration");
        if (websiteConfiguration.indexDocument != null) {
            xmlSerializer.startTag("", "IndexDocument");
            if (websiteConfiguration.indexDocument.suffix != null) {
                XmlBuilder.addElement(xmlSerializer, "Suffix", websiteConfiguration.indexDocument.suffix);
            }
            xmlSerializer.endTag("", "IndexDocument");
        }
        if (websiteConfiguration.errorDocument != null) {
            xmlSerializer.startTag("", "ErrorDocument");
            if (websiteConfiguration.errorDocument.key != null) {
                XmlBuilder.addElement(xmlSerializer, "Key", websiteConfiguration.errorDocument.key);
            }
            xmlSerializer.endTag("", "ErrorDocument");
        }
        if (websiteConfiguration.redirectAllRequestTo != null) {
            xmlSerializer.startTag("", "RedirectAllRequestTo");
            if (websiteConfiguration.redirectAllRequestTo.protocol != null) {
                XmlBuilder.addElement(xmlSerializer, "Protocol", websiteConfiguration.redirectAllRequestTo.protocol);
            }
            xmlSerializer.endTag("", "RedirectAllRequestTo");
        }
        if (websiteConfiguration.routingRules != null && websiteConfiguration.routingRules.size() > 0) {
            xmlSerializer.startTag("", "RoutingRules");
            for (WebsiteConfiguration.RoutingRule routingRule : websiteConfiguration.routingRules) {
                xmlSerializer.startTag("", "RoutingRule");
                if (routingRule.contidion != null) {
                    xmlSerializer.startTag("", "Condition");
                    if (routingRule.contidion.httpErrorCodeReturnedEquals != -1) {
                        XmlBuilder.addElement(xmlSerializer, "HttpErrorCodeReturnedEquals", String.valueOf(routingRule.contidion.httpErrorCodeReturnedEquals));
                    }
                    if (routingRule.contidion.keyPrefixEquals != null) {
                        XmlBuilder.addElement(xmlSerializer, "KeyPrefixEquals", routingRule.contidion.keyPrefixEquals);
                    }
                    xmlSerializer.endTag("", "Condition");
                }
                if (routingRule.redirect != null) {
                    xmlSerializer.startTag("", "Redirect");
                    if (routingRule.redirect.protocol != null) {
                        XmlBuilder.addElement(xmlSerializer, "Protocol", routingRule.redirect.protocol);
                    }
                    if (routingRule.redirect.replaceKeyPrefixWith != null) {
                        XmlBuilder.addElement(xmlSerializer, "ReplaceKeyPrefixWith", routingRule.redirect.replaceKeyPrefixWith);
                    }
                    if (routingRule.redirect.replaceKeyWith != null) {
                        XmlBuilder.addElement(xmlSerializer, "ReplaceKeyWith", routingRule.redirect.replaceKeyWith);
                    }
                    xmlSerializer.endTag("", "Redirect");
                }
                xmlSerializer.endTag("", "RoutingRule");
            }
            xmlSerializer.endTag("", "RoutingRules");
        }
        xmlSerializer.endTag("", "WebsiteConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildInventoryConfiguration(InventoryConfiguration inventoryConfiguration) throws IOException, XmlPullParserException {
        if (inventoryConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "InventoryConfiguration");
        if (inventoryConfiguration.id != null) {
            XmlBuilder.addElement(xmlSerializer, "Id", inventoryConfiguration.id);
        }
        XmlBuilder.addElement(xmlSerializer, "IsEnabled", inventoryConfiguration.isEnabled ? "true" : "false");
        if (inventoryConfiguration.destination != null) {
            xmlSerializer.startTag("", "Destination");
            if (inventoryConfiguration.destination.cosBucketDestination != null) {
                xmlSerializer.startTag("", "COSBucketDestination");
                if (inventoryConfiguration.destination.cosBucketDestination.format != null) {
                    XmlBuilder.addElement(xmlSerializer, "Format", inventoryConfiguration.destination.cosBucketDestination.format);
                }
                if (inventoryConfiguration.destination.cosBucketDestination.accountId != null) {
                    XmlBuilder.addElement(xmlSerializer, "AccountId", inventoryConfiguration.destination.cosBucketDestination.accountId);
                }
                if (inventoryConfiguration.destination.cosBucketDestination.bucket != null) {
                    XmlBuilder.addElement(xmlSerializer, "Bucket", inventoryConfiguration.destination.cosBucketDestination.bucket);
                }
                if (inventoryConfiguration.destination.cosBucketDestination.prefix != null) {
                    XmlBuilder.addElement(xmlSerializer, "Prefix", inventoryConfiguration.destination.cosBucketDestination.prefix);
                }
                if (inventoryConfiguration.destination.cosBucketDestination.encryption != null) {
                    xmlSerializer.startTag("", "Encryption");
                    XmlBuilder.addElement(xmlSerializer, "SSE-COS", inventoryConfiguration.destination.cosBucketDestination.encryption.sSECOS);
                    xmlSerializer.endTag("", "Encryption");
                }
                xmlSerializer.endTag("", "COSBucketDestination");
            }
            xmlSerializer.endTag("", "Destination");
        }
        if (inventoryConfiguration.schedule != null && inventoryConfiguration.schedule.frequency != null) {
            xmlSerializer.startTag("", "Schedule");
            XmlBuilder.addElement(xmlSerializer, "Frequency", inventoryConfiguration.schedule.frequency);
            xmlSerializer.endTag("", "Schedule");
        }
        if (inventoryConfiguration.filter != null && inventoryConfiguration.filter.prefix != null) {
            xmlSerializer.startTag("", "Filter");
            XmlBuilder.addElement(xmlSerializer, "Prefix", inventoryConfiguration.filter.prefix);
            xmlSerializer.endTag("", "Filter");
        }
        if (inventoryConfiguration.includedObjectVersions != null) {
            XmlBuilder.addElement(xmlSerializer, "IncludedObjectVersions", inventoryConfiguration.includedObjectVersions);
        }
        if (inventoryConfiguration.optionalFields != null && inventoryConfiguration.optionalFields.fields != null) {
            xmlSerializer.startTag("", "OptionalFields");
            for (String field : inventoryConfiguration.optionalFields.fields) {
                XmlBuilder.addElement(xmlSerializer, "Field", field);
            }
            xmlSerializer.endTag("", "OptionalFields");
        }
        xmlSerializer.endTag("", "InventoryConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildDomainConfiguration(DomainConfiguration domainConfiguration) throws IOException, XmlPullParserException {
        if (domainConfiguration == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "DomainConfiguration");
        if (domainConfiguration.domainRules != null && domainConfiguration.domainRules.size() > 0) {
            for (DomainConfiguration.DomainRule rule : domainConfiguration.domainRules) {
                xmlSerializer.startTag("", "DomainRule");
                XmlBuilder.addElement(xmlSerializer, "Status", rule.status);
                XmlBuilder.addElement(xmlSerializer, "Name", rule.name);
                XmlBuilder.addElement(xmlSerializer, "Type", rule.type);
                XmlBuilder.addElement(xmlSerializer, "ForcedReplacement", rule.forcedReplacement);
                xmlSerializer.endTag("", "DomainRule");
            }
        }
        xmlSerializer.endTag("", "DomainConfiguration");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    public static String buildSelectRequest(SelectRequest selectRequest) throws IOException, XmlPullParserException {
        if (selectRequest == null) {
            return null;
        }
        StringWriter xmlContent = new StringWriter();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
        xmlSerializer.setOutput((Writer)xmlContent);
        xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xmlSerializer.startDocument("UTF-8", null);
        xmlSerializer.startTag("", "SelectRequest");
        XmlBuilder.addElement(xmlSerializer, "Expression", selectRequest.getExpression());
        XmlBuilder.addElement(xmlSerializer, "ExpressionType", selectRequest.getExpressionType());
        xmlSerializer.startTag("", "InputSerialization");
        XmlBuilder.addElement(xmlSerializer, "CompressionType", selectRequest.getInputSerialization().getCompressionType());
        if (selectRequest.getInputSerialization().getCsv() != null) {
            CSVInput csvInput = selectRequest.getInputSerialization().getCsv();
            xmlSerializer.startTag("", "CSV");
            XmlBuilder.addElement(xmlSerializer, "FileHeaderInfo", csvInput.getFileHeaderInfo());
            XmlBuilder.addElement(xmlSerializer, "RecordDelimiter", csvInput.getRecordDelimiterAsString());
            XmlBuilder.addElement(xmlSerializer, "FieldDelimiter", csvInput.getFieldDelimiterAsString());
            XmlBuilder.addElement(xmlSerializer, "QuoteCharacter", csvInput.getQuoteCharacterAsString());
            XmlBuilder.addElement(xmlSerializer, "QuoteEscapeCharacter", csvInput.getQuoteEscapeCharacterAsString());
            XmlBuilder.addElement(xmlSerializer, "Comments", csvInput.getCommentsAsString());
            XmlBuilder.addElement(xmlSerializer, "AllowQuotedRecordDelimiter", csvInput.getAllowQuotedRecordDelimiter() != false ? "TRUE" : "FALSE");
            xmlSerializer.endTag("", "CSV");
        } else if (selectRequest.getInputSerialization().getJson() != null) {
            JSONInput jsonInput = selectRequest.getInputSerialization().getJson();
            xmlSerializer.startTag("", "JSON");
            XmlBuilder.addElement(xmlSerializer, "Type", jsonInput.getType());
            xmlSerializer.endTag("", "JSON");
        }
        xmlSerializer.endTag("", "InputSerialization");
        xmlSerializer.startTag("", "OutputSerialization");
        if (selectRequest.getOutputSerialization().getCsv() != null) {
            CSVOutput csvOutput = selectRequest.getOutputSerialization().getCsv();
            xmlSerializer.startTag("", "CSV");
            XmlBuilder.addElement(xmlSerializer, "QuoteFields", csvOutput.getQuoteFields());
            XmlBuilder.addElement(xmlSerializer, "RecordDelimiter", csvOutput.getRecordDelimiterAsString());
            XmlBuilder.addElement(xmlSerializer, "FieldDelimiter", csvOutput.getFieldDelimiterAsString());
            XmlBuilder.addElement(xmlSerializer, "QuoteCharacter", csvOutput.getQuoteCharacterAsString());
            XmlBuilder.addElement(xmlSerializer, "QuoteEscapeCharacter", csvOutput.getQuoteEscapeCharacterAsString());
            xmlSerializer.endTag("", "CSV");
        } else if (selectRequest.getOutputSerialization().getJson() != null) {
            JSONOutput jsonOutput = selectRequest.getOutputSerialization().getJson();
            xmlSerializer.startTag("", "JSON");
            XmlBuilder.addElement(xmlSerializer, "RecordDelimiter", jsonOutput.getRecordDelimiterAsString());
            xmlSerializer.endTag("", "JSON");
        }
        xmlSerializer.endTag("", "OutputSerialization");
        xmlSerializer.startTag("", "RequestProgress");
        XmlBuilder.addElement(xmlSerializer, "Enabled", String.valueOf(selectRequest.getRequestProgress().getEnabled()));
        xmlSerializer.endTag("", "RequestProgress");
        xmlSerializer.endTag("", "SelectRequest");
        xmlSerializer.endDocument();
        return XmlBuilder.removeXMLHeader(xmlContent.toString());
    }

    private static void addElement(XmlSerializer xmlSerializer, String tag, String value) throws IOException {
        if (value != null) {
            xmlSerializer.startTag("", tag);
            xmlSerializer.text(value);
            xmlSerializer.endTag("", tag);
        }
    }

    private static String removeXMLHeader(String xmlContent) {
        if (xmlContent != null && xmlContent.startsWith("<?xml")) {
            int index = xmlContent.indexOf("?>");
            xmlContent = xmlContent.substring(index + 2);
        }
        return xmlContent;
    }
}

