/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model;

import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.auth.STSCredentialScope;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CosXmlRequest {
    protected Map<String, String> queryParameters = new LinkedHashMap<String, String>();
    private String queryParameterEncodedString;
    protected Map<String, List<String>> requestHeaders = new LinkedHashMap<String, List<String>>();
    protected List<String> noSignHeaders = new LinkedList<String>();
    protected QCloudSignSourceProvider signSourceProvider;
    private HttpTask httpTask;
    private HttpTaskMetrics metrics;
    private boolean isNeedMD5 = false;
    private boolean isSupportAccelerate = false;
    protected String bucket;
    protected String requestURL;
    protected String region;
    private boolean signInUrl;
    private OnRequestWeightListener onRequestWeightListener;
    protected QCloudTaskStateListener qCloudTaskStateListener;

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public abstract String getMethod();

    public abstract String getPath(CosXmlServiceConfig var1);

    public String getBucket() {
        return this.bucket;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setQueryEncodedString(String queryParameterString) {
        this.queryParameterEncodedString = queryParameterString;
    }

    public void setRequestHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            this.requestHeaders.putAll(headers);
        }
    }

    public void addNoSignHeader(String key) {
        if (!TextUtils.isEmpty((CharSequence)key)) {
            this.noSignHeaders.add(key);
        }
    }

    public List<String> getNoSignHeaders() {
        return this.noSignHeaders;
    }

    public Map<String, String> getQueryString() {
        return this.queryParameters;
    }

    public String getQueryEncodedString() {
        return this.queryParameterEncodedString;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public abstract RequestBodySerializer getRequestBody() throws CosXmlClientException;

    public abstract void checkParameters() throws CosXmlClientException;

    public boolean isNeedMD5() {
        return this.isNeedMD5;
    }

    public void setNeedMD5(boolean isNeedMD5) {
        this.isNeedMD5 = isNeedMD5;
    }

    public void setTaskStateListener(QCloudTaskStateListener qCloudTaskStateListener) {
        this.qCloudTaskStateListener = qCloudTaskStateListener;
    }

    public HttpTaskMetrics getMetrics() {
        return this.metrics;
    }

    public void attachMetrics(HttpTaskMetrics metrics) {
        this.metrics = metrics;
    }

    public void setSignInUrl(boolean signInUrl) {
        this.signInUrl = signInUrl;
    }

    public boolean isSignInUrl() {
        return this.signInUrl;
    }

    @Deprecated
    public void setRequestHeaders(String key, String value) throws CosXmlClientException {
        if (key != null && value != null) {
            value = URLEncodeUtils.cosPathEncode(value);
            this.addHeader(key, value);
        }
    }

    public void setRequestHeaders(String key, String value, boolean isUrlEncoder) throws CosXmlClientException {
        if (key != null && value != null) {
            if (isUrlEncoder) {
                value = URLEncodeUtils.cosPathEncode(value);
            }
            this.addHeader(key, value);
        }
    }

    protected void addHeader(String key, String value) {
        List<String> values = this.requestHeaders.containsKey(key) ? this.requestHeaders.get(key) : new ArrayList<String>();
        values.add(value);
        this.requestHeaders.put(key, values);
    }

    public String getRequestHost(CosXmlServiceConfig config) {
        return config.getRequestHost(this.region, this.bucket, this.isSupportAccelerate);
    }

    public void isSupportAccelerate(boolean isSupportAccelerate) {
        this.isSupportAccelerate = isSupportAccelerate;
    }

    public boolean isSupportAccelerate() {
        return this.isSupportAccelerate;
    }

    public void setSign(String sign) {
        this.addHeader("Authorization", sign);
    }

    public QCloudSignSourceProvider getSignSourceProvider() {
        if (this.signSourceProvider == null) {
            this.signSourceProvider = new COSXmlSignSourceProvider();
        }
        return this.signSourceProvider;
    }

    public void setSignSourceProvider(QCloudSignSourceProvider cosXmlSignSourceProvider) {
        this.signSourceProvider = cosXmlSignSourceProvider;
    }

    public STSCredentialScope[] getSTSCredentialScope(CosXmlServiceConfig config) {
        String action = "name/cos:" + this.getClass().getSimpleName().replace("Request", "");
        STSCredentialScope scope = new STSCredentialScope(action, config.getBucket(this.bucket), config.getRegion(), this.getPath(config));
        return scope.toArray();
    }

    @Deprecated
    public void setSign(long signDuration) {
    }

    @Deprecated
    public void setSign(long startTime, long endTime) {
    }

    @Deprecated
    public void setSign(long signDuration, Set<String> parameters, Set<String> headers) {
        this.setSignParamsAndHeaders(parameters, headers);
    }

    @Deprecated
    public void setSign(long startTime, long endTime, Set<String> parameters, Set<String> headers) {
        this.setSignParamsAndHeaders(parameters, headers);
    }

    public void setSignParamsAndHeaders(Set<String> parameters, Set<String> headers) {
        COSXmlSignSourceProvider cosXmlSignSourceProvider = new COSXmlSignSourceProvider();
        cosXmlSignSourceProvider.parameters(parameters);
        cosXmlSignSourceProvider.headers(headers);
        this.signSourceProvider = cosXmlSignSourceProvider;
    }

    public void setRegion(String region) {
        if (!TextUtils.isEmpty((CharSequence)region)) {
            this.region = region;
        }
    }

    public String getRegion() {
        return this.region;
    }

    public void setTask(HttpTask httpTask) {
        this.httpTask = httpTask;
        httpTask.addStateListener(this.qCloudTaskStateListener);
        httpTask.attachMetric(this.metrics);
    }

    public HttpTask getHttpTask() {
        return this.httpTask;
    }

    public int getPriority() {
        return -1;
    }

    public int getWeight() {
        return this.onRequestWeightListener != null ? this.onRequestWeightListener.onWeight() : 0;
    }

    public void setOnRequestWeightListener(OnRequestWeightListener onRequestWeightListener) {
        this.onRequestWeightListener = onRequestWeightListener;
    }

    public static interface OnRequestWeightListener {
        public int onWeight();
    }
}

