/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.CopyObject;
import com.tencent.cos.xml.model.tag.CosError;
import com.tencent.cos.xml.transfer.XmlSlimParser;
import com.tencent.cos.xml.utils.CloseUtil;
import com.tencent.qcloud.core.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParserException;

public class CopyObjectResult
extends CosXmlResult {
    public CopyObject copyObject;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        ByteArrayInputStream inputStream = null;
        try {
            this.copyObject = new CopyObject();
            byte[] contents = response.bytes();
            inputStream = new ByteArrayInputStream(contents);
            XmlSlimParser.parseCopyObjectResult(inputStream, this.copyObject);
            if (this.copyObject.eTag == null && contents != null && contents.length > 0) {
                ((InputStream)inputStream).reset();
                CosXmlServiceException cosXmlServiceException = new CosXmlServiceException("failed");
                CosError cosError = new CosError();
                XmlSlimParser.parseError(inputStream, cosError);
                cosXmlServiceException.setErrorCode(cosError.code);
                cosXmlServiceException.setErrorMessage(cosError.message);
                cosXmlServiceException.setRequestId(cosError.requestId);
                cosXmlServiceException.setServiceName(cosError.resource);
                cosXmlServiceException.setStatusCode(response.code());
                throw cosXmlServiceException;
            }
        }
        catch (XmlPullParserException e) {
            try {
                throw new CosXmlClientException(ClientErrorCode.SERVERERROR.getCode(), e);
                catch (IOException e2) {
                    throw new CosXmlClientException(ClientErrorCode.POOR_NETWORK.getCode(), e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(inputStream);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(inputStream);
    }

    @Override
    public String printResult() {
        return this.copyObject != null ? this.copyObject.toString() : super.printResult();
    }
}

