/*
 * Copyright (c) 2010-2020 Tencent Cloud. All rights reserved.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 */

package com.tencent.cos.xml.model.tag;

/**
 * 存储桶日志状态信息
 */
public class BucketLoggingStatus {

    /**
     * 存储桶日志记录配置详细信息
     */
    public LoggingEnabled loggingEnabled;

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{BucketLoggingStatus:\n");
        if(loggingEnabled != null)stringBuilder.append(loggingEnabled.toString()).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static class LoggingEnabled{
        /**
         * 存放日志的目标存储桶，可以是同一个存储桶（但不推荐），或同一账户下、同一地域的存储桶
         */
        public String targetBucket;
        /**
         * 日志存放在目标存储桶的指定路径
         */
        public String targetPrefix;

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{LoggingEnabled:\n");
            stringBuilder.append("TargetBucket:").append(targetBucket).append("\n");
            stringBuilder.append("TargetPrefix:").append(targetPrefix).append("\n");
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}
