/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

public class TransferConfig {
    protected long divisionForCopy;
    protected long sliceSizeForCopy;
    protected long divisionForUpload;
    protected long sliceSizeForUpload;
    private boolean forceSimpleUpload;

    TransferConfig(Builder builder) {
        this.divisionForCopy = builder.divisionForCopy;
        this.sliceSizeForCopy = builder.sliceSizeForCopy;
        this.divisionForUpload = builder.divisionForUpload;
        this.sliceSizeForUpload = builder.sliceSizeForUpload;
        this.forceSimpleUpload = builder.forceSimpleUpload;
    }

    public long getDivisionForCopy() {
        return this.divisionForCopy;
    }

    public boolean isForceSimpleUpload() {
        return this.forceSimpleUpload;
    }

    public static class Builder {
        private long divisionForCopy = 0x500000L;
        private long sliceSizeForCopy = 0x500000L;
        private long divisionForUpload = 0x200000L;
        private long sliceSizeForUpload = 0x100000L;
        private boolean forceSimpleUpload = false;

        public Builder setDividsionForCopy(long division) {
            if (division > 0L) {
                this.divisionForCopy = division;
            }
            return this;
        }

        public Builder setDivisionForUpload(long division) {
            if (division > 0L) {
                this.divisionForUpload = division;
            }
            return this;
        }

        public Builder setSliceSizeForCopy(long sliceSizee) {
            if (sliceSizee > 0L) {
                this.sliceSizeForCopy = sliceSizee;
            }
            return this;
        }

        public Builder setSliceSizeForUpload(long sliceSizee) {
            if (sliceSizee > 0L) {
                this.sliceSizeForUpload = sliceSizee;
            }
            return this;
        }

        public Builder setForceSimpleUpload(boolean forceSimpleUpload) {
            this.forceSimpleUpload = forceSimpleUpload;
            return this;
        }

        public TransferConfig build() {
            return new TransferConfig(this);
        }
    }
}

