/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.text.TextUtils;
import com.tencent.cos.xml.listener.SelectObjectContentListener;
import com.tencent.cos.xml.model.object.SelectObjectContentResult;
import com.tencent.cos.xml.model.tag.eventstreaming.Message;
import com.tencent.cos.xml.model.tag.eventstreaming.MessageDecoder;
import com.tencent.cos.xml.model.tag.eventstreaming.SelectObjectContentEvent;
import com.tencent.cos.xml.model.tag.eventstreaming.SelectObjectContentEventUnmarshaller;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class SelectObjectContentConverter<T>
extends ResponseBodyConverter<T> {
    private SelectObjectContentResult selectObjectContentResult;
    private SelectObjectContentListener contentListener;
    private MessageDecoder messageDecoder;
    private String localPath;

    public SelectObjectContentConverter(SelectObjectContentResult selectObjectContentResult, String localPath) {
        this.selectObjectContentResult = selectObjectContentResult;
        this.messageDecoder = new MessageDecoder();
        this.localPath = localPath;
    }

    public T convert(HttpResponse<T> response) throws QCloudClientException, QCloudServiceException {
        HttpResponse.checkResponseSuccessful(response);
        InputStream inputStream = response.byteStream();
        byte[] payload = new byte[256];
        FileOutputStream fileOutputStream = this.newFileOutputStream(this.localPath);
        try {
            int read = 0;
            while ((read = inputStream.read(payload)) > 0) {
                List<Message> messages = this.messageDecoder.feed(payload, 0, read);
                if (fileOutputStream != null) {
                    fileOutputStream.write(payload, 0, read);
                }
                for (Message message : messages) {
                    SelectObjectContentEvent event = SelectObjectContentEventUnmarshaller.unmarshalMessage(message);
                    if (this.contentListener == null) continue;
                    this.contentListener.onProcess(event);
                }
            }
            this.closeFileOutputStream(fileOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QCloudClientException((Throwable)e);
        }
        return (T)this.selectObjectContentResult;
    }

    public void setContentListener(SelectObjectContentListener contentListener) {
        this.contentListener = contentListener;
    }

    private FileOutputStream newFileOutputStream(String path) throws QCloudClientException {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        try {
            if (file.createNewFile()) {
                return new FileOutputStream(file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QCloudClientException((Throwable)e);
        }
        return null;
    }

    private void closeFileOutputStream(FileOutputStream fileOutputStream) throws QCloudClientException {
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new QCloudClientException((Throwable)e);
            }
        }
    }
}

