/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.beacon.core.info.BeaconPubParams;
import com.tencent.beacon.event.open.BeaconConfig;
import com.tencent.beacon.event.open.BeaconEvent;
import com.tencent.beacon.event.open.BeaconReport;
import com.tencent.beacon.event.open.EventResult;
import com.tencent.beacon.event.open.EventType;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.DnsRepository;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;

public class BeaconService {
    private static final String TAG = "BeaconProxy";
    private static final String APP_KEY = "0AND0VEVB24UBGDU";
    private static final boolean IS_DEBUG = false;
    private static final String EVENT_CODE_BASE_SERVICE = "base_service";
    private static final String EVENT_CODE_DOWNLOAD = "cos_download";
    private static final String EVENT_CODE_UPLOAD = "cos_upload";
    private static final String EVENT_CODE_COPY = "cos_copy";
    private static final String EVENT_CODE_ERROR = "cos_error";
    private static final String EVENT_PARAMS_SUCCESS = "Success";
    private static final String EVENT_PARAMS_FAILURE = "Failure";
    private static final String EVENT_PARAMS_SERVER = "Server";
    private static final String EVENT_PARAMS_CLIENT = "Client";
    public static final String EVENT_PARAMS_NODE_HEAD = "HeadObjectRequest";
    public static final String EVENT_PARAMS_NODE_GET = "GetObjectRequest";
    private Context applicationContext;
    private CosXmlServiceConfig config;
    private static BeaconService instance;

    private BeaconService(Context applicationContext, CosXmlServiceConfig config) {
        this.applicationContext = applicationContext;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context applicationContext, CosXmlServiceConfig serviceConfig) {
        Class<BeaconService> clazz = BeaconService.class;
        synchronized (BeaconService.class) {
            if (instance == null) {
                instance = new BeaconService(applicationContext, serviceConfig);
                if (BeaconService.isIncludeBeacon()) {
                    BeaconConfig config = BeaconConfig.builder().auditEnable(false).bidEnable(false).collectMACEnable(false).collectIMEIEnable(false).pagePathEnable(false).setNormalPollingTime(5000L).build();
                    BeaconReport beaconReport = BeaconReport.getInstance();
                    beaconReport.setLogAble(false);
                    beaconReport.start(applicationContext, APP_KEY, config);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static BeaconService getInstance() {
        return instance;
    }

    private void report(String eventcode, Map<String, String> params) {
        if (!BeaconService.isIncludeBeacon()) {
            return;
        }
        BeaconEvent.Builder builder = BeaconEvent.builder().withAppKey(APP_KEY).withCode(eventcode).withType(EventType.NORMAL).withParams(params);
        try {
            builder.withIsSimpleParams(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        EventResult result = BeaconReport.getInstance().report(builder.build());
        QCloudLogger.d((String)TAG, (String)("EventResult{ eventID:" + result.eventID + ", errorCode: " + result.errorCode + ", errorMsg: " + result.errMsg + "}"), (Object[])new Object[0]);
    }

    public void reportBaseService(CosXmlRequest cosXmlRequest, long tookTime) {
        if (this.isReport(cosXmlRequest)) {
            Map<String, String> params = this.getBaseServiceParams(cosXmlRequest, tookTime, true);
            this.report(EVENT_CODE_BASE_SERVICE, params);
        }
    }

    public CosXmlClientException reportBaseService(CosXmlRequest cosXmlRequest, long tookTime, QCloudClientException e) {
        ReturnClientException returnClientException = this.getClientExceptionParams(e);
        if (this.isReport(returnClientException.exception) && this.isReport(cosXmlRequest)) {
            Map<String, String> params = this.getBaseServiceParams(cosXmlRequest, tookTime, false);
            params.putAll(returnClientException.params);
            this.report(EVENT_CODE_BASE_SERVICE, params);
        }
        return returnClientException.exception;
    }

    public CosXmlServiceException reportBaseService(CosXmlRequest cosXmlRequest, long tookTime, QCloudServiceException e) {
        ReturnServiceException returnServiceException = this.getServiceExceptionParams(e);
        if (this.isReport(returnServiceException.exception) && this.isReport(cosXmlRequest)) {
            Map<String, String> params = this.getBaseServiceParams(cosXmlRequest, tookTime, false);
            params.putAll(returnServiceException.params);
            this.report(EVENT_CODE_BASE_SERVICE, params);
        }
        return returnServiceException.exception;
    }

    public void reportDownload(String region, long size, long tookTime) {
        Map<String, String> params = this.getDownloadParams(region, true);
        params.put("took_time", String.valueOf(tookTime));
        params.put("size", String.valueOf(size));
        this.report(EVENT_CODE_DOWNLOAD, params);
    }

    public void reportDownload(String region, String error_node, QCloudClientException e) {
        ReturnClientException returnClientException = this.getClientExceptionParams(e);
        if (this.isReport(returnClientException.exception)) {
            Map<String, String> params = this.getDownloadParams(region, false);
            params.putAll(returnClientException.params);
            params.put("error_node", error_node);
            this.report(EVENT_CODE_DOWNLOAD, params);
        }
    }

    public void reportDownload(String region, String error_node, QCloudServiceException e) {
        ReturnServiceException returnServiceException = this.getServiceExceptionParams(e);
        if (this.isReport(returnServiceException.exception)) {
            Map<String, String> params = this.getDownloadParams(region, false);
            params.putAll(returnServiceException.params);
            params.put("error_node", error_node);
            this.report(EVENT_CODE_DOWNLOAD, params);
        }
    }

    public void reportUpload(String region, long size, long tookTime) {
        Map<String, String> params = this.getUploadParams(region, true);
        params.put("took_time", String.valueOf(tookTime));
        params.put("size", String.valueOf(size));
        this.report(EVENT_CODE_UPLOAD, params);
    }

    public void reportUpload(String region, String error_node, QCloudClientException e) {
        ReturnClientException returnClientException = this.getClientExceptionParams(e);
        if (this.isReport(returnClientException.exception)) {
            Map<String, String> params = this.getUploadParams(region, false);
            params.putAll(returnClientException.params);
            params.put("error_node", error_node);
            this.report(EVENT_CODE_UPLOAD, params);
        }
    }

    public void reportUpload(String region, String error_node, QCloudServiceException e) {
        ReturnServiceException returnServiceException = this.getServiceExceptionParams(e);
        if (this.isReport(returnServiceException.exception)) {
            Map<String, String> params = this.getUploadParams(region, false);
            params.putAll(returnServiceException.params);
            params.put("error_node", error_node);
            this.report(EVENT_CODE_UPLOAD, params);
        }
    }

    public void reportCopy(String region) {
        Map<String, String> params = this.getUploadParams(region, true);
        this.report(EVENT_CODE_COPY, params);
    }

    public void reportCopy(String region, String error_node, QCloudClientException e) {
        ReturnClientException returnClientException = this.getClientExceptionParams(e);
        if (this.isReport(returnClientException.exception)) {
            Map<String, String> params = this.getUploadParams(region, false);
            params.putAll(returnClientException.params);
            params.put("error_node", error_node);
            this.report(EVENT_CODE_COPY, params);
        }
    }

    public void reportCopy(String region, String error_node, QCloudServiceException e) {
        ReturnServiceException returnServiceException = this.getServiceExceptionParams(e);
        if (this.isReport(returnServiceException.exception)) {
            Map<String, String> params = this.getUploadParams(region, false);
            params.putAll(returnServiceException.params);
            params.put("error_node", error_node);
            this.report(EVENT_CODE_COPY, params);
        }
    }

    public void reportError(String source, Exception e) {
        Map<String, String> params = this.getCommonParams();
        params.put("source", source);
        params.put("name", e.getClass().getSimpleName());
        params.put("message", e.getMessage());
        this.report(EVENT_CODE_ERROR, params);
    }

    private static boolean isIncludeBeacon() {
        try {
            Class.forName("com.tencent.beacon.event.open.BeaconReport");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Map<String, String> getBaseServiceParams(CosXmlRequest cosXmlRequest, long tookTime, boolean isSuccess) {
        Map<String, String> params = this.getCommonParams();
        params.put("result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
        params.put("took_time", String.valueOf(tookTime));
        params.put("name", cosXmlRequest.getClass().getSimpleName());
        params.put("region", TextUtils.isEmpty((CharSequence)cosXmlRequest.getRegion()) ? this.config.getRegion() : cosXmlRequest.getRegion());
        params.put("accelerate", cosXmlRequest.isSupportAccelerate() ? "Y" : "N");
        if (!isSuccess) {
            String host;
            HttpTaskMetrics metrics = cosXmlRequest.getMetrics();
            if (metrics != null) {
                params.put("http_dns", String.valueOf(metrics.dnsLookupTookTime()));
                params.put("http_connect", String.valueOf(metrics.connectTookTime()));
                params.put("http_secure_connect", String.valueOf(metrics.secureConnectTookTime()));
                params.put("http_md5", String.valueOf(metrics.calculateMD5STookTime()));
                params.put("http_sign", String.valueOf(metrics.signRequestTookTime()));
                params.put("http_read_header", String.valueOf(metrics.readResponseHeaderTookTime()));
                params.put("http_read_body", String.valueOf(metrics.readResponseBodyTookTime()));
                params.put("http_write_header", String.valueOf(metrics.writeRequestHeaderTookTime()));
                params.put("http_write_body", String.valueOf(metrics.writeRequestBodyTookTime()));
                params.put("http_full", String.valueOf(metrics.fullTaskTookTime()));
            }
            if ((host = cosXmlRequest.getRequestHost(this.config)) != null) {
                params.put("host", host);
                try {
                    StringBuilder ipString = new StringBuilder();
                    List ips = DnsRepository.getInstance().getDnsRecord(host);
                    for (InetAddress ip : ips) {
                        ipString.append(ip.getHostAddress());
                        ipString.append(",");
                    }
                    params.put("ips", ipString.toString());
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        }
        return params;
    }

    private Map<String, String> getDownloadParams(String region, boolean isSuccess) {
        Map<String, String> params = this.getCommonParams();
        params.put("result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
        params.put("region", region);
        return params;
    }

    private Map<String, String> getUploadParams(String region, boolean isSuccess) {
        Map<String, String> params = this.getCommonParams();
        params.put("result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
        params.put("region", region);
        return params;
    }

    private Map<String, String> getCommonParams() {
        if (!BeaconService.isIncludeBeacon()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        BeaconPubParams pubParams = BeaconReport.getInstance().getCommonParams(this.applicationContext);
        params.put("boundle_id", pubParams.getBoundleId());
        params.put("network_type", pubParams.getNetworkType());
        params.put("cossdk_version", "5.5.8");
        return params;
    }

    private ReturnServiceException getServiceExceptionParams(QCloudServiceException e) {
        HashMap<String, String> params = new HashMap<String, String>();
        CosXmlServiceException serviceException = this.convertServerException(e);
        params.put("error_message", serviceException.getErrorMessage());
        params.put("error_code", serviceException.getErrorCode());
        params.put("error_status_code", String.valueOf(serviceException.getStatusCode()));
        params.put("error_service_name", serviceException.getServiceName());
        params.put("error_type", EVENT_PARAMS_SERVER);
        return new ReturnServiceException(serviceException, params);
    }

    private ReturnClientException getClientExceptionParams(QCloudClientException e) {
        HashMap<String, String> params = new HashMap<String, String>();
        CosXmlClientException xmlClientException = this.convertClientException(e);
        String name = xmlClientException.getCause() == null ? ((Object)((Object)xmlClientException)).getClass().getSimpleName() : xmlClientException.getCause().getClass().getSimpleName();
        String message = xmlClientException.getCause() == null ? xmlClientException.getMessage() : xmlClientException.getCause().getMessage();
        params.put("error_name", name);
        params.put("error_message", message);
        params.put("error_code", String.valueOf(xmlClientException.errorCode));
        params.put("error_type", EVENT_PARAMS_CLIENT);
        return new ReturnClientException(xmlClientException, params);
    }

    private CosXmlServiceException convertServerException(QCloudServiceException e) {
        return e instanceof CosXmlServiceException ? (CosXmlServiceException)e : new CosXmlServiceException(e);
    }

    private CosXmlClientException convertClientException(QCloudClientException e) {
        CosXmlClientException xmlClientException;
        if (!TextUtils.isEmpty((CharSequence)e.getMessage()) && e.getMessage().contains("NetworkNotConnected")) {
            return new CosXmlClientException(ClientErrorCode.NETWORK_NOT_CONNECTED.getCode(), e);
        }
        if (e instanceof CosXmlClientException) {
            xmlClientException = (CosXmlClientException)e;
            if (e.getCause() instanceof IOException) {
                xmlClientException = new CosXmlClientException(this.subdivisionIOException(e.getCause()), e);
            }
        } else {
            Throwable causeException = e.getCause();
            xmlClientException = causeException instanceof IllegalArgumentException ? new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e) : (causeException instanceof QCloudAuthenticationException ? new CosXmlClientException(ClientErrorCode.INVALID_CREDENTIALS.getCode(), e) : (causeException instanceof IOException ? new CosXmlClientException(this.subdivisionIOException(causeException), e) : new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e)));
        }
        return xmlClientException;
    }

    private int subdivisionIOException(Throwable causeException) {
        if (causeException instanceof FileNotFoundException) {
            return ClientErrorCode.SINK_SOURCE_NOT_FOUND.getCode();
        }
        if (causeException instanceof UnknownHostException) {
            return 200032;
        }
        if (causeException instanceof SocketTimeoutException) {
            return 200033;
        }
        if (causeException instanceof ConnectException) {
            return 200034;
        }
        if (causeException instanceof HttpRetryException) {
            return 200035;
        }
        if (causeException instanceof NoRouteToHostException) {
            return 200036;
        }
        if (causeException instanceof SSLHandshakeException && !(causeException.getCause() instanceof CertificateException)) {
            return 200037;
        }
        return ClientErrorCode.IO_ERROR.getCode();
    }

    private boolean isReport(CosXmlRequest cosXmlRequest) {
        String requestName = cosXmlRequest.getClass().getSimpleName();
        return !"PutObjectRequest".equals(requestName) && !EVENT_PARAMS_NODE_GET.equals(requestName) && !"SelectObjectContentRequest".equals(requestName) && !"InitMultipartUploadRequest".equals(requestName) && !"ListPartsRequest".equals(requestName) && !"UploadPartRequest".equals(requestName) && !"CompleteMultiUploadRequest".equals(requestName) && !"AbortMultiUploadRequest".equals(requestName) && !"UploadPartCopyRequest".equals(requestName);
    }

    private boolean isReport(CosXmlServiceException e) {
        return "BadDigest".equals(e.getErrorCode()) || "EntitySizeNotMatch".equals(e.getErrorCode()) || "IncompleteBody".equals(e.getErrorCode()) || "InvalidDigest".equals(e.getErrorCode()) || "InvalidSHA1Digest".equals(e.getErrorCode()) || "MalformedPOSTRequest".equals(e.getErrorCode()) || "MalformedXML".equals(e.getErrorCode()) || "MissingRequestBodyError".equals(e.getErrorCode()) || "RequestTimeout".equals(e.getErrorCode()) || "XMLSizeLimit".equals(e.getErrorCode()) || "SignatureDoesNotMatch".equals(e.getErrorCode()) || "MissingContentLength".equals(e.getErrorCode());
    }

    private boolean isReport(CosXmlClientException e) {
        return e.errorCode == ClientErrorCode.UNKNOWN.getCode() || e.errorCode == ClientErrorCode.INTERNAL_ERROR.getCode() || e.errorCode == ClientErrorCode.SERVERERROR.getCode() || e.errorCode == ClientErrorCode.IO_ERROR.getCode() || e.errorCode == 200032 || e.errorCode == 200033 || e.errorCode == 200034 || e.errorCode == 200035 || e.errorCode == 200036 || e.errorCode == 200037;
    }

    private static class PoorNetworkCode {
        private static final int UnknownHostException = 200032;
        private static final int SocketTimeoutException = 200033;
        private static final int ConnectException = 200034;
        private static final int HttpRetryException = 200035;
        private static final int NoRouteToHostException = 200036;
        private static final int SSLHandshakeException = 200037;

        private PoorNetworkCode() {
        }
    }

    private static class ReturnClientException {
        private final CosXmlClientException exception;
        private final Map<String, String> params;

        public ReturnClientException(CosXmlClientException exception, Map<String, String> params) {
            this.exception = exception;
            this.params = params;
        }
    }

    private static class ReturnServiceException {
        private final CosXmlServiceException exception;
        private final Map<String, String> params;

        public ReturnServiceException(CosXmlServiceException exception, Map<String, String> params) {
            this.exception = exception;
            this.params = params;
        }
    }
}

